/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.notedb;

import com.google.auto.value.AutoValue;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.Table;
import com.google.gerrit.common.Nullable;
import com.google.gerrit.metrics.Timer1;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.reviewdb.client.RefNames;
import com.google.gerrit.server.GerritPersonIdent;
import com.google.gerrit.server.config.AllUsersName;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.gerrit.server.git.InMemoryInserter;
import com.google.gerrit.server.git.InsertedObject;
import com.google.gerrit.server.git.LockFailureException;
import com.google.gerrit.server.notedb.AbstractChangeUpdate;
import com.google.gerrit.server.notedb.AutoValue_NoteDbUpdateManager_Result;
import com.google.gerrit.server.notedb.AutoValue_NoteDbUpdateManager_StagedResult;
import com.google.gerrit.server.notedb.ChangeDraftUpdate;
import com.google.gerrit.server.notedb.ChangeUpdate;
import com.google.gerrit.server.notedb.NoteDbChangeState;
import com.google.gerrit.server.notedb.NoteDbMetrics;
import com.google.gerrit.server.notedb.NoteDbTable;
import com.google.gerrit.server.notedb.NotesMigration;
import com.google.gerrit.server.notedb.RobotCommentUpdate;
import com.google.gerrit.server.update.ChainedReceiveCommands;
import com.google.gwtorm.server.OrmConcurrencyException;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Provider;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.eclipse.jgit.lib.BatchRefUpdate;
import org.eclipse.jgit.lib.NullProgressMonitor;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.transport.ReceiveCommand;

public class NoteDbUpdateManager
implements AutoCloseable {
    public static final String CHANGES_READ_ONLY = "NoteDb changes are read-only";
    private final Provider<PersonIdent> serverIdent;
    private final GitRepositoryManager repoManager;
    private final NotesMigration migration;
    private final AllUsersName allUsersName;
    private final NoteDbMetrics metrics;
    private final Project.NameKey projectName;
    private final ListMultimap<String, ChangeUpdate> changeUpdates;
    private final ListMultimap<String, ChangeDraftUpdate> draftUpdates;
    private final ListMultimap<String, RobotCommentUpdate> robotCommentUpdates;
    private final Set<Change.Id> toDelete;
    private OpenRepo changeRepo;
    private OpenRepo allUsersRepo;
    private Map<Change.Id, StagedResult> staged;
    private boolean checkExpectedState = true;
    private String refLogMessage;
    private PersonIdent refLogIdent;

    @AssistedInject
    NoteDbUpdateManager(@GerritPersonIdent Provider<PersonIdent> serverIdent, GitRepositoryManager repoManager, NotesMigration migration, AllUsersName allUsersName, NoteDbMetrics metrics, @Assisted Project.NameKey projectName) {
        this.serverIdent = serverIdent;
        this.repoManager = repoManager;
        this.migration = migration;
        this.allUsersName = allUsersName;
        this.metrics = metrics;
        this.projectName = projectName;
        this.changeUpdates = MultimapBuilder.hashKeys().arrayListValues().build();
        this.draftUpdates = MultimapBuilder.hashKeys().arrayListValues().build();
        this.robotCommentUpdates = MultimapBuilder.hashKeys().arrayListValues().build();
        this.toDelete = new HashSet<Change.Id>();
    }

    @Override
    public void close() {
        OpenRepo r;
        try {
            if (this.allUsersRepo != null) {
                r = this.allUsersRepo;
                this.allUsersRepo = null;
                r.close();
            }
        }
        finally {
            if (this.changeRepo != null) {
                r = this.changeRepo;
                this.changeRepo = null;
                r.close();
            }
        }
    }

    public NoteDbUpdateManager setChangeRepo(Repository repo, RevWalk rw, @Nullable ObjectInserter ins, ChainedReceiveCommands cmds) {
        Preconditions.checkState(this.changeRepo == null, "change repo already initialized");
        this.changeRepo = new OpenRepo(repo, rw, ins, cmds, false);
        return this;
    }

    public NoteDbUpdateManager setAllUsersRepo(Repository repo, RevWalk rw, @Nullable ObjectInserter ins, ChainedReceiveCommands cmds) {
        Preconditions.checkState(this.allUsersRepo == null, "All-Users repo already initialized");
        this.allUsersRepo = new OpenRepo(repo, rw, ins, cmds, false);
        return this;
    }

    public NoteDbUpdateManager setCheckExpectedState(boolean checkExpectedState) {
        this.checkExpectedState = checkExpectedState;
        return this;
    }

    public NoteDbUpdateManager setRefLogMessage(String message) {
        this.refLogMessage = message;
        return this;
    }

    public NoteDbUpdateManager setRefLogIdent(PersonIdent ident) {
        this.refLogIdent = ident;
        return this;
    }

    public OpenRepo getChangeRepo() throws IOException {
        this.initChangeRepo();
        return this.changeRepo;
    }

    public OpenRepo getAllUsersRepo() throws IOException {
        this.initAllUsersRepo();
        return this.allUsersRepo;
    }

    private void initChangeRepo() throws IOException {
        if (this.changeRepo == null) {
            this.changeRepo = this.openRepo(this.projectName);
        }
    }

    private void initAllUsersRepo() throws IOException {
        if (this.allUsersRepo == null) {
            this.allUsersRepo = this.openRepo(this.allUsersName);
        }
    }

    private OpenRepo openRepo(Project.NameKey p) throws IOException {
        Repository repo = this.repoManager.openRepository(p);
        ObjectInserter ins = repo.newObjectInserter();
        final ObjectReader reader = ins.newReader();
        try (RevWalk rw = new RevWalk(reader);){
            OpenRepo openRepo = new OpenRepo(repo, rw, ins, new ChainedReceiveCommands(repo), true){

                @Override
                public void close() {
                    reader.close();
                    super.close();
                }
            };
            return openRepo;
        }
    }

    private boolean isEmpty() {
        if (!this.migration.commitChangeWrites()) {
            return true;
        }
        return this.changeUpdates.isEmpty() && this.draftUpdates.isEmpty() && this.robotCommentUpdates.isEmpty() && this.toDelete.isEmpty();
    }

    public void add(ChangeUpdate update) {
        RobotCommentUpdate rcu;
        Preconditions.checkArgument(update.getProjectName().equals(this.projectName), "update for project %s cannot be added to manager for project %s", (Object)update.getProjectName(), (Object)this.projectName);
        Preconditions.checkState(this.staged == null, "cannot add new update after staging");
        this.changeUpdates.put(update.getRefName(), update);
        ChangeDraftUpdate du = update.getDraftUpdate();
        if (du != null) {
            this.draftUpdates.put(du.getRefName(), du);
        }
        if ((rcu = update.getRobotCommentUpdate()) != null) {
            this.robotCommentUpdates.put(rcu.getRefName(), rcu);
        }
    }

    public void add(ChangeDraftUpdate draftUpdate) {
        Preconditions.checkState(this.staged == null, "cannot add new update after staging");
        this.draftUpdates.put(draftUpdate.getRefName(), draftUpdate);
    }

    public void deleteChange(Change.Id id) {
        Preconditions.checkState(this.staged == null, "cannot add new change to delete after staging");
        this.toDelete.add(id);
    }

    public Map<Change.Id, StagedResult> stage() throws OrmException, IOException {
        if (this.staged != null) {
            return this.staged;
        }
        try (Timer1.Context timer = this.metrics.stageUpdateLatency.start(NoteDbTable.CHANGES);){
            this.staged = new HashMap<Change.Id, StagedResult>();
            if (this.isEmpty()) {
                Map<Change.Id, StagedResult> map = this.staged;
                return map;
            }
            this.initChangeRepo();
            if (!this.draftUpdates.isEmpty() || !this.toDelete.isEmpty()) {
                this.initAllUsersRepo();
            }
            this.checkExpectedState();
            this.addCommands();
            Table<Change.Id, Account.Id, ObjectId> allDraftIds = this.getDraftIds();
            HashSet<Change.Id> changeIds = new HashSet<Change.Id>();
            for (ReceiveCommand cmd : this.changeRepo.getCommandsSnapshot()) {
                Change.Id changeId = Change.Id.fromRef(cmd.getRefName());
                changeIds.add(changeId);
                Optional<ObjectId> metaId = Optional.of(cmd.getNewId());
                this.staged.put(changeId, StagedResult.create(changeId, NoteDbChangeState.Delta.create(changeId, metaId, allDraftIds.rowMap().remove(changeId)), this.changeRepo, this.allUsersRepo));
            }
            for (Map.Entry<Change.Id, Map<Account.Id, ObjectId>> e : allDraftIds.rowMap().entrySet()) {
                StagedResult r = StagedResult.create(e.getKey(), NoteDbChangeState.Delta.create(e.getKey(), Optional.empty(), e.getValue()), this.changeRepo, this.allUsersRepo);
                Preconditions.checkState(r.changeCommands().isEmpty(), "should not have change commands when updating only drafts: %s", (Object)r);
                this.staged.put(r.id(), r);
            }
            Map<Change.Id, StagedResult> map = this.staged;
            return map;
        }
    }

    public Result stageAndApplyDelta(Change change) throws OrmException, IOException {
        StagedResult sr = this.stage().get(change.getId());
        NoteDbChangeState newState = NoteDbChangeState.applyDelta(change, sr != null ? sr.delta() : null);
        return Result.create(sr, newState);
    }

    private Table<Change.Id, Account.Id, ObjectId> getDraftIds() {
        HashBasedTable<Change.Id, Account.Id, ObjectId> draftIds = HashBasedTable.create();
        if (this.allUsersRepo == null) {
            return draftIds;
        }
        for (ReceiveCommand cmd : this.allUsersRepo.getCommandsSnapshot()) {
            String r = cmd.getRefName();
            if (!r.startsWith("refs/draft-comments/")) continue;
            Change.Id changeId = Change.Id.fromRefPart(r.substring("refs/draft-comments/".length()));
            Account.Id accountId = Account.Id.fromRefSuffix(r);
            NoteDbUpdateManager.checkDraftRef(accountId != null && changeId != null, r);
            draftIds.put(changeId, accountId, cmd.getNewId());
        }
        return draftIds;
    }

    public void flush() throws IOException {
        if (this.changeRepo != null) {
            this.changeRepo.flush();
        }
        if (this.allUsersRepo != null) {
            this.allUsersRepo.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws OrmException, IOException {
        if (this.migration.failChangeWrites()) {
            throw new OrmException(CHANGES_READ_ONLY);
        }
        if (this.isEmpty()) {
            return;
        }
        try (Timer1.Context timer = this.metrics.updateLatency.start(NoteDbTable.CHANGES);){
            this.stage();
            this.execute(this.changeRepo);
            this.execute(this.allUsersRepo);
        }
        finally {
            this.close();
        }
    }

    private void execute(OpenRepo or) throws IOException {
        if (or == null || or.cmds.isEmpty()) {
            return;
        }
        or.flush();
        BatchRefUpdate bru = or.repo.getRefDatabase().newBatchUpdate();
        bru.setRefLogMessage(MoreObjects.firstNonNull(this.refLogMessage, "Update NoteDb refs"), false);
        bru.setRefLogIdent(this.refLogIdent != null ? this.refLogIdent : this.serverIdent.get());
        or.cmds.addTo(bru);
        bru.setAllowNonFastForwards(true);
        bru.execute(or.rw, NullProgressMonitor.INSTANCE);
        boolean lockFailure = false;
        for (ReceiveCommand cmd : bru.getCommands()) {
            if (cmd.getResult() == ReceiveCommand.Result.LOCK_FAILURE) {
                lockFailure = true;
                continue;
            }
            if (cmd.getResult() == ReceiveCommand.Result.OK) continue;
            throw new IOException("Update failed: " + bru);
        }
        if (lockFailure) {
            throw new LockFailureException("Update failed with one or more lock failures: " + bru);
        }
    }

    private void addCommands() throws OrmException, IOException {
        if (this.isEmpty()) {
            return;
        }
        Preconditions.checkState(this.changeRepo != null, "must set change repo");
        if (!this.draftUpdates.isEmpty()) {
            Preconditions.checkState(this.allUsersRepo != null, "must set all users repo");
        }
        NoteDbUpdateManager.addUpdates(this.changeUpdates, this.changeRepo);
        if (!this.draftUpdates.isEmpty()) {
            NoteDbUpdateManager.addUpdates(this.draftUpdates, this.allUsersRepo);
        }
        if (!this.robotCommentUpdates.isEmpty()) {
            NoteDbUpdateManager.addUpdates(this.robotCommentUpdates, this.changeRepo);
        }
        for (Change.Id id : this.toDelete) {
            this.doDelete(id);
        }
        this.checkExpectedState();
    }

    private void doDelete(Change.Id id) throws IOException {
        String metaRef = RefNames.changeMetaRef(id);
        Optional<ObjectId> old = this.changeRepo.cmds.get(metaRef);
        if (old.isPresent()) {
            this.changeRepo.cmds.add(new ReceiveCommand(old.get(), ObjectId.zeroId(), metaRef));
        }
        for (Ref r : this.allUsersRepo.repo.getRefDatabase().getRefs(RefNames.refsDraftCommentsPrefix(id)).values()) {
            old = this.allUsersRepo.cmds.get(r.getName());
            if (!old.isPresent()) continue;
            this.allUsersRepo.cmds.add(new ReceiveCommand(old.get(), ObjectId.zeroId(), r.getName()));
        }
    }

    private void checkExpectedState() throws OrmException, IOException {
        NoteDbChangeState expectedState;
        AbstractChangeUpdate u;
        if (!this.checkExpectedState) {
            return;
        }
        for (Collection<ChangeUpdate> collection : this.changeUpdates.asMap().values()) {
            u = collection.iterator().next();
            expectedState = NoteDbChangeState.parse(u.getChange());
            if (expectedState == null || expectedState.getPrimaryStorage() == NoteDbChangeState.PrimaryStorage.NOTE_DB || expectedState.isChangeUpToDate(this.changeRepo.cmds.getRepoRefCache())) continue;
            throw new MismatchedStateException(u.getId(), expectedState);
        }
        for (Collection<AbstractChangeUpdate> collection : this.draftUpdates.asMap().values()) {
            u = (ChangeDraftUpdate)collection.iterator().next();
            expectedState = NoteDbChangeState.parse(u.getChange());
            if (expectedState == null || expectedState.getPrimaryStorage() == NoteDbChangeState.PrimaryStorage.NOTE_DB) continue;
            Account.Id accountId = u.getAccountId();
            if (expectedState.areDraftsUpToDate(this.allUsersRepo.cmds.getRepoRefCache(), accountId)) continue;
            ObjectId expectedDraftId = MoreObjects.firstNonNull(expectedState.getDraftIds().get(accountId), ObjectId.zeroId());
            throw new OrmConcurrencyException(String.format("cannot apply NoteDb updates for change %s; draft ref for account %s does not match %s", u.getId(), accountId, expectedDraftId.name()));
        }
    }

    private static <U extends AbstractChangeUpdate> void addUpdates(ListMultimap<String, U> all, OpenRepo or) throws OrmException, IOException {
        for (Map.Entry<String, Collection<U>> e : all.asMap().entrySet()) {
            ObjectId old;
            String refName = e.getKey();
            Collection<U> updates = e.getValue();
            if (!NoteDbUpdateManager.allowWrite(updates, old = or.cmds.get(refName).orElse(ObjectId.zeroId()))) continue;
            ObjectId curr = old;
            for (AbstractChangeUpdate u : updates) {
                ObjectId next = u.apply(or.rw, or.tempIns, curr);
                if (next == null) continue;
                curr = next;
            }
            if (old.equals(curr)) continue;
            or.cmds.add(new ReceiveCommand(old, curr, refName));
        }
    }

    private static <U extends AbstractChangeUpdate> boolean allowWrite(Collection<U> updates, ObjectId old) {
        if (!old.equals(ObjectId.zeroId())) {
            return true;
        }
        return ((AbstractChangeUpdate)updates.iterator().next()).allowWriteToNewRef();
    }

    private static void checkDraftRef(boolean condition, String refName) {
        Preconditions.checkState(condition, "invalid draft ref: %s", (Object)refName);
    }

    public static class MismatchedStateException
    extends OrmException {
        private static final long serialVersionUID = 1L;

        private MismatchedStateException(Change.Id id, NoteDbChangeState expectedState) {
            super(String.format("cannot apply NoteDb updates for change %s; change meta ref does not match %s", id, expectedState.getChangeMetaId().name()));
        }
    }

    public static class OpenRepo
    implements AutoCloseable {
        public final Repository repo;
        public final RevWalk rw;
        public final ChainedReceiveCommands cmds;
        private final InMemoryInserter tempIns;
        @Nullable
        private final ObjectInserter finalIns;
        private final boolean close;

        private OpenRepo(Repository repo, RevWalk rw, @Nullable ObjectInserter ins, ChainedReceiveCommands cmds, boolean close) {
            ObjectReader reader = rw.getObjectReader();
            Preconditions.checkArgument(ins == null || reader.getCreatedFromInserter() == ins, "expected reader to be created from %s, but was %s", (Object)ins, (Object)reader.getCreatedFromInserter());
            this.repo = Preconditions.checkNotNull(repo);
            this.tempIns = new InMemoryInserter(rw.getObjectReader());
            this.rw = new RevWalk(this.tempIns.newReader());
            this.finalIns = ins;
            this.cmds = Preconditions.checkNotNull(cmds);
            this.close = close;
        }

        public Optional<ObjectId> getObjectId(String refName) throws IOException {
            return this.cmds.get(refName);
        }

        ImmutableList<ReceiveCommand> getCommandsSnapshot() {
            return ImmutableList.copyOf(this.cmds.getCommands().values());
        }

        void flush() throws IOException {
            Preconditions.checkState(this.finalIns != null);
            for (InsertedObject obj : this.tempIns.getInsertedObjects()) {
                this.finalIns.insert(obj.type(), obj.data().toByteArray());
            }
            this.finalIns.flush();
            this.tempIns.clear();
        }

        @Override
        public void close() {
            this.rw.getObjectReader().close();
            this.rw.close();
            if (this.close) {
                if (this.finalIns != null) {
                    this.finalIns.close();
                }
                this.repo.close();
            }
        }
    }

    @AutoValue
    public static abstract class Result {
        static Result create(StagedResult staged, NoteDbChangeState newState) {
            return new AutoValue_NoteDbUpdateManager_Result(newState, staged);
        }

        @Nullable
        public abstract NoteDbChangeState newState();

        @Nullable
        abstract StagedResult staged();
    }

    @AutoValue
    public static abstract class StagedResult {
        private static StagedResult create(Change.Id id, NoteDbChangeState.Delta delta, OpenRepo changeRepo, OpenRepo allUsersRepo) {
            ImmutableList<ReceiveCommand> changeCommands = ImmutableList.of();
            ImmutableList<InsertedObject> changeObjects = ImmutableList.of();
            if (changeRepo != null) {
                changeCommands = changeRepo.getCommandsSnapshot();
                changeObjects = changeRepo.tempIns.getInsertedObjects();
            }
            ImmutableList<ReceiveCommand> allUsersCommands = ImmutableList.of();
            ImmutableList<InsertedObject> allUsersObjects = ImmutableList.of();
            if (allUsersRepo != null) {
                allUsersCommands = allUsersRepo.getCommandsSnapshot();
                allUsersObjects = allUsersRepo.tempIns.getInsertedObjects();
            }
            return new AutoValue_NoteDbUpdateManager_StagedResult(id, delta, changeCommands, changeObjects, allUsersCommands, allUsersObjects);
        }

        public abstract Change.Id id();

        @Nullable
        public abstract NoteDbChangeState.Delta delta();

        public abstract ImmutableList<ReceiveCommand> changeCommands();

        public abstract ImmutableList<InsertedObject> changeObjects();

        public abstract ImmutableList<ReceiveCommand> allUsersCommands();

        public abstract ImmutableList<InsertedObject> allUsersObjects();
    }

    public static interface Factory {
        public NoteDbUpdateManager create(Project.NameKey var1);
    }
}

