/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.notedb;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.gerrit.reviewdb.client.Comment;
import java.io.IOException;
import java.util.List;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.util.MutableInteger;

abstract class RevisionNote<T extends Comment> {
    static final int MAX_NOTE_SZ = 0x1900000;
    private final ObjectReader reader;
    private final ObjectId noteId;
    private byte[] raw;
    private ImmutableList<T> comments;

    protected static void trimLeadingEmptyLines(byte[] bytes, MutableInteger p) {
        while (p.value < bytes.length && bytes[p.value] == 10) {
            ++p.value;
        }
    }

    RevisionNote(ObjectReader reader, ObjectId noteId) {
        this.reader = reader;
        this.noteId = noteId;
    }

    public byte[] getRaw() {
        this.checkParsed();
        return this.raw;
    }

    public ImmutableList<T> getComments() {
        this.checkParsed();
        return this.comments;
    }

    public void parse() throws IOException, ConfigInvalidException {
        this.raw = this.reader.open(this.noteId, 3).getCachedBytes(0x1900000);
        MutableInteger p = new MutableInteger();
        RevisionNote.trimLeadingEmptyLines(this.raw, p);
        if (p.value >= this.raw.length) {
            this.comments = null;
            return;
        }
        this.comments = ImmutableList.copyOf(this.parse(this.raw, p.value));
    }

    protected abstract List<T> parse(byte[] var1, int var2) throws IOException, ConfigInvalidException;

    protected void checkParsed() {
        Preconditions.checkState(this.raw != null, "revision note not parsed yet");
    }
}

