/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.patch;

import com.google.common.collect.ImmutableMap;
import com.google.gerrit.extensions.client.DiffPreferencesInfo;
import com.google.gerrit.server.patch.PatchListKey;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Objects;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectIdSerialization;

public class DiffSummaryKey
implements Serializable {
    public static final long serialVersionUID = 1L;
    private transient ObjectId oldId;
    private transient Integer parentNum;
    private transient ObjectId newId;
    private transient DiffPreferencesInfo.Whitespace whitespace;

    public static DiffSummaryKey fromPatchListKey(PatchListKey plk) {
        return new DiffSummaryKey(plk.getOldId(), plk.getParentNum(), plk.getNewId(), plk.getWhitespace());
    }

    private DiffSummaryKey(ObjectId oldId, Integer parentNum, ObjectId newId, DiffPreferencesInfo.Whitespace whitespace) {
        this.oldId = oldId;
        this.parentNum = parentNum;
        this.newId = newId;
        this.whitespace = whitespace;
    }

    PatchListKey toPatchListKey() {
        return new PatchListKey(this.oldId, this.parentNum, this.newId, this.whitespace);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.oldId, this.parentNum, this.newId, this.whitespace});
    }

    public boolean equals(Object o) {
        if (o instanceof DiffSummaryKey) {
            DiffSummaryKey k = (DiffSummaryKey)o;
            return Objects.equals(this.oldId, k.oldId) && Objects.equals(this.parentNum, k.parentNum) && Objects.equals(this.newId, k.newId) && this.whitespace == k.whitespace;
        }
        return false;
    }

    public String toString() {
        StringBuilder n = new StringBuilder();
        n.append("DiffSummaryKey[");
        n.append(this.oldId != null ? this.oldId.name() : "BASE");
        n.append("..");
        n.append(this.newId.name());
        n.append(" ");
        if (this.parentNum != null) {
            n.append(this.parentNum);
            n.append(" ");
        }
        n.append(this.whitespace.name());
        n.append("]");
        return n.toString();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        ObjectIdSerialization.writeCanBeNull(out, this.oldId);
        out.writeInt(this.parentNum == null ? 0 : this.parentNum);
        ObjectIdSerialization.writeNotNull(out, this.newId);
        Character c = (Character)PatchListKey.WHITESPACE_TYPES.get((Object)this.whitespace);
        if (c == null) {
            throw new IOException("Invalid whitespace type: " + (Object)((Object)this.whitespace));
        }
        out.writeChar(c.charValue());
    }

    private void readObject(ObjectInputStream in) throws IOException {
        this.oldId = ObjectIdSerialization.readCanBeNull(in);
        int n = in.readInt();
        this.parentNum = n == 0 ? null : Integer.valueOf(n);
        this.newId = ObjectIdSerialization.readNotNull(in);
        char t = in.readChar();
        this.whitespace = (DiffPreferencesInfo.Whitespace)((Object)((ImmutableMap)((Object)PatchListKey.WHITESPACE_TYPES.inverse())).get(Character.valueOf(t)));
        if (this.whitespace == null) {
            throw new IOException("Invalid whitespace type code: " + t);
        }
    }
}

