/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.patch;

import com.google.gerrit.reviewdb.client.CodedEnum;
import com.google.gerrit.server.ioutil.BasicSerialization;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.jgit.diff.Edit;
import org.eclipse.jgit.diff.ReplaceEdit;

public class IntraLineDiff
implements Serializable {
    static final long serialVersionUID = 5L;
    private transient Status status;
    private transient List<Edit> edits;

    IntraLineDiff(Status status) {
        this.status = status;
        this.edits = Collections.emptyList();
    }

    IntraLineDiff(List<Edit> edits) {
        this.status = Status.EDIT_LIST;
        this.edits = Collections.unmodifiableList(edits);
    }

    public Status getStatus() {
        return this.status;
    }

    public List<Edit> getEdits() {
        return this.edits;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        BasicSerialization.writeEnum(out, this.status);
        BasicSerialization.writeVarInt32(out, this.edits.size());
        for (Edit e : this.edits) {
            IntraLineDiff.writeEdit(out, e);
            if (e instanceof ReplaceEdit) {
                ReplaceEdit r = (ReplaceEdit)e;
                BasicSerialization.writeVarInt32(out, r.getInternalEdits().size());
                for (Edit i : r.getInternalEdits()) {
                    IntraLineDiff.writeEdit(out, i);
                }
                continue;
            }
            BasicSerialization.writeVarInt32(out, 0);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException {
        this.status = (Status)BasicSerialization.readEnum((InputStream)in, (CodedEnum[])Status.values());
        int editCount = BasicSerialization.readVarInt32(in);
        Edit[] editArray = new Edit[editCount];
        for (int i = 0; i < editCount; ++i) {
            editArray[i] = IntraLineDiff.readEdit(in);
            int innerCount = BasicSerialization.readVarInt32(in);
            if (0 >= innerCount) continue;
            Edit[] inner = new Edit[innerCount];
            for (int j = 0; j < innerCount; ++j) {
                inner[j] = IntraLineDiff.readEdit(in);
            }
            editArray[i] = new ReplaceEdit(editArray[i], IntraLineDiff.toList(inner));
        }
        this.edits = IntraLineDiff.toList(editArray);
    }

    private static void writeEdit(OutputStream out, Edit e) throws IOException {
        BasicSerialization.writeVarInt32(out, e.getBeginA());
        BasicSerialization.writeVarInt32(out, e.getEndA());
        BasicSerialization.writeVarInt32(out, e.getBeginB());
        BasicSerialization.writeVarInt32(out, e.getEndB());
    }

    private static Edit readEdit(InputStream in) throws IOException {
        int beginA = BasicSerialization.readVarInt32(in);
        int endA = BasicSerialization.readVarInt32(in);
        int beginB = BasicSerialization.readVarInt32(in);
        int endB = BasicSerialization.readVarInt32(in);
        return new Edit(beginA, endA, beginB, endB);
    }

    private static List<Edit> toList(Edit[] l) {
        return Collections.unmodifiableList(Arrays.asList(l));
    }

    public static enum Status implements CodedEnum
    {
        EDIT_LIST('e'),
        DISABLED('D'),
        TIMEOUT('T'),
        ERROR('E');

        private final char code;

        private Status(char code) {
            this.code = code;
        }

        @Override
        public char getCode() {
            return this.code;
        }
    }
}

