/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.project;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.gerrit.extensions.api.projects.CommentLinkInfo;

public class CommentLinkInfoImpl
extends CommentLinkInfo {
    public CommentLinkInfoImpl(String name, String match, String link, String html, Boolean enabled) {
        Preconditions.checkArgument(name != null, "invalid commentlink.name");
        Preconditions.checkArgument(!Strings.isNullOrEmpty(match), "invalid commentlink.%s.match", (Object)name);
        link = Strings.emptyToNull(link);
        html = Strings.emptyToNull(html);
        Preconditions.checkArgument(link != null && html == null || link == null && html != null, "commentlink.%s must have either link or html", (Object)name);
        this.name = name;
        this.match = match;
        this.link = link;
        this.html = html;
        this.enabled = enabled;
    }

    private CommentLinkInfoImpl(CommentLinkInfo src, boolean enabled) {
        this.name = src.name;
        this.match = src.match;
        this.link = src.link;
        this.html = src.html;
        this.enabled = enabled;
    }

    private CommentLinkInfoImpl(String name, boolean enabled) {
        this.name = name;
        this.match = null;
        this.link = null;
        this.html = null;
        this.enabled = enabled;
    }

    boolean isOverrideOnly() {
        return false;
    }

    CommentLinkInfo inherit(CommentLinkInfo src) {
        return new CommentLinkInfoImpl(src, (boolean)this.enabled);
    }

    public static class Disabled
    extends CommentLinkInfoImpl {
        public Disabled(String name) {
            super(name, false);
        }

        @Override
        boolean isOverrideOnly() {
            return true;
        }
    }

    public static class Enabled
    extends CommentLinkInfoImpl {
        public Enabled(String name) {
            super(name, true);
        }

        @Override
        boolean isOverrideOnly() {
            return true;
        }
    }
}

