/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.project;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.gerrit.extensions.api.projects.CommentLinkInfo;
import com.google.gerrit.server.config.GerritServerConfig;
import com.google.gerrit.server.git.ProjectConfig;
import com.google.gerrit.server.project.CommentLinkInfoImpl;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.jgit.lib.Config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommentLinkProvider
implements Provider<List<CommentLinkInfo>> {
    private static final Logger log = LoggerFactory.getLogger(CommentLinkProvider.class);
    private final Config cfg;

    @Inject
    CommentLinkProvider(@GerritServerConfig Config cfg) {
        this.cfg = cfg;
    }

    @Override
    public List<CommentLinkInfo> get() {
        Set<String> subsections = this.cfg.getSubsections("commentlink");
        ArrayList<CommentLinkInfoImpl> cls = Lists.newArrayListWithCapacity(subsections.size());
        for (String name : subsections) {
            try {
                CommentLinkInfoImpl cl = ProjectConfig.buildCommentLink(this.cfg, name, true);
                if (cl.isOverrideOnly()) {
                    log.warn("commentlink " + name + " empty except for \"enabled\"");
                    continue;
                }
                cls.add(cl);
            }
            catch (IllegalArgumentException e) {
                log.warn("invalid commentlink: " + e.getMessage());
            }
        }
        return ImmutableList.copyOf(cls);
    }
}

