/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.query;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Ordering;
import com.google.gerrit.metrics.Description;
import com.google.gerrit.metrics.Field;
import com.google.gerrit.metrics.MetricMaker;
import com.google.gerrit.metrics.Timer1;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.index.Index;
import com.google.gerrit.server.index.IndexCollection;
import com.google.gerrit.server.index.IndexConfig;
import com.google.gerrit.server.index.IndexRewriter;
import com.google.gerrit.server.index.QueryOptions;
import com.google.gerrit.server.index.SchemaDefinitions;
import com.google.gerrit.server.query.DataSource;
import com.google.gerrit.server.query.LimitPredicate;
import com.google.gerrit.server.query.Predicate;
import com.google.gerrit.server.query.QueryParseException;
import com.google.gerrit.server.query.QueryResult;
import com.google.gwtorm.server.OrmException;
import com.google.gwtorm.server.OrmRuntimeException;
import com.google.gwtorm.server.ResultSet;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public abstract class QueryProcessor<T> {
    protected final Provider<CurrentUser> userProvider;
    private final Metrics metrics;
    private final SchemaDefinitions<T> schemaDef;
    private final IndexConfig indexConfig;
    private final IndexCollection<?, T, ? extends Index<?, T>> indexes;
    private final IndexRewriter<T> rewriter;
    private final String limitField;
    protected int start;
    private boolean enforceVisibility = true;
    private int limitFromCaller;
    private Set<String> requestedFields;

    protected QueryProcessor(Provider<CurrentUser> userProvider, Metrics metrics, SchemaDefinitions<T> schemaDef, IndexConfig indexConfig, IndexCollection<?, T, ? extends Index<?, T>> indexes, IndexRewriter<T> rewriter, String limitField) {
        this.userProvider = userProvider;
        this.metrics = metrics;
        this.schemaDef = schemaDef;
        this.indexConfig = indexConfig;
        this.indexes = indexes;
        this.rewriter = rewriter;
        this.limitField = limitField;
    }

    public QueryProcessor<T> setStart(int n) {
        this.start = n;
        return this;
    }

    public QueryProcessor<T> enforceVisibility(boolean enforce) {
        this.enforceVisibility = enforce;
        return this;
    }

    public QueryProcessor<T> setLimit(int n) {
        this.limitFromCaller = n;
        return this;
    }

    public QueryProcessor<T> setRequestedFields(Set<String> fields) {
        this.requestedFields = fields;
        return this;
    }

    public QueryResult<T> query(Predicate<T> query) throws OrmException, QueryParseException {
        return this.query(ImmutableList.of(query)).get(0);
    }

    public List<QueryResult<T>> query(List<Predicate<T>> queries) throws OrmException, QueryParseException {
        try {
            return this.query(null, queries);
        }
        catch (OrmRuntimeException e) {
            throw new OrmException(e.getMessage(), e);
        }
        catch (OrmException e) {
            if (e.getCause() != null) {
                Throwables.throwIfInstanceOf(e.getCause(), QueryParseException.class);
            }
            throw e;
        }
    }

    private List<QueryResult<T>> query(List<String> queryStrings, List<Predicate<T>> queries) throws OrmException, QueryParseException {
        long startNanos = System.nanoTime();
        int cnt = queries.size();
        ArrayList<Integer> limits = new ArrayList<Integer>(cnt);
        ArrayList<Predicate<T>> predicates = new ArrayList<Predicate<T>>(cnt);
        ArrayList<DataSource> sources = new ArrayList<DataSource>(cnt);
        for (Predicate<T> predicate : queries) {
            int page;
            int limit = this.getEffectiveLimit(predicate);
            limits.add(limit);
            if (limit == this.getBackendSupportedLimit()) {
                --limit;
            }
            if ((page = this.start / limit + 1) > this.indexConfig.maxPages()) {
                throw new QueryParseException("Cannot go beyond page " + this.indexConfig.maxPages() + " of results");
            }
            QueryOptions opts = this.createOptions(this.indexConfig, this.start, limit + 1, this.getRequestedFields());
            Predicate<T> pred = this.rewriter.rewrite(predicate, opts);
            if (this.enforceVisibility) {
                pred = this.enforceVisibility(pred);
            }
            predicates.add(pred);
            DataSource s = (DataSource)((Object)pred);
            sources.add(s);
        }
        ArrayList matches = new ArrayList(cnt);
        for (DataSource s : sources) {
            matches.add(s.read());
        }
        ArrayList<QueryResult<T>> arrayList = new ArrayList<QueryResult<T>>(cnt);
        for (int i = 0; i < cnt; ++i) {
            arrayList.add(QueryResult.create(queryStrings != null ? queryStrings.get(i) : null, (Predicate)predicates.get(i), (Integer)limits.get(i), ((ResultSet)matches.get(i)).toList()));
        }
        this.metrics.executionTime.record(this.schemaDef.getName(), System.nanoTime() - startNanos, TimeUnit.NANOSECONDS);
        return arrayList;
    }

    protected QueryOptions createOptions(IndexConfig indexConfig, int start, int limit, Set<String> requestedFields) {
        return QueryOptions.create(indexConfig, start, limit, requestedFields);
    }

    protected abstract Predicate<T> enforceVisibility(Predicate<T> var1);

    private Set<String> getRequestedFields() {
        if (this.requestedFields != null) {
            return this.requestedFields;
        }
        Index<?, T> index = this.indexes.getSearchIndex();
        return index != null ? index.getSchema().getStoredFields().keySet() : ImmutableSet.of();
    }

    public boolean isDisabled() {
        return this.getPermittedLimit() <= 0;
    }

    private int getPermittedLimit() {
        if (this.enforceVisibility) {
            return this.userProvider.get().getCapabilities().getRange("queryLimit").getMax();
        }
        return Integer.MAX_VALUE;
    }

    private int getBackendSupportedLimit() {
        return this.indexConfig.maxLimit();
    }

    private int getEffectiveLimit(Predicate<T> p) {
        Integer limitFromPredicate;
        ArrayList<Integer> possibleLimits = new ArrayList<Integer>(4);
        possibleLimits.add(this.getBackendSupportedLimit());
        possibleLimits.add(this.getPermittedLimit());
        if (this.limitFromCaller > 0) {
            possibleLimits.add(this.limitFromCaller);
        }
        if (this.limitField != null && (limitFromPredicate = LimitPredicate.getLimit(this.limitField, p)) != null) {
            possibleLimits.add(limitFromPredicate);
        }
        return (Integer)Ordering.natural().min(possibleLimits);
    }

    @Singleton
    protected static class Metrics {
        final Timer1<String> executionTime;

        @Inject
        Metrics(MetricMaker metricMaker) {
            Field<String> index = Field.ofString("index", "index name");
            this.executionTime = metricMaker.newTimer("query/query_latency", new Description("Successful query latency, accumulated over the life of the process").setCumulative().setUnit("milliseconds"), index);
        }
    }
}

