/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.query.change;

import com.google.gerrit.server.index.change.ChangeField;
import com.google.gerrit.server.query.QueryParseException;
import com.google.gerrit.server.query.change.ChangeData;
import com.google.gerrit.server.query.change.TimestampRangeChangePredicate;
import com.google.gwtorm.server.OrmException;
import java.util.Date;

public class BeforePredicate
extends TimestampRangeChangePredicate {
    private final Date cut;

    BeforePredicate(String value) throws QueryParseException {
        super(ChangeField.UPDATED, "before", value);
        this.cut = BeforePredicate.parse(value);
    }

    @Override
    public Date getMinTimestamp() {
        return new Date(0L);
    }

    @Override
    public Date getMaxTimestamp() {
        return this.cut;
    }

    @Override
    public boolean match(ChangeData cd) throws OrmException {
        return cd.change().getLastUpdatedOn().getTime() <= this.cut.getTime();
    }
}

