/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.query.change;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Enums;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.primitives.Ints;
import com.google.gerrit.common.data.GroupDescription;
import com.google.gerrit.common.data.GroupReference;
import com.google.gerrit.common.data.SubmitRecord;
import com.google.gerrit.extensions.registration.DynamicMap;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.AccountGroup;
import com.google.gerrit.reviewdb.client.Branch;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.RefNames;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.CommentsUtil;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.StarredChangesUtil;
import com.google.gerrit.server.account.AccountCache;
import com.google.gerrit.server.account.AccountResolver;
import com.google.gerrit.server.account.CapabilityControl;
import com.google.gerrit.server.account.GroupBackend;
import com.google.gerrit.server.account.GroupBackends;
import com.google.gerrit.server.account.VersionedAccountDestinations;
import com.google.gerrit.server.account.VersionedAccountQueries;
import com.google.gerrit.server.change.ChangeTriplet;
import com.google.gerrit.server.config.AllProjectsName;
import com.google.gerrit.server.config.AllUsersName;
import com.google.gerrit.server.config.GerritServerConfig;
import com.google.gerrit.server.config.TrackingFooters;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.gerrit.server.git.strategy.SubmitDryRun;
import com.google.gerrit.server.group.ListMembers;
import com.google.gerrit.server.index.FieldDef;
import com.google.gerrit.server.index.IndexConfig;
import com.google.gerrit.server.index.Schema;
import com.google.gerrit.server.index.change.ChangeField;
import com.google.gerrit.server.index.change.ChangeIndex;
import com.google.gerrit.server.index.change.ChangeIndexCollection;
import com.google.gerrit.server.index.change.ChangeIndexRewriter;
import com.google.gerrit.server.notedb.ChangeNotes;
import com.google.gerrit.server.notedb.NotesMigration;
import com.google.gerrit.server.patch.PatchListCache;
import com.google.gerrit.server.project.ChangeControl;
import com.google.gerrit.server.project.ListChildProjects;
import com.google.gerrit.server.project.ProjectCache;
import com.google.gerrit.server.query.LimitPredicate;
import com.google.gerrit.server.query.Predicate;
import com.google.gerrit.server.query.QueryBuilder;
import com.google.gerrit.server.query.QueryParseException;
import com.google.gerrit.server.query.QueryRequiresAuthException;
import com.google.gerrit.server.query.change.AddedPredicate;
import com.google.gerrit.server.query.change.AfterPredicate;
import com.google.gerrit.server.query.change.AgePredicate;
import com.google.gerrit.server.query.change.AssigneePredicate;
import com.google.gerrit.server.query.change.AuthorPredicate;
import com.google.gerrit.server.query.change.BeforePredicate;
import com.google.gerrit.server.query.change.ChangeData;
import com.google.gerrit.server.query.change.ChangeIdPredicate;
import com.google.gerrit.server.query.change.ChangeIsVisibleToPredicate;
import com.google.gerrit.server.query.change.ChangeStatusPredicate;
import com.google.gerrit.server.query.change.CommentByPredicate;
import com.google.gerrit.server.query.change.CommentPredicate;
import com.google.gerrit.server.query.change.CommitPredicate;
import com.google.gerrit.server.query.change.CommitterPredicate;
import com.google.gerrit.server.query.change.ConflictsCache;
import com.google.gerrit.server.query.change.ConflictsPredicate;
import com.google.gerrit.server.query.change.DeletedPredicate;
import com.google.gerrit.server.query.change.DeltaPredicate;
import com.google.gerrit.server.query.change.DestinationPredicate;
import com.google.gerrit.server.query.change.EditByPredicate;
import com.google.gerrit.server.query.change.EqualsFilePredicate;
import com.google.gerrit.server.query.change.EqualsPathPredicate;
import com.google.gerrit.server.query.change.ExactTopicPredicate;
import com.google.gerrit.server.query.change.FuzzyTopicPredicate;
import com.google.gerrit.server.query.change.HasDraftByPredicate;
import com.google.gerrit.server.query.change.HasStarsPredicate;
import com.google.gerrit.server.query.change.HashtagPredicate;
import com.google.gerrit.server.query.change.InternalChangeQuery;
import com.google.gerrit.server.query.change.IsMergeablePredicate;
import com.google.gerrit.server.query.change.IsReviewedPredicate;
import com.google.gerrit.server.query.change.IsUnresolvedPredicate;
import com.google.gerrit.server.query.change.IsWatchedByPredicate;
import com.google.gerrit.server.query.change.LabelPredicate;
import com.google.gerrit.server.query.change.LegacyChangeIdPredicate;
import com.google.gerrit.server.query.change.MessagePredicate;
import com.google.gerrit.server.query.change.OwnerPredicate;
import com.google.gerrit.server.query.change.OwnerinPredicate;
import com.google.gerrit.server.query.change.ParentProjectPredicate;
import com.google.gerrit.server.query.change.PredicateArgs;
import com.google.gerrit.server.query.change.ProjectPredicate;
import com.google.gerrit.server.query.change.ProjectPrefixPredicate;
import com.google.gerrit.server.query.change.RefPredicate;
import com.google.gerrit.server.query.change.RegexPathPredicate;
import com.google.gerrit.server.query.change.RegexProjectPredicate;
import com.google.gerrit.server.query.change.RegexRefPredicate;
import com.google.gerrit.server.query.change.RegexTopicPredicate;
import com.google.gerrit.server.query.change.ReviewerPredicate;
import com.google.gerrit.server.query.change.ReviewerinPredicate;
import com.google.gerrit.server.query.change.SingleGroupUser;
import com.google.gerrit.server.query.change.StarPredicate;
import com.google.gerrit.server.query.change.SubmitRecordPredicate;
import com.google.gerrit.server.query.change.SubmittablePredicate;
import com.google.gerrit.server.query.change.TrackingIdPredicate;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.ProvisionException;
import com.google.inject.util.Providers;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.errors.RepositoryNotFoundException;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.Repository;

public class ChangeQueryBuilder
extends QueryBuilder<ChangeData> {
    private static final Pattern PAT_LEGACY_ID = Pattern.compile("^[1-9][0-9]*$");
    private static final Pattern PAT_CHANGE_ID = Pattern.compile("^[iI][0-9a-f]{4,}.*$");
    private static final Pattern DEF_CHANGE = Pattern.compile("^(?:[1-9][0-9]*|(?:[^~]+~[^~]+~)?[iI][0-9a-f]{4,}.*)$");
    public static final String FIELD_ADDED = "added";
    public static final String FIELD_AGE = "age";
    public static final String FIELD_ASSIGNEE = "assignee";
    public static final String FIELD_AUTHOR = "author";
    public static final String FIELD_BEFORE = "before";
    public static final String FIELD_CHANGE = "change";
    public static final String FIELD_CHANGE_ID = "change_id";
    public static final String FIELD_COMMENT = "comment";
    public static final String FIELD_COMMENTBY = "commentby";
    public static final String FIELD_COMMIT = "commit";
    public static final String FIELD_COMMITTER = "committer";
    public static final String FIELD_CONFLICTS = "conflicts";
    public static final String FIELD_DELETED = "deleted";
    public static final String FIELD_DELTA = "delta";
    public static final String FIELD_DESTINATION = "destination";
    public static final String FIELD_DRAFTBY = "draftby";
    public static final String FIELD_EDITBY = "editby";
    public static final String FIELD_EXACTCOMMIT = "exactcommit";
    public static final String FIELD_FILE = "file";
    public static final String FIELD_FILEPART = "filepart";
    public static final String FIELD_GROUP = "group";
    public static final String FIELD_HASHTAG = "hashtag";
    public static final String FIELD_LABEL = "label";
    public static final String FIELD_LIMIT = "limit";
    public static final String FIELD_MERGE = "merge";
    public static final String FIELD_MERGEABLE = "mergeable2";
    public static final String FIELD_MESSAGE = "message";
    public static final String FIELD_OWNER = "owner";
    public static final String FIELD_OWNERIN = "ownerin";
    public static final String FIELD_PARENTPROJECT = "parentproject";
    public static final String FIELD_PATH = "path";
    public static final String FIELD_PROJECT = "project";
    public static final String FIELD_PROJECTS = "projects";
    public static final String FIELD_REF = "ref";
    public static final String FIELD_REVIEWEDBY = "reviewedby";
    public static final String FIELD_REVIEWER = "reviewer";
    public static final String FIELD_REVIEWERIN = "reviewerin";
    public static final String FIELD_STAR = "star";
    public static final String FIELD_STARBY = "starby";
    public static final String FIELD_STARREDBY = "starredby";
    public static final String FIELD_STATUS = "status";
    public static final String FIELD_SUBMISSIONID = "submissionid";
    public static final String FIELD_TR = "tr";
    public static final String FIELD_UNRESOLVED_COMMENT_COUNT = "unresolved";
    public static final String FIELD_VISIBLETO = "visibleto";
    public static final String FIELD_WATCHEDBY = "watchedby";
    public static final String ARG_ID_USER = "user";
    public static final String ARG_ID_GROUP = "group";
    public static final String ARG_ID_OWNER = "owner";
    public static final Account.Id OWNER_ACCOUNT_ID = new Account.Id(0);
    private static final QueryBuilder.Definition<ChangeData, ChangeQueryBuilder> mydef = new QueryBuilder.Definition(ChangeQueryBuilder.class);
    private final Arguments args;

    @Inject
    ChangeQueryBuilder(Arguments args) {
        super(mydef);
        this.args = args;
        this.setupDynamicOperators();
    }

    @VisibleForTesting
    protected ChangeQueryBuilder(QueryBuilder.Definition<ChangeData, ? extends QueryBuilder<ChangeData>> def, Arguments args) {
        super(def);
        this.args = args;
    }

    private void setupDynamicOperators() {
        for (DynamicMap.Entry<ChangeOperatorFactory> entry : this.args.opFactories) {
            String name = entry.getExportName() + "_" + entry.getPluginName();
            this.opFactories.put(name, (QueryBuilder.OperatorFactory)entry.getProvider().get());
        }
    }

    public Arguments getArgs() {
        return this.args;
    }

    public ChangeQueryBuilder asUser(CurrentUser user) {
        return new ChangeQueryBuilder(this.builderDef, this.args.asUser(user));
    }

    @QueryBuilder.Operator
    public Predicate<ChangeData> age(String value) {
        return new AgePredicate(value);
    }

    @QueryBuilder.Operator
    public Predicate<ChangeData> before(String value) throws QueryParseException {
        return new BeforePredicate(value);
    }

    @QueryBuilder.Operator
    public Predicate<ChangeData> until(String value) throws QueryParseException {
        return this.before(value);
    }

    @QueryBuilder.Operator
    public Predicate<ChangeData> after(String value) throws QueryParseException {
        return new AfterPredicate(value);
    }

    @QueryBuilder.Operator
    public Predicate<ChangeData> since(String value) throws QueryParseException {
        return this.after(value);
    }

    @QueryBuilder.Operator
    public Predicate<ChangeData> change(String query) throws QueryParseException {
        Optional<ChangeTriplet> triplet = ChangeTriplet.parse(query);
        if (triplet.isPresent()) {
            return Predicate.and(this.project(triplet.get().project().get()), this.branch(triplet.get().branch().get()), new ChangeIdPredicate(ChangeQueryBuilder.parseChangeId(triplet.get().id().get())));
        }
        if (PAT_LEGACY_ID.matcher(query).matches()) {
            return new LegacyChangeIdPredicate(Change.Id.parse(query));
        }
        if (PAT_CHANGE_ID.matcher(query).matches()) {
            return new ChangeIdPredicate(ChangeQueryBuilder.parseChangeId(query));
        }
        throw new QueryParseException("Invalid change format");
    }

    @QueryBuilder.Operator
    public Predicate<ChangeData> comment(String value) {
        return new CommentPredicate(this.args.index, value);
    }

    @QueryBuilder.Operator
    public Predicate<ChangeData> status(String statusName) throws QueryParseException {
        if ("reviewed".equalsIgnoreCase(statusName)) {
            return IsReviewedPredicate.create();
        }
        return ChangeStatusPredicate.parse(statusName);
    }

    public Predicate<ChangeData> status_open() {
        return ChangeStatusPredicate.open();
    }

    @QueryBuilder.Operator
    public Predicate<ChangeData> has(String value) throws QueryParseException {
        ChangeHasOperandFactory op;
        if (FIELD_STAR.equalsIgnoreCase(value)) {
            return this.starredby(this.self());
        }
        if ("stars".equalsIgnoreCase(value)) {
            return new HasStarsPredicate(this.self());
        }
        if ("draft".equalsIgnoreCase(value)) {
            return this.draftby(this.self());
        }
        if ("edit".equalsIgnoreCase(value)) {
            return new EditByPredicate(this.self());
        }
        if (FIELD_UNRESOLVED_COMMENT_COUNT.equalsIgnoreCase(value)) {
            return new IsUnresolvedPredicate();
        }
        String[] names = value.split("_");
        if (names.length == 2 && (op = this.args.hasOperands.get(names[1], names[0])) != null) {
            return op.create(this);
        }
        throw new IllegalArgumentException();
    }

    @QueryBuilder.Operator
    public Predicate<ChangeData> is(String value) throws QueryParseException {
        if ("starred".equalsIgnoreCase(value)) {
            return this.starredby(this.self());
        }
        if ("watched".equalsIgnoreCase(value)) {
            return new IsWatchedByPredicate(this.args, false);
        }
        if ("visible".equalsIgnoreCase(value)) {
            return this.is_visible();
        }
        if ("reviewed".equalsIgnoreCase(value)) {
            return IsReviewedPredicate.create();
        }
        if ("owner".equalsIgnoreCase(value)) {
            return new OwnerPredicate(this.self());
        }
        if (FIELD_REVIEWER.equalsIgnoreCase(value)) {
            return ReviewerPredicate.reviewer(this.args, this.self());
        }
        if ("cc".equalsIgnoreCase(value)) {
            return ReviewerPredicate.cc(this.args, this.self());
        }
        if ("mergeable".equalsIgnoreCase(value)) {
            return new IsMergeablePredicate(this.args.fillArgs);
        }
        if ("assigned".equalsIgnoreCase(value)) {
            return Predicate.not(new AssigneePredicate(new Account.Id(-1)));
        }
        if ("unassigned".equalsIgnoreCase(value)) {
            return new AssigneePredicate(new Account.Id(-1));
        }
        if ("submittable".equalsIgnoreCase(value)) {
            return new SubmittablePredicate(SubmitRecord.Status.OK);
        }
        try {
            return this.status(value);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw ChangeQueryBuilder.error("Invalid query");
        }
    }

    @QueryBuilder.Operator
    public Predicate<ChangeData> commit(String id) {
        return new CommitPredicate(id);
    }

    @QueryBuilder.Operator
    public Predicate<ChangeData> conflicts(String value) throws OrmException, QueryParseException {
        return new ConflictsPredicate(this.args, value, this.parseChange(value));
    }

    @QueryBuilder.Operator
    public Predicate<ChangeData> p(String name) {
        return this.project(name);
    }

    @QueryBuilder.Operator
    public Predicate<ChangeData> project(String name) {
        if (name.startsWith("^")) {
            return new RegexProjectPredicate(name);
        }
        return new ProjectPredicate(name);
    }

    @QueryBuilder.Operator
    public Predicate<ChangeData> projects(String name) {
        return new ProjectPrefixPredicate(name);
    }

    @QueryBuilder.Operator
    public Predicate<ChangeData> parentproject(String name) {
        return new ParentProjectPredicate(this.args.projectCache, this.args.listChildProjects, this.args.self, name);
    }

    @QueryBuilder.Operator
    public Predicate<ChangeData> branch(String name) {
        if (name.startsWith("^")) {
            return this.ref("^" + RefNames.fullName(name.substring(1)));
        }
        return this.ref(RefNames.fullName(name));
    }

    @QueryBuilder.Operator
    public Predicate<ChangeData> hashtag(String hashtag) {
        return new HashtagPredicate(hashtag);
    }

    @QueryBuilder.Operator
    public Predicate<ChangeData> topic(String name) {
        return new ExactTopicPredicate(name);
    }

    @QueryBuilder.Operator
    public Predicate<ChangeData> intopic(String name) {
        if (name.startsWith("^")) {
            return new RegexTopicPredicate(name);
        }
        if (name.isEmpty()) {
            return new ExactTopicPredicate(name);
        }
        return new FuzzyTopicPredicate(name, this.args.index);
    }

    @QueryBuilder.Operator
    public Predicate<ChangeData> ref(String ref) {
        if (ref.startsWith("^")) {
            return new RegexRefPredicate(ref);
        }
        return new RefPredicate(ref);
    }

    @QueryBuilder.Operator
    public Predicate<ChangeData> f(String file) {
        return this.file(file);
    }

    @QueryBuilder.Operator
    public Predicate<ChangeData> file(String file) {
        if (file.startsWith("^")) {
            return new RegexPathPredicate(file);
        }
        return EqualsFilePredicate.create(this.args, file);
    }

    @QueryBuilder.Operator
    public Predicate<ChangeData> path(String path) {
        if (path.startsWith("^")) {
            return new RegexPathPredicate(path);
        }
        return new EqualsPathPredicate(FIELD_PATH, path);
    }

    @QueryBuilder.Operator
    public Predicate<ChangeData> label(String name) throws QueryParseException, OrmException {
        String statusName;
        Set<Account.Id> accounts = null;
        AccountGroup.UUID group = null;
        String[] splitReviewer = name.split(",", 2);
        name = splitReviewer[0];
        if (splitReviewer.length == 2) {
            PredicateArgs lblArgs = new PredicateArgs(splitReviewer[1]);
            for (Map.Entry<String, String> pair : lblArgs.keyValue.entrySet()) {
                if (pair.getKey().equalsIgnoreCase(ARG_ID_USER)) {
                    if (pair.getValue().equals("owner")) {
                        accounts = Collections.singleton(OWNER_ACCOUNT_ID);
                        continue;
                    }
                    accounts = this.parseAccount(pair.getValue());
                    continue;
                }
                if (pair.getKey().equalsIgnoreCase("group")) {
                    group = this.parseGroup(pair.getValue()).getUUID();
                    continue;
                }
                throw new QueryParseException("Invalid argument identifier '" + pair.getKey() + "'");
            }
            for (String value : lblArgs.positional) {
                if (accounts != null || group != null) {
                    throw new QueryParseException("more than one user/group specified (" + value + ")");
                }
                try {
                    if (value.equals("owner")) {
                        accounts = Collections.singleton(OWNER_ACCOUNT_ID);
                        continue;
                    }
                    accounts = this.parseAccount(value);
                }
                catch (QueryParseException qpex) {
                    try {
                        group = this.parseGroup(value).getUUID();
                    }
                    catch (QueryParseException e) {
                        throw ChangeQueryBuilder.error("Neither user nor group " + value + " found", e);
                    }
                }
            }
        }
        if (group != null) {
            accounts = this.getMembers(group);
        }
        int eq = name.indexOf(61);
        if (this.args.getSchema().hasField(ChangeField.SUBMIT_RECORD) && eq > 0 && !ChangeQueryBuilder.isInt(statusName = name.substring(eq + 1).toUpperCase())) {
            SubmitRecord.Label.Status status = Enums.getIfPresent(SubmitRecord.Label.Status.class, statusName).orNull();
            if (status == null) {
                throw ChangeQueryBuilder.error("Invalid label status " + statusName + " in " + name);
            }
            return SubmitRecordPredicate.create(name.substring(0, eq), status, accounts);
        }
        return new LabelPredicate(this.args, name, accounts, group);
    }

    private static boolean isInt(String s) {
        if (s == null) {
            return false;
        }
        if (s.startsWith("+")) {
            s = s.substring(1);
        }
        return Ints.tryParse(s) != null;
    }

    @QueryBuilder.Operator
    public Predicate<ChangeData> message(String text) {
        return new MessagePredicate(this.args.index, text);
    }

    @QueryBuilder.Operator
    public Predicate<ChangeData> star(String label) throws QueryParseException {
        return new StarPredicate(this.self(), label);
    }

    @QueryBuilder.Operator
    public Predicate<ChangeData> starredby(String who) throws QueryParseException, OrmException {
        return this.starredby(this.parseAccount(who));
    }

    private Predicate<ChangeData> starredby(Set<Account.Id> who) {
        ArrayList<Predicate<ChangeData>> p = Lists.newArrayListWithCapacity(who.size());
        for (Account.Id id : who) {
            p.add(this.starredby(id));
        }
        return Predicate.or(p);
    }

    private Predicate<ChangeData> starredby(Account.Id who) {
        return new StarPredicate(who, FIELD_STAR);
    }

    @QueryBuilder.Operator
    public Predicate<ChangeData> watchedby(String who) throws QueryParseException, OrmException {
        Account.Id callerId;
        Set<Account.Id> m = this.parseAccount(who);
        ArrayList<IsWatchedByPredicate> p = Lists.newArrayListWithCapacity(m.size());
        try {
            CurrentUser caller = (CurrentUser)this.args.self.get();
            callerId = caller.isIdentifiedUser() ? caller.getAccountId() : null;
        }
        catch (ProvisionException e) {
            callerId = null;
        }
        for (Account.Id id : m) {
            p.add(new IsWatchedByPredicate(this.args.asUser(id), !id.equals(callerId)));
        }
        return Predicate.or(p);
    }

    @QueryBuilder.Operator
    public Predicate<ChangeData> draftby(String who) throws QueryParseException, OrmException {
        Set<Account.Id> m = this.parseAccount(who);
        ArrayList<Predicate<ChangeData>> p = Lists.newArrayListWithCapacity(m.size());
        for (Account.Id id : m) {
            p.add(this.draftby(id));
        }
        return Predicate.or(p);
    }

    private Predicate<ChangeData> draftby(Account.Id who) {
        return new HasDraftByPredicate(who);
    }

    @QueryBuilder.Operator
    public Predicate<ChangeData> visibleto(String who) throws QueryParseException, OrmException {
        if ("self".equals(who)) {
            return this.is_visible();
        }
        Set<Account.Id> m = this.args.accountResolver.findAll(this.args.db.get(), who);
        if (!m.isEmpty()) {
            ArrayList p = Lists.newArrayListWithCapacity(m.size());
            Iterator<Account.Id> iterator = m.iterator();
            if (iterator.hasNext()) {
                Account.Id id = iterator.next();
                return this.visibleto(this.args.userFactory.create(id));
            }
            return Predicate.or(p);
        }
        Collection<GroupReference> suggestions = this.args.groupBackend.suggest(who, null);
        if (!suggestions.isEmpty()) {
            HashSet<AccountGroup.UUID> ids = new HashSet<AccountGroup.UUID>();
            for (GroupReference ref : suggestions) {
                ids.add(ref.getUUID());
            }
            return this.visibleto(new SingleGroupUser(this.args.capabilityControlFactory, ids));
        }
        throw ChangeQueryBuilder.error("No user or group matches \"" + who + "\".");
    }

    public Predicate<ChangeData> visibleto(CurrentUser user) {
        return new ChangeIsVisibleToPredicate(this.args.db, this.args.notesFactory, this.args.changeControlGenericFactory, user);
    }

    public Predicate<ChangeData> is_visible() throws QueryParseException {
        return this.visibleto(this.args.getUser());
    }

    @QueryBuilder.Operator
    public Predicate<ChangeData> o(String who) throws QueryParseException, OrmException {
        return this.owner(who);
    }

    @QueryBuilder.Operator
    public Predicate<ChangeData> owner(String who) throws QueryParseException, OrmException {
        return this.owner(this.parseAccount(who));
    }

    private Predicate<ChangeData> owner(Set<Account.Id> who) {
        ArrayList<OwnerPredicate> p = Lists.newArrayListWithCapacity(who.size());
        for (Account.Id id : who) {
            p.add(new OwnerPredicate(id));
        }
        return Predicate.or(p);
    }

    @QueryBuilder.Operator
    public Predicate<ChangeData> assignee(String who) throws QueryParseException, OrmException {
        return this.assignee(this.parseAccount(who));
    }

    private Predicate<ChangeData> assignee(Set<Account.Id> who) {
        ArrayList<AssigneePredicate> p = Lists.newArrayListWithCapacity(who.size());
        for (Account.Id id : who) {
            p.add(new AssigneePredicate(id));
        }
        return Predicate.or(p);
    }

    @QueryBuilder.Operator
    public Predicate<ChangeData> ownerin(String group) throws QueryParseException, OrmException {
        GroupReference g = GroupBackends.findBestSuggestion(this.args.groupBackend, group);
        if (g == null) {
            throw ChangeQueryBuilder.error("Group " + group + " not found");
        }
        AccountGroup.UUID groupId = g.getUUID();
        GroupDescription.Basic groupDescription = this.args.groupBackend.get(groupId);
        if (!(groupDescription instanceof GroupDescription.Internal)) {
            return new OwnerinPredicate(this.args.userFactory, groupId);
        }
        Set<Account.Id> accounts = this.getMembers(groupId);
        ArrayList<OwnerPredicate> p = Lists.newArrayListWithCapacity(accounts.size());
        for (Account.Id id : accounts) {
            p.add(new OwnerPredicate(id));
        }
        return Predicate.or(p);
    }

    @QueryBuilder.Operator
    public Predicate<ChangeData> r(String who) throws QueryParseException, OrmException {
        return this.reviewer(who);
    }

    @QueryBuilder.Operator
    public Predicate<ChangeData> reviewer(String who) throws QueryParseException, OrmException {
        return Predicate.or(this.parseAccount(who).stream().map(id -> ReviewerPredicate.reviewer(this.args, id)).collect(Collectors.toList()));
    }

    @QueryBuilder.Operator
    public Predicate<ChangeData> cc(String who) throws QueryParseException, OrmException {
        return Predicate.or(this.parseAccount(who).stream().map(id -> ReviewerPredicate.cc(this.args, id)).collect(Collectors.toList()));
    }

    @QueryBuilder.Operator
    public Predicate<ChangeData> reviewerin(String group) throws QueryParseException {
        GroupReference g = GroupBackends.findBestSuggestion(this.args.groupBackend, group);
        if (g == null) {
            throw ChangeQueryBuilder.error("Group " + group + " not found");
        }
        return new ReviewerinPredicate(this.args.userFactory, g.getUUID());
    }

    @QueryBuilder.Operator
    public Predicate<ChangeData> tr(String trackingId) {
        return new TrackingIdPredicate(this.args.trackingFooters, trackingId);
    }

    @QueryBuilder.Operator
    public Predicate<ChangeData> bug(String trackingId) {
        return this.tr(trackingId);
    }

    @QueryBuilder.Operator
    public Predicate<ChangeData> limit(String query) throws QueryParseException {
        Integer limit = Ints.tryParse(query);
        if (limit == null) {
            throw ChangeQueryBuilder.error("Invalid limit: " + query);
        }
        return new LimitPredicate<ChangeData>(FIELD_LIMIT, limit);
    }

    @QueryBuilder.Operator
    public Predicate<ChangeData> added(String value) throws QueryParseException {
        return new AddedPredicate(value);
    }

    @QueryBuilder.Operator
    public Predicate<ChangeData> deleted(String value) throws QueryParseException {
        return new DeletedPredicate(value);
    }

    @QueryBuilder.Operator
    public Predicate<ChangeData> size(String value) throws QueryParseException {
        return this.delta(value);
    }

    @QueryBuilder.Operator
    public Predicate<ChangeData> delta(String value) throws QueryParseException {
        return new DeltaPredicate(value);
    }

    @QueryBuilder.Operator
    public Predicate<ChangeData> commentby(String who) throws QueryParseException, OrmException {
        return this.commentby(this.parseAccount(who));
    }

    private Predicate<ChangeData> commentby(Set<Account.Id> who) {
        ArrayList<CommentByPredicate> p = Lists.newArrayListWithCapacity(who.size());
        for (Account.Id id : who) {
            p.add(new CommentByPredicate(id));
        }
        return Predicate.or(p);
    }

    @QueryBuilder.Operator
    public Predicate<ChangeData> from(String who) throws QueryParseException, OrmException {
        Set<Account.Id> ownerIds = this.parseAccount(who);
        return Predicate.or(this.owner(ownerIds), this.commentby(ownerIds));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @QueryBuilder.Operator
    public Predicate<ChangeData> query(String name) throws QueryParseException {
        try (Repository git = this.args.repoManager.openRepository(this.args.allUsersName);){
            VersionedAccountQueries q = VersionedAccountQueries.forUser(this.self());
            q.load(git);
            String query = q.getQueryList().getQuery(name);
            if (query == null) throw new QueryParseException("Unknown named query: " + name);
            Predicate<ChangeData> predicate = this.parse(query);
            return predicate;
        }
        catch (RepositoryNotFoundException e) {
            throw new QueryParseException("Unknown named query (no " + this.args.allUsersName + " repo): " + name, e);
        }
        catch (IOException | ConfigInvalidException e) {
            throw new QueryParseException("Error parsing named query: " + name, e);
        }
    }

    @QueryBuilder.Operator
    public Predicate<ChangeData> reviewedby(String who) throws QueryParseException, OrmException {
        return IsReviewedPredicate.create(this.parseAccount(who));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @QueryBuilder.Operator
    public Predicate<ChangeData> destination(String name) throws QueryParseException {
        try (Repository git = this.args.repoManager.openRepository(this.args.allUsersName);){
            VersionedAccountDestinations d = VersionedAccountDestinations.forUser(this.self());
            d.load(git);
            Set<Branch.NameKey> destinations = d.getDestinationList().getDestinations(name);
            if (destinations == null) throw new QueryParseException("Unknown named destination: " + name);
            if (destinations.isEmpty()) throw new QueryParseException("Unknown named destination: " + name);
            DestinationPredicate destinationPredicate = new DestinationPredicate(destinations, name);
            return destinationPredicate;
        }
        catch (RepositoryNotFoundException e) {
            throw new QueryParseException("Unknown named destination (no " + this.args.allUsersName + " repo): " + name, e);
        }
        catch (IOException | ConfigInvalidException e) {
            throw new QueryParseException("Error parsing named destination: " + name, e);
        }
    }

    @QueryBuilder.Operator
    public Predicate<ChangeData> author(String who) {
        return new AuthorPredicate(who);
    }

    @QueryBuilder.Operator
    public Predicate<ChangeData> committer(String who) {
        return new CommitterPredicate(who);
    }

    @QueryBuilder.Operator
    public Predicate<ChangeData> submittable(String str) throws QueryParseException {
        SubmitRecord.Status status = Enums.getIfPresent(SubmitRecord.Status.class, str.toUpperCase()).orNull();
        if (status == null) {
            throw ChangeQueryBuilder.error("invalid value for submittable:" + str);
        }
        return new SubmittablePredicate(status);
    }

    @QueryBuilder.Operator
    public Predicate<ChangeData> unresolved(String value) throws QueryParseException {
        return new IsUnresolvedPredicate(value);
    }

    @Override
    protected Predicate<ChangeData> defaultField(String query) throws QueryParseException {
        if (query.startsWith("refs/")) {
            return this.ref(query);
        }
        if (DEF_CHANGE.matcher(query).matches()) {
            ArrayList<Predicate<ChangeData>> predicates = Lists.newArrayListWithCapacity(2);
            try {
                predicates.add(this.change(query));
            }
            catch (QueryParseException queryParseException) {
                // empty catch block
            }
            if (query.length() >= 6 && PAT_LEGACY_ID.matcher(query).matches()) {
                predicates.add(this.commit(query));
            }
            return Predicate.or(predicates);
        }
        ArrayList<Predicate<ChangeData>> predicates = Lists.newArrayListWithCapacity(11);
        try {
            predicates.add(this.owner(query));
        }
        catch (QueryParseException | OrmException exception) {
            // empty catch block
        }
        try {
            predicates.add(this.reviewer(query));
        }
        catch (QueryParseException | OrmException exception) {
            // empty catch block
        }
        predicates.add(this.file(query));
        try {
            predicates.add(this.label(query));
        }
        catch (QueryParseException | OrmException exception) {
            // empty catch block
        }
        predicates.add(this.commit(query));
        predicates.add(this.message(query));
        predicates.add(this.comment(query));
        predicates.add(this.projects(query));
        predicates.add(this.ref(query));
        predicates.add(this.branch(query));
        predicates.add(this.topic(query));
        return Predicate.or(predicates);
    }

    private Set<Account.Id> getMembers(AccountGroup.UUID g) throws OrmException {
        Set<Account.Id> allMembers = this.args.listMembers.get().setRecursive(true).apply(g).stream().map(a -> new Account.Id(a._accountId)).collect(Collectors.toSet());
        int maxTerms = this.args.indexConfig.maxTerms();
        Set<Account.Id> accounts = allMembers.size() > maxTerms ? ImmutableSet.copyOf(Iterables.limit(allMembers, maxTerms)) : allMembers;
        return accounts;
    }

    private Set<Account.Id> parseAccount(String who) throws QueryParseException, OrmException {
        if ("self".equals(who)) {
            return Collections.singleton(this.self());
        }
        Set<Account.Id> matches = this.args.accountResolver.findAll(this.args.db.get(), who);
        if (matches.isEmpty()) {
            throw ChangeQueryBuilder.error("User " + who + " not found");
        }
        return matches;
    }

    private GroupReference parseGroup(String group) throws QueryParseException {
        GroupReference g = GroupBackends.findBestSuggestion(this.args.groupBackend, group);
        if (g == null) {
            throw ChangeQueryBuilder.error("Group " + group + " not found");
        }
        return g;
    }

    private List<Change> parseChange(String value) throws OrmException, QueryParseException {
        if (PAT_LEGACY_ID.matcher(value).matches()) {
            return ChangeData.asChanges(this.args.queryProvider.get().byLegacyChangeId(Change.Id.parse(value)));
        }
        if (PAT_CHANGE_ID.matcher(value).matches()) {
            List<Change> changes = ChangeData.asChanges(this.args.queryProvider.get().byKeyPrefix(ChangeQueryBuilder.parseChangeId(value)));
            if (changes.isEmpty()) {
                throw ChangeQueryBuilder.error("Change " + value + " not found");
            }
            return changes;
        }
        throw ChangeQueryBuilder.error("Change " + value + " not found");
    }

    private static String parseChangeId(String value) {
        if (value.charAt(0) == 'i') {
            value = "I" + value.substring(1);
        }
        return value;
    }

    private Account.Id self() throws QueryParseException {
        return this.args.getIdentifiedUser().getAccountId();
    }

    @VisibleForTesting
    public static class Arguments {
        final AccountCache accountCache;
        final AccountResolver accountResolver;
        final AllProjectsName allProjectsName;
        final AllUsersName allUsersName;
        final CapabilityControl.Factory capabilityControlFactory;
        final ChangeControl.GenericFactory changeControlGenericFactory;
        final ChangeData.Factory changeDataFactory;
        final ChangeIndex index;
        final ChangeIndexRewriter rewriter;
        final ChangeNotes.Factory notesFactory;
        final CommentsUtil commentsUtil;
        final ConflictsCache conflictsCache;
        final DynamicMap<ChangeHasOperandFactory> hasOperands;
        final DynamicMap<ChangeOperatorFactory> opFactories;
        final FieldDef.FillArgs fillArgs;
        final GitRepositoryManager repoManager;
        final GroupBackend groupBackend;
        final IdentifiedUser.GenericFactory userFactory;
        final IndexConfig indexConfig;
        final NotesMigration notesMigration;
        final PatchListCache patchListCache;
        final ProjectCache projectCache;
        final Provider<InternalChangeQuery> queryProvider;
        final Provider<ListChildProjects> listChildProjects;
        final Provider<ListMembers> listMembers;
        final Provider<ReviewDb> db;
        final StarredChangesUtil starredChangesUtil;
        final SubmitDryRun submitDryRun;
        final TrackingFooters trackingFooters;
        final boolean allowsDrafts;
        private final Provider<CurrentUser> self;

        @Inject
        @VisibleForTesting
        public Arguments(Provider<ReviewDb> db, Provider<InternalChangeQuery> queryProvider, ChangeIndexRewriter rewriter, DynamicMap<ChangeOperatorFactory> opFactories, DynamicMap<ChangeHasOperandFactory> hasOperands, IdentifiedUser.GenericFactory userFactory, Provider<CurrentUser> self, CapabilityControl.Factory capabilityControlFactory, ChangeControl.GenericFactory changeControlGenericFactory, ChangeNotes.Factory notesFactory, ChangeData.Factory changeDataFactory, FieldDef.FillArgs fillArgs, CommentsUtil commentsUtil, AccountResolver accountResolver, GroupBackend groupBackend, AllProjectsName allProjectsName, AllUsersName allUsersName, PatchListCache patchListCache, GitRepositoryManager repoManager, ProjectCache projectCache, Provider<ListChildProjects> listChildProjects, ChangeIndexCollection indexes, SubmitDryRun submitDryRun, ConflictsCache conflictsCache, TrackingFooters trackingFooters, IndexConfig indexConfig, Provider<ListMembers> listMembers, StarredChangesUtil starredChangesUtil, AccountCache accountCache, @GerritServerConfig Config cfg, NotesMigration notesMigration) {
            this(db, queryProvider, rewriter, opFactories, hasOperands, userFactory, self, capabilityControlFactory, changeControlGenericFactory, notesFactory, changeDataFactory, fillArgs, commentsUtil, accountResolver, groupBackend, allProjectsName, allUsersName, patchListCache, repoManager, projectCache, listChildProjects, submitDryRun, conflictsCache, trackingFooters, indexes != null ? (ChangeIndex)indexes.getSearchIndex() : null, indexConfig, listMembers, starredChangesUtil, accountCache, cfg == null ? true : cfg.getBoolean(ChangeQueryBuilder.FIELD_CHANGE, "allowDrafts", true), notesMigration);
        }

        private Arguments(Provider<ReviewDb> db, Provider<InternalChangeQuery> queryProvider, ChangeIndexRewriter rewriter, DynamicMap<ChangeOperatorFactory> opFactories, DynamicMap<ChangeHasOperandFactory> hasOperands, IdentifiedUser.GenericFactory userFactory, Provider<CurrentUser> self, CapabilityControl.Factory capabilityControlFactory, ChangeControl.GenericFactory changeControlGenericFactory, ChangeNotes.Factory notesFactory, ChangeData.Factory changeDataFactory, FieldDef.FillArgs fillArgs, CommentsUtil commentsUtil, AccountResolver accountResolver, GroupBackend groupBackend, AllProjectsName allProjectsName, AllUsersName allUsersName, PatchListCache patchListCache, GitRepositoryManager repoManager, ProjectCache projectCache, Provider<ListChildProjects> listChildProjects, SubmitDryRun submitDryRun, ConflictsCache conflictsCache, TrackingFooters trackingFooters, ChangeIndex index, IndexConfig indexConfig, Provider<ListMembers> listMembers, StarredChangesUtil starredChangesUtil, AccountCache accountCache, boolean allowsDrafts, NotesMigration notesMigration) {
            this.db = db;
            this.queryProvider = queryProvider;
            this.rewriter = rewriter;
            this.opFactories = opFactories;
            this.userFactory = userFactory;
            this.self = self;
            this.capabilityControlFactory = capabilityControlFactory;
            this.notesFactory = notesFactory;
            this.changeControlGenericFactory = changeControlGenericFactory;
            this.changeDataFactory = changeDataFactory;
            this.fillArgs = fillArgs;
            this.commentsUtil = commentsUtil;
            this.accountResolver = accountResolver;
            this.groupBackend = groupBackend;
            this.allProjectsName = allProjectsName;
            this.allUsersName = allUsersName;
            this.patchListCache = patchListCache;
            this.repoManager = repoManager;
            this.projectCache = projectCache;
            this.listChildProjects = listChildProjects;
            this.submitDryRun = submitDryRun;
            this.conflictsCache = conflictsCache;
            this.trackingFooters = trackingFooters;
            this.index = index;
            this.indexConfig = indexConfig;
            this.listMembers = listMembers;
            this.starredChangesUtil = starredChangesUtil;
            this.accountCache = accountCache;
            this.allowsDrafts = allowsDrafts;
            this.hasOperands = hasOperands;
            this.notesMigration = notesMigration;
        }

        Arguments asUser(CurrentUser otherUser) {
            return new Arguments(this.db, this.queryProvider, this.rewriter, this.opFactories, this.hasOperands, this.userFactory, Providers.of(otherUser), this.capabilityControlFactory, this.changeControlGenericFactory, this.notesFactory, this.changeDataFactory, this.fillArgs, this.commentsUtil, this.accountResolver, this.groupBackend, this.allProjectsName, this.allUsersName, this.patchListCache, this.repoManager, this.projectCache, this.listChildProjects, this.submitDryRun, this.conflictsCache, this.trackingFooters, this.index, this.indexConfig, this.listMembers, this.starredChangesUtil, this.accountCache, this.allowsDrafts, this.notesMigration);
        }

        Arguments asUser(Account.Id otherId) {
            try {
                CurrentUser u = this.self.get();
                if (u.isIdentifiedUser() && otherId.equals(u.getAccountId())) {
                    return this;
                }
            }
            catch (ProvisionException provisionException) {
                // empty catch block
            }
            return this.asUser(this.userFactory.create(otherId));
        }

        IdentifiedUser getIdentifiedUser() throws QueryRequiresAuthException {
            try {
                CurrentUser u = this.getUser();
                if (u.isIdentifiedUser()) {
                    return u.asIdentifiedUser();
                }
                throw new QueryRequiresAuthException("Not Signed In");
            }
            catch (ProvisionException e) {
                throw new QueryRequiresAuthException("Not Signed In", e);
            }
        }

        CurrentUser getUser() throws QueryRequiresAuthException {
            try {
                return this.self.get();
            }
            catch (ProvisionException e) {
                throw new QueryRequiresAuthException("Not Signed In", e);
            }
        }

        Schema<ChangeData> getSchema() {
            return this.index != null ? this.index.getSchema() : null;
        }
    }

    public static interface ChangeHasOperandFactory
    extends ChangeOperandFactory {
    }

    private static interface ChangeOperandFactory {
        public Predicate<ChangeData> create(ChangeQueryBuilder var1) throws QueryParseException;
    }

    public static interface ChangeOperatorFactory
    extends QueryBuilder.OperatorFactory<ChangeData, ChangeQueryBuilder> {
    }
}

