/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.query.change;

import com.google.common.collect.Lists;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.AccountGroup;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.index.FieldDef;
import com.google.gerrit.server.index.change.ChangeField;
import com.google.gerrit.server.project.ChangeControl;
import com.google.gerrit.server.project.ProjectCache;
import com.google.gerrit.server.query.OrPredicate;
import com.google.gerrit.server.query.Predicate;
import com.google.gerrit.server.query.change.ChangeData;
import com.google.gerrit.server.query.change.ChangeQueryBuilder;
import com.google.gerrit.server.query.change.EqualsLabelPredicate;
import com.google.gerrit.server.util.LabelVote;
import com.google.gerrit.server.util.RangeUtil;
import com.google.inject.Provider;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class LabelPredicate
extends OrPredicate<ChangeData> {
    private static final int MAX_LABEL_VALUE = 4;
    private final String value;

    LabelPredicate(ChangeQueryBuilder.Arguments a, String value, Set<Account.Id> accounts, AccountGroup.UUID group) {
        super(LabelPredicate.predicates(new Args(a.getSchema().getField(ChangeField.LABEL2, ChangeField.LABEL).get(), a.projectCache, a.changeControlGenericFactory, a.userFactory, a.db, value, accounts, group)));
        this.value = value;
    }

    private static List<Predicate<ChangeData>> predicates(Args args) {
        RangeUtil.Range range;
        LabelVote lv2;
        String v = args.value;
        Parsed parsed = null;
        try {
            lv2 = LabelVote.parse(v);
            parsed = new Parsed(lv2.label(), "=", lv2.value());
        }
        catch (IllegalArgumentException lv2) {
            // empty catch block
        }
        try {
            lv2 = LabelVote.parseWithEquals(v);
            parsed = new Parsed(lv2.label(), "=", lv2.value());
        }
        catch (IllegalArgumentException lv3) {
            // empty catch block
        }
        if (parsed == null) {
            range = RangeUtil.getRange(v, -4, 4);
            if (range == null) {
                range = new RangeUtil.Range(v, 1, 1);
            }
        } else {
            range = RangeUtil.getRange(parsed.label, parsed.test, parsed.expVal, -4, 4);
        }
        String prefix = range.prefix;
        int min = range.min;
        int max = range.max;
        ArrayList<Predicate<ChangeData>> r = Lists.newArrayListWithCapacity(max - min + 1);
        for (int i = min; i <= max; ++i) {
            r.add(LabelPredicate.onePredicate(args, prefix, i));
        }
        return r;
    }

    private static Predicate<ChangeData> onePredicate(Args args, String label, int expVal) {
        if (expVal != 0) {
            return LabelPredicate.equalsLabelPredicate(args, label, expVal);
        }
        return LabelPredicate.noLabelQuery(args, label);
    }

    private static Predicate<ChangeData> noLabelQuery(Args args, String label) {
        ArrayList<Predicate<ChangeData>> r = Lists.newArrayListWithCapacity(8);
        for (int i = 1; i <= 4; ++i) {
            r.add(LabelPredicate.equalsLabelPredicate(args, label, i));
            r.add(LabelPredicate.equalsLabelPredicate(args, label, -i));
        }
        return LabelPredicate.not(LabelPredicate.or(r));
    }

    private static Predicate<ChangeData> equalsLabelPredicate(Args args, String label, int expVal) {
        if (args.accounts == null || args.accounts.isEmpty()) {
            return new EqualsLabelPredicate(args, label, expVal, null);
        }
        ArrayList<EqualsLabelPredicate> r = new ArrayList<EqualsLabelPredicate>();
        for (Account.Id a : args.accounts) {
            r.add(new EqualsLabelPredicate(args, label, expVal, a));
        }
        return LabelPredicate.or(r);
    }

    @Override
    public String toString() {
        return "label:" + this.value;
    }

    private static class Parsed {
        private final String label;
        private final String test;
        private final int expVal;

        private Parsed(String label, String test, int expVal) {
            this.label = label;
            this.test = test;
            this.expVal = expVal;
        }
    }

    static class Args {
        final FieldDef<ChangeData, ?> field;
        final ProjectCache projectCache;
        final ChangeControl.GenericFactory ccFactory;
        final IdentifiedUser.GenericFactory userFactory;
        final Provider<ReviewDb> dbProvider;
        final String value;
        final Set<Account.Id> accounts;
        final AccountGroup.UUID group;

        private Args(FieldDef<ChangeData, ?> field, ProjectCache projectCache, ChangeControl.GenericFactory ccFactory, IdentifiedUser.GenericFactory userFactory, Provider<ReviewDb> dbProvider, String value, Set<Account.Id> accounts, AccountGroup.UUID group) {
            this.field = field;
            this.projectCache = projectCache;
            this.ccFactory = ccFactory;
            this.userFactory = userFactory;
            this.dbProvider = dbProvider;
            this.value = value;
            this.accounts = accounts;
            this.group = group;
        }
    }
}

