/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.schema;

import com.google.common.base.Joiner;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.schema.SchemaVersion;
import com.google.gerrit.server.schema.Schema_100;
import com.google.gerrit.server.schema.UpdateUI;
import com.google.gwtorm.jdbc.JdbcExecutor;
import com.google.gwtorm.jdbc.JdbcSchema;
import com.google.gwtorm.schema.ColumnModel;
import com.google.gwtorm.schema.RelationModel;
import com.google.gwtorm.schema.java.JavaSchemaModel;
import com.google.gwtorm.schema.sql.DialectPostgreSQL;
import com.google.gwtorm.schema.sql.SqlDialect;
import com.google.gwtorm.server.OrmException;
import com.google.gwtorm.server.StatementExecutor;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;

public class Schema_101
extends SchemaVersion {
    private Connection conn;
    private SqlDialect dialect;

    @Inject
    Schema_101(Provider<Schema_100> prior) {
        super(prior);
    }

    @Override
    protected void migrateData(ReviewDb db, UpdateUI ui) throws OrmException, SQLException {
        this.conn = ((JdbcSchema)((Object)db)).getConnection();
        this.dialect = ((JdbcSchema)((Object)db)).getDialect();
        Map<String, PrimaryKey> corrections = this.findPKUpdates();
        if (corrections.isEmpty()) {
            return;
        }
        ui.message("Wrong Primary Key Column Order Detected");
        ui.message("The following tables are affected:");
        ui.message(Joiner.on(", ").join(corrections.keySet()));
        ui.message("fixing primary keys...");
        try (JdbcExecutor executor = new JdbcExecutor(this.conn);){
            for (Map.Entry<String, PrimaryKey> c : corrections.entrySet()) {
                ui.message(String.format("  table: %s ... ", c.getKey()));
                this.recreatePK(executor, c.getKey(), c.getValue(), ui);
                ui.message("done");
            }
            ui.message("done");
        }
    }

    private Map<String, PrimaryKey> findPKUpdates() throws OrmException, SQLException {
        TreeMap<String, PrimaryKey> corrections = new TreeMap<String, PrimaryKey>();
        DatabaseMetaData meta = this.conn.getMetaData();
        JavaSchemaModel jsm = new JavaSchemaModel(ReviewDb.class);
        for (RelationModel rm : jsm.getRelations()) {
            String tableName = rm.getRelationName();
            List<String> expectedPKCols = this.relationPK(rm);
            PrimaryKey actualPK = this.dbTablePK(meta, tableName);
            if (expectedPKCols.equals(actualPK.cols)) continue;
            actualPK.cols = expectedPKCols;
            corrections.put(tableName, actualPK);
        }
        return corrections;
    }

    private List<String> relationPK(RelationModel rm) {
        Collection<ColumnModel> cols = rm.getPrimaryKeyColumns();
        ArrayList<String> pk = new ArrayList<String>(cols.size());
        for (ColumnModel cm : cols) {
            pk.add(cm.getColumnName().toLowerCase(Locale.US));
        }
        return pk;
    }

    private PrimaryKey dbTablePK(DatabaseMetaData meta, String tableName) throws SQLException {
        if (meta.storesUpperCaseIdentifiers()) {
            tableName = tableName.toUpperCase();
        } else if (meta.storesLowerCaseIdentifiers()) {
            tableName = tableName.toLowerCase();
        }
        try (ResultSet cols = meta.getPrimaryKeys(null, null, tableName);){
            PrimaryKey pk = new PrimaryKey();
            TreeMap<Short, String> seqToName = new TreeMap<Short, String>();
            while (cols.next()) {
                seqToName.put(cols.getShort("KEY_SEQ"), cols.getString("COLUMN_NAME"));
                if (pk.oldNameInDb != null) continue;
                pk.oldNameInDb = cols.getString("PK_NAME");
            }
            pk.cols = new ArrayList<String>(seqToName.size());
            for (String name : seqToName.values()) {
                pk.cols.add(name.toLowerCase(Locale.US));
            }
            PrimaryKey primaryKey = pk;
            return primaryKey;
        }
    }

    private void recreatePK(StatementExecutor executor, String tableName, PrimaryKey pk, UpdateUI ui) throws OrmException {
        if (pk.oldNameInDb == null) {
            ui.message(String.format("warning: primary key for table %s didn't exist ... ", tableName));
        } else if (this.dialect instanceof DialectPostgreSQL) {
            executor.execute("ALTER TABLE " + tableName + " DROP CONSTRAINT " + pk.oldNameInDb);
        } else {
            executor.execute("ALTER TABLE " + tableName + " DROP PRIMARY KEY");
        }
        executor.execute("ALTER TABLE " + tableName + " ADD PRIMARY KEY(" + Joiner.on(",").join(pk.cols) + ")");
    }

    private static class PrimaryKey {
        String oldNameInDb;
        List<String> cols;

        private PrimaryKey() {
        }
    }
}

