/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.sshd;

import com.google.common.util.concurrent.Atomics;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.gerrit.extensions.events.LifecycleListener;
import com.google.gerrit.extensions.registration.DynamicItem;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.config.GerritServerConfig;
import com.google.gerrit.server.git.WorkQueue;
import com.google.gerrit.sshd.CommandName;
import com.google.gerrit.sshd.DispatchCommand;
import com.google.gerrit.sshd.DispatchCommandProvider;
import com.google.gerrit.sshd.SshCreateCommandInterceptor;
import com.google.gerrit.sshd.SshLog;
import com.google.gerrit.sshd.SshScope;
import com.google.gerrit.sshd.SshSession;
import com.google.gwtorm.server.SchemaFactory;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.sshd.server.Command;
import org.apache.sshd.server.CommandFactory;
import org.apache.sshd.server.Environment;
import org.apache.sshd.server.ExitCallback;
import org.apache.sshd.server.SessionAware;
import org.apache.sshd.server.session.ServerSession;
import org.eclipse.jgit.lib.Config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
class CommandFactoryProvider
implements Provider<CommandFactory>,
LifecycleListener {
    private static final Logger logger = LoggerFactory.getLogger(CommandFactoryProvider.class);
    private final DispatchCommandProvider dispatcher;
    private final SshLog log;
    private final SshScope sshScope;
    private final ScheduledExecutorService startExecutor;
    private final ExecutorService destroyExecutor;
    private final SchemaFactory<ReviewDb> schemaFactory;
    private final DynamicItem<SshCreateCommandInterceptor> createCommandInterceptor;

    @Inject
    CommandFactoryProvider(@CommandName(value="") DispatchCommandProvider d, @GerritServerConfig Config cfg, WorkQueue workQueue, SshLog l, SshScope s, SchemaFactory<ReviewDb> sf, DynamicItem<SshCreateCommandInterceptor> i) {
        this.dispatcher = d;
        this.log = l;
        this.sshScope = s;
        this.schemaFactory = sf;
        this.createCommandInterceptor = i;
        int threads = cfg.getInt("sshd", "commandStartThreads", 2);
        this.startExecutor = workQueue.createQueue(threads, "SshCommandStart", true);
        this.destroyExecutor = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat("SshCommandDestroy-%s").setDaemon(true).build());
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
        this.destroyExecutor.shutdownNow();
    }

    @Override
    public CommandFactory get() {
        return new CommandFactory(){

            @Override
            public Command createCommand(String requestCommand) {
                String c = requestCommand;
                SshCreateCommandInterceptor interceptor = (SshCreateCommandInterceptor)CommandFactoryProvider.this.createCommandInterceptor.get();
                if (interceptor != null) {
                    c = interceptor.intercept(c);
                }
                return new Trampoline(c);
            }
        };
    }

    public static String[] split(String commandLine) {
        ArrayList<String> list = new ArrayList<String>();
        boolean inquote = false;
        boolean inDblQuote = false;
        StringBuilder r = new StringBuilder();
        int ip = 0;
        block6: while (ip < commandLine.length()) {
            char b = commandLine.charAt(ip++);
            switch (b) {
                case '\t': 
                case ' ': {
                    if (inquote || inDblQuote) {
                        r.append(b);
                        continue block6;
                    }
                    if (r.length() <= 0) continue block6;
                    list.add(r.toString());
                    r = new StringBuilder();
                    continue block6;
                }
                case '\"': {
                    if (inquote) {
                        r.append(b);
                        continue block6;
                    }
                    inDblQuote = !inDblQuote;
                    continue block6;
                }
                case '\'': {
                    if (inDblQuote) {
                        r.append(b);
                        continue block6;
                    }
                    inquote = !inquote;
                    continue block6;
                }
                case '\\': {
                    if (inquote || ip == commandLine.length()) {
                        r.append(b);
                        continue block6;
                    }
                    r.append(commandLine.charAt(ip++));
                    continue block6;
                }
            }
            r.append(b);
        }
        if (r.length() > 0) {
            list.add(r.toString());
        }
        return list.toArray(new String[list.size()]);
    }

    private class Trampoline
    implements Command,
    SessionAware {
        private final String commandLine;
        private final String[] argv;
        private InputStream in;
        private OutputStream out;
        private OutputStream err;
        private ExitCallback exit;
        private Environment env;
        private SshScope.Context ctx;
        private DispatchCommand cmd;
        private final AtomicBoolean logged;
        private final AtomicReference<Future<?>> task;

        Trampoline(String cmdLine) {
            this.commandLine = cmdLine;
            this.argv = CommandFactoryProvider.split(cmdLine);
            this.logged = new AtomicBoolean();
            this.task = Atomics.newReference();
        }

        @Override
        public void setInputStream(InputStream in) {
            this.in = in;
        }

        @Override
        public void setOutputStream(OutputStream out) {
            this.out = out;
        }

        @Override
        public void setErrorStream(OutputStream err) {
            this.err = err;
        }

        @Override
        public void setExitCallback(ExitCallback callback) {
            this.exit = callback;
        }

        @Override
        public void setSession(ServerSession session) {
            SshSession s = session.getAttribute(SshSession.KEY);
            this.ctx = CommandFactoryProvider.this.sshScope.newContext(CommandFactoryProvider.this.schemaFactory, s, this.commandLine);
        }

        @Override
        public void start(Environment env) throws IOException {
            this.env = env;
            final SshScope.Context ctx = this.ctx;
            this.task.set(CommandFactoryProvider.this.startExecutor.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        Trampoline.this.onStart();
                    }
                    catch (Exception e) {
                        logger.warn("Cannot start command \"" + ctx.getCommandLine() + "\" for user " + ctx.getSession().getUsername(), e);
                    }
                }

                public String toString() {
                    return "start (user " + ctx.getSession().getUsername() + ")";
                }
            }));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void onStart() throws IOException {
            Trampoline trampoline = this;
            synchronized (trampoline) {
                SshScope.Context old = CommandFactoryProvider.this.sshScope.set(this.ctx);
                try {
                    this.cmd = CommandFactoryProvider.this.dispatcher.get();
                    this.cmd.setArguments(this.argv);
                    this.cmd.setInputStream(this.in);
                    this.cmd.setOutputStream(this.out);
                    this.cmd.setErrorStream(this.err);
                    this.cmd.setExitCallback(new ExitCallback(){

                        @Override
                        public void onExit(int rc, String exitMessage) {
                            Trampoline.this.exit.onExit(Trampoline.this.translateExit(rc), exitMessage);
                            Trampoline.this.log(rc);
                        }

                        @Override
                        public void onExit(int rc) {
                            Trampoline.this.exit.onExit(Trampoline.this.translateExit(rc));
                            Trampoline.this.log(rc);
                        }
                    });
                    this.cmd.start(this.env);
                }
                finally {
                    CommandFactoryProvider.this.sshScope.set(old);
                }
            }
        }

        private int translateExit(int rc) {
            switch (rc) {
                case 0x40000003: {
                    return 1;
                }
                case 0x40000001: {
                    return 15;
                }
                case 0x40000002: {
                    return 127;
                }
            }
            return rc;
        }

        private void log(int rc) {
            if (this.logged.compareAndSet(false, true)) {
                CommandFactoryProvider.this.log.onExecute(this.cmd, rc, this.ctx.getSession());
            }
        }

        @Override
        public void destroy() {
            Future future = this.task.getAndSet(null);
            if (future != null) {
                future.cancel(true);
                CommandFactoryProvider.this.destroyExecutor.execute(new Runnable(){

                    @Override
                    public void run() {
                        Trampoline.this.onDestroy();
                    }
                });
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void onDestroy() {
            Trampoline trampoline = this;
            synchronized (trampoline) {
                if (this.cmd != null) {
                    SshScope.Context old = CommandFactoryProvider.this.sshScope.set(this.ctx);
                    try {
                        this.cmd.destroy();
                        this.log(0x40000001);
                    }
                    finally {
                        this.ctx = null;
                        this.cmd = null;
                        CommandFactoryProvider.this.sshScope.set(old);
                    }
                }
            }
        }
    }
}

