/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.sshd;

import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.gerrit.reviewdb.client.AccountSshKey;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.account.ExternalId;
import com.google.gerrit.server.account.VersionedAuthorizedKeys;
import com.google.gerrit.server.cache.CacheModule;
import com.google.gerrit.server.ssh.SshKeyCache;
import com.google.gerrit.server.ssh.SshKeyCreator;
import com.google.gerrit.sshd.SshKeyCacheEntry;
import com.google.gerrit.sshd.SshKeyCreatorImpl;
import com.google.gerrit.sshd.SshUtil;
import com.google.gwtorm.server.SchemaFactory;
import com.google.inject.Inject;
import com.google.inject.Module;
import com.google.inject.Singleton;
import com.google.inject.TypeLiteral;
import com.google.inject.name.Named;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class SshKeyCacheImpl
implements SshKeyCache {
    private static final Logger log = LoggerFactory.getLogger(SshKeyCacheImpl.class);
    private static final String CACHE_NAME = "sshkeys";
    static final Iterable<SshKeyCacheEntry> NO_SUCH_USER = SshKeyCacheImpl.none();
    static final Iterable<SshKeyCacheEntry> NO_KEYS = SshKeyCacheImpl.none();
    private final LoadingCache<String, Iterable<SshKeyCacheEntry>> cache;

    public static Module module() {
        return new CacheModule(){

            @Override
            protected void configure() {
                this.cache(SshKeyCacheImpl.CACHE_NAME, String.class, new TypeLiteral<Iterable<SshKeyCacheEntry>>(){}).loader(Loader.class);
                this.bind(SshKeyCacheImpl.class);
                this.bind(SshKeyCache.class).to(SshKeyCacheImpl.class);
                this.bind(SshKeyCreator.class).to(SshKeyCreatorImpl.class);
            }
        };
    }

    private static Iterable<SshKeyCacheEntry> none() {
        return Collections.unmodifiableCollection(Arrays.asList(new SshKeyCacheEntry[0]));
    }

    @Inject
    SshKeyCacheImpl(@Named(value="sshkeys") LoadingCache<String, Iterable<SshKeyCacheEntry>> cache) {
        this.cache = cache;
    }

    Iterable<SshKeyCacheEntry> get(String username) {
        try {
            return this.cache.get(username);
        }
        catch (ExecutionException e) {
            log.warn("Cannot load SSH keys for " + username, e);
            return Collections.emptyList();
        }
    }

    @Override
    public void evict(String username) {
        if (username != null) {
            this.cache.invalidate(username);
        }
    }

    static class Loader
    extends CacheLoader<String, Iterable<SshKeyCacheEntry>> {
        private final SchemaFactory<ReviewDb> schema;
        private final VersionedAuthorizedKeys.Accessor authorizedKeys;

        @Inject
        Loader(SchemaFactory<ReviewDb> schema, VersionedAuthorizedKeys.Accessor authorizedKeys) {
            this.schema = schema;
            this.authorizedKeys = authorizedKeys;
        }

        @Override
        public Iterable<SshKeyCacheEntry> load(String username) throws Exception {
            try (ReviewDb db = this.schema.open();){
                List<SshKeyCacheEntry> list;
                ExternalId user = ExternalId.from(db.accountExternalIds().get(ExternalId.Key.create("username", username).asAccountExternalIdKey()));
                if (user == null) {
                    Iterable<SshKeyCacheEntry> iterable = NO_SUCH_USER;
                    return iterable;
                }
                ArrayList<SshKeyCacheEntry> kl = new ArrayList<SshKeyCacheEntry>(4);
                for (AccountSshKey k : this.authorizedKeys.getKeys(user.accountId())) {
                    if (!k.isValid()) continue;
                    this.add(kl, k);
                }
                if (kl.isEmpty()) {
                    list = NO_KEYS;
                    return list;
                }
                list = Collections.unmodifiableList(kl);
                return list;
            }
        }

        private void add(List<SshKeyCacheEntry> kl, AccountSshKey k) {
            try {
                kl.add(new SshKeyCacheEntry(k.getKey(), SshUtil.parse(k)));
            }
            catch (OutOfMemoryError e) {
                throw e;
            }
            catch (Throwable e) {
                this.markInvalid(k);
            }
        }

        private void markInvalid(AccountSshKey k) {
            try {
                log.info("Flagging SSH key " + k.getKey() + " invalid");
                this.authorizedKeys.markKeyInvalid(k.getAccount(), k.getKey().get());
                k.setInvalid();
            }
            catch (IOException | ConfigInvalidException e) {
                log.error("Failed to mark SSH key" + k.getKey() + " invalid", e);
            }
        }
    }
}

