/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.sshd;

import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.AccountSshKey;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.sshd.SshLog;
import com.google.gerrit.sshd.SshScope;
import com.google.gerrit.sshd.SshSession;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import org.apache.commons.codec.binary.Base64;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.future.CloseFuture;
import org.apache.sshd.common.future.SshFutureListener;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;
import org.apache.sshd.server.session.ServerSession;
import org.eclipse.jgit.lib.Constants;

public class SshUtil {
    public static PublicKey parse(AccountSshKey key) throws NoSuchAlgorithmException, InvalidKeySpecException, NoSuchProviderException {
        try {
            String s = key.getEncodedKey();
            if (s == null) {
                throw new InvalidKeySpecException("No key string");
            }
            byte[] bin = Base64.decodeBase64(Constants.encodeASCII(s));
            return new ByteArrayBuffer(bin).getRawPublicKey();
        }
        catch (RuntimeException | SshException e) {
            throw new InvalidKeySpecException("Cannot parse key", e);
        }
    }

    public static String toOpenSshPublicKey(String keyStr) {
        try {
            StringBuilder strBuf = new StringBuilder();
            BufferedReader br = new BufferedReader(new StringReader(keyStr));
            String line = br.readLine();
            if (line == null || !line.equals("---- BEGIN SSH2 PUBLIC KEY ----")) {
                return keyStr;
            }
            while ((line = br.readLine()) != null) {
                if (line.indexOf(58) != -1) continue;
                strBuf.append(line);
                break;
            }
            while ((line = br.readLine()) != null && !line.startsWith("---- ")) {
                strBuf.append(line);
            }
            PublicKey key = new ByteArrayBuffer(Base64.decodeBase64(Constants.encodeASCII(strBuf.toString()))).getRawPublicKey();
            if (key instanceof RSAPublicKey) {
                strBuf.insert(0, "ssh-rsa ");
            } else if (key instanceof DSAPublicKey) {
                strBuf.insert(0, "ssh-dss ");
            } else {
                return keyStr;
            }
            strBuf.append(' ');
            strBuf.append("converted-key");
            return strBuf.toString();
        }
        catch (IOException e) {
            return keyStr;
        }
        catch (RuntimeException re) {
            return keyStr;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean success(String username, ServerSession session, final SshScope sshScope, final SshLog sshLog, final SshSession sd, CurrentUser user) {
        if (sd.getUser() == null) {
            sd.authenticationSuccess(username, user);
            SshScope.Context ctx = sshScope.newContext(null, sd, null);
            SshScope.Context old = sshScope.set(ctx);
            try {
                sshLog.onLogin();
            }
            finally {
                sshScope.set(old);
            }
            session.addCloseFutureListener(new SshFutureListener<CloseFuture>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void operationComplete(CloseFuture future) {
                    SshScope.Context ctx = sshScope.newContext(null, sd, null);
                    SshScope.Context old = sshScope.set(ctx);
                    try {
                        sshLog.onLogout();
                    }
                    finally {
                        sshScope.set(old);
                    }
                }
            });
        }
        return true;
    }

    public static IdentifiedUser createUser(SshSession sd, IdentifiedUser.GenericFactory userFactory, Account.Id account) {
        return userFactory.create(sd.getRemoteAddress(), account);
    }
}

