/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.sshd;

import com.google.common.base.Throwables;
import com.google.common.util.concurrent.Atomics;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.PeerDaemonUser;
import com.google.gerrit.server.config.AuthConfig;
import com.google.gerrit.sshd.BaseCommand;
import com.google.gerrit.sshd.CommandName;
import com.google.gerrit.sshd.DispatchCommand;
import com.google.gerrit.sshd.DispatchCommandProvider;
import com.google.gerrit.sshd.SshScope;
import com.google.gerrit.sshd.SshSession;
import com.google.inject.Inject;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.sshd.server.Command;
import org.apache.sshd.server.Environment;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.Option;

public final class SuExec
extends BaseCommand {
    private final SshScope sshScope;
    private final DispatchCommandProvider dispatcher;
    private boolean enableRunAs;
    private CurrentUser caller;
    private SshSession session;
    private IdentifiedUser.GenericFactory userFactory;
    private SshScope.Context callingContext;
    @Option(name="--as", required=true)
    private Account.Id accountId;
    @Option(name="--from")
    private SocketAddress peerAddress;
    @Argument(index=0, multiValued=true, metaVar="COMMAND")
    private List<String> args = new ArrayList<String>();
    private final AtomicReference<Command> atomicCmd;

    @Inject
    SuExec(SshScope sshScope, @CommandName(value="") DispatchCommandProvider dispatcher, CurrentUser caller, SshSession session, IdentifiedUser.GenericFactory userFactory, SshScope.Context callingContext, AuthConfig config) {
        this.sshScope = sshScope;
        this.dispatcher = dispatcher;
        this.caller = caller;
        this.session = session;
        this.userFactory = userFactory;
        this.callingContext = callingContext;
        this.enableRunAs = config.isRunAsEnabled();
        this.atomicCmd = Atomics.newReference();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start(Environment env) throws IOException {
        try {
            this.checkCanRunAs();
            this.parseCommandLine();
            SshScope.Context ctx = this.callingContext.subContext(this.newSession(), SuExec.join(this.args));
            SshScope.Context old = this.sshScope.set(ctx);
            try {
                DispatchCommand cmd = this.dispatcher.get();
                cmd.setArguments(this.args.toArray(new String[this.args.size()]));
                this.provideStateTo(cmd);
                this.atomicCmd.set(cmd);
                cmd.start(env);
            }
            finally {
                this.sshScope.set(old);
            }
        }
        catch (BaseCommand.UnloggedFailure e) {
            String msg = e.getMessage();
            if (!msg.endsWith("\n")) {
                msg = msg + "\n";
            }
            this.err.write(msg.getBytes(StandardCharsets.UTF_8));
            this.err.flush();
            this.onExit(1);
        }
    }

    private void checkCanRunAs() throws BaseCommand.UnloggedFailure {
        if (!(this.caller instanceof PeerDaemonUser)) {
            if (!this.enableRunAs) {
                throw this.die("suexec disabled by auth.enableRunAs = false");
            }
            if (!this.caller.getCapabilities().canRunAs()) {
                throw this.die("suexec not permitted");
            }
        }
    }

    private SshSession newSession() {
        SocketAddress peer = this.peerAddress == null ? this.session.getRemoteAddress() : this.peerAddress;
        if (this.caller instanceof PeerDaemonUser) {
            this.caller = null;
        }
        return new SshSession(this.session, peer, this.userFactory.runAs(peer, this.accountId, this.caller));
    }

    private static String join(List<String> args) {
        StringBuilder r = new StringBuilder();
        for (String a : args) {
            if (r.length() > 0) {
                r.append(" ");
            }
            r.append(a);
        }
        return r.toString();
    }

    @Override
    public void destroy() {
        Command cmd = this.atomicCmd.getAndSet(null);
        if (cmd != null) {
            try {
                cmd.destroy();
            }
            catch (Exception e) {
                Throwables.throwIfUnchecked(e);
                throw new RuntimeException(e);
            }
        }
    }
}

