/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.sshd.commands;

import com.google.gerrit.extensions.annotations.RequiresCapability;
import com.google.gerrit.sshd.CommandMetaData;
import com.google.gerrit.sshd.SshCommand;
import java.util.Enumeration;
import java.util.Map;
import java.util.TreeMap;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.kohsuke.args4j.Argument;

@RequiresCapability(value="administrateServer")
@CommandMetaData(name="ls-level", description="list the level of loggers", runsAt=CommandMetaData.Mode.MASTER_OR_SLAVE)
public class ListLoggingLevelCommand
extends SshCommand {
    @Argument(index=0, required=false, metaVar="NAME", usage="used to match loggers")
    private String name;

    @Override
    protected void run() {
        TreeMap<String, String> logs = new TreeMap<String, String>();
        Enumeration logger = LogManager.getCurrentLoggers();
        while (logger.hasMoreElements()) {
            Logger log = (Logger)logger.nextElement();
            if (this.name != null && !log.getName().contains(this.name)) continue;
            logs.put(log.getName(), log.getEffectiveLevel().toString());
        }
        for (Map.Entry e : logs.entrySet()) {
            this.stdout.println((String)e.getKey() + ": " + (String)e.getValue());
        }
    }
}

