/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.sshd.commands;

import com.google.gerrit.server.AccessPath;
import com.google.gerrit.server.tools.ToolsCatalog;
import com.google.gerrit.sshd.BaseCommand;
import com.google.inject.Inject;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import org.apache.sshd.server.Environment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ScpCommand
extends BaseCommand {
    private static final String TYPE_DIR = "D";
    private static final String TYPE_FILE = "C";
    private static final Logger log = LoggerFactory.getLogger(ScpCommand.class);
    private boolean opt_r;
    private boolean opt_t;
    private boolean opt_f;
    private String root;
    @Inject
    private ToolsCatalog toc;
    private IOException error;

    ScpCommand() {
    }

    @Override
    public void setArguments(String[] args) {
        this.root = "";
        for (int i = 0; i < args.length; ++i) {
            if (args[i].charAt(0) == '-') {
                block7: for (int j = 1; j < args[i].length(); ++j) {
                    switch (args[i].charAt(j)) {
                        case 'f': {
                            this.opt_f = true;
                            continue block7;
                        }
                        case 'p': {
                            continue block7;
                        }
                        case 'r': {
                            this.opt_r = true;
                            continue block7;
                        }
                        case 't': {
                            this.opt_t = true;
                            continue block7;
                        }
                    }
                }
                continue;
            }
            if (i != args.length - 1) continue;
            this.root = args[args.length - 1];
        }
        if (!this.opt_f && !this.opt_t) {
            this.error = new IOException("Either -f or -t option should be set");
        }
    }

    @Override
    public void start(Environment env) {
        this.startThread(new Runnable(){

            @Override
            public void run() {
                ScpCommand.this.runImp();
            }
        }, AccessPath.SSH_COMMAND);
    }

    private void runImp() {
        block14: {
            try {
                this.readAck();
                if (this.error != null) {
                    throw this.error;
                }
                if (this.opt_f) {
                    ToolsCatalog.Entry ent;
                    if (this.root.startsWith("/")) {
                        this.root = this.root.substring(1);
                    }
                    if (this.root.endsWith("/")) {
                        this.root = this.root.substring(0, this.root.length() - 1);
                    }
                    if (this.root.equals(".")) {
                        this.root = "";
                    }
                    if ((ent = this.toc.get(this.root)) == null) {
                        throw new IOException(this.root + " not found");
                    }
                    if (ToolsCatalog.Entry.Type.FILE == ent.getType()) {
                        this.readFile(ent);
                        break block14;
                    }
                    if (ToolsCatalog.Entry.Type.DIR == ent.getType()) {
                        if (!this.opt_r) {
                            throw new IOException(this.root + " not a regular file");
                        }
                        this.readDir(ent);
                        break block14;
                    }
                    throw new IOException(this.root + " not supported");
                }
                throw new IOException("Unsupported mode");
            }
            catch (IOException e) {
                if (e.getClass() == IOException.class && "Pipe closed".equals(e.getMessage())) {
                    return;
                }
                try {
                    this.out.write(2);
                    this.out.write(e.getMessage().getBytes(StandardCharsets.UTF_8));
                    this.out.write(10);
                    this.out.flush();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                log.debug("Error in scp command", e);
            }
        }
    }

    private String readLine() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int c;
        while ((c = this.in.read()) != 10) {
            if (c == -1) {
                throw new IOException("End of stream");
            }
            baos.write(c);
        }
        return baos.toString();
    }

    private void readFile(ToolsCatalog.Entry ent) throws IOException {
        byte[] data = ent.getBytes();
        if (data == null) {
            throw new FileNotFoundException(ent.getPath());
        }
        this.header(ent, data.length);
        this.readAck();
        this.out.write(data);
        this.ack();
        this.readAck();
    }

    private void readDir(ToolsCatalog.Entry dir) throws IOException {
        this.header(dir, 0);
        this.readAck();
        for (ToolsCatalog.Entry e : dir.getChildren()) {
            if (ToolsCatalog.Entry.Type.DIR == e.getType()) {
                this.readDir(e);
                continue;
            }
            this.readFile(e);
        }
        this.out.write("E\n".getBytes(StandardCharsets.UTF_8));
        this.out.flush();
        this.readAck();
    }

    private void header(ToolsCatalog.Entry dir, int len) throws IOException, UnsupportedEncodingException {
        StringBuilder buf = new StringBuilder();
        switch (dir.getType()) {
            case DIR: {
                buf.append(TYPE_DIR);
                break;
            }
            case FILE: {
                buf.append(TYPE_FILE);
            }
        }
        buf.append("0").append(Integer.toOctalString(dir.getMode()));
        buf.append(" ");
        buf.append(len);
        buf.append(" ");
        buf.append(dir.getName());
        buf.append("\n");
        this.out.write(buf.toString().getBytes(StandardCharsets.UTF_8));
        this.out.flush();
    }

    private void ack() throws IOException {
        this.out.write(0);
        this.out.flush();
    }

    private void readAck() throws IOException {
        switch (this.in.read()) {
            case 0: {
                break;
            }
            case 1: {
                log.debug("Received warning: " + this.readLine());
                break;
            }
            case 2: {
                throw new IOException("Received nack: " + this.readLine());
            }
        }
    }
}

