/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.sshd.commands;

import com.google.common.base.Strings;
import com.google.gerrit.common.TimeUtil;
import com.google.gerrit.common.Version;
import com.google.gerrit.extensions.annotations.RequiresAnyCapability;
import com.google.gerrit.extensions.events.LifecycleListener;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.config.ConfigResource;
import com.google.gerrit.server.config.GetSummary;
import com.google.gerrit.server.config.ListCaches;
import com.google.gerrit.sshd.BaseCommand;
import com.google.gerrit.sshd.CommandMetaData;
import com.google.gerrit.sshd.SshCommand;
import com.google.gerrit.sshd.SshDaemon;
import com.google.inject.Inject;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import org.apache.sshd.common.io.IoAcceptor;
import org.apache.sshd.common.io.IoSession;
import org.apache.sshd.common.io.mina.MinaSession;
import org.apache.sshd.server.Environment;
import org.kohsuke.args4j.Option;

@RequiresAnyCapability(value={"viewCaches", "maintainServer"})
@CommandMetaData(name="show-caches", description="Display current cache statistics", runsAt=CommandMetaData.Mode.MASTER_OR_SLAVE)
final class ShowCaches
extends SshCommand {
    private static volatile long serverStarted;
    @Option(name="--gc", usage="perform Java GC before printing memory stats")
    private boolean gc;
    @Option(name="--show-jvm", usage="show details about the JVM")
    private boolean showJVM;
    @Option(name="--show-threads", usage="show detailed thread counts")
    private boolean showThreads;
    @Inject
    private SshDaemon daemon;
    @Inject
    private ListCaches listCaches;
    @Inject
    private GetSummary getSummary;
    @Inject
    private CurrentUser self;
    @Option(name="--width", aliases={"-w"}, metaVar="COLS", usage="width of output table")
    private int columns = 80;
    private int nw;

    ShowCaches() {
    }

    @Override
    public void start(Environment env) throws IOException {
        String s = env.getEnv().get("COLUMNS");
        if (s != null && !s.isEmpty()) {
            try {
                this.columns = Integer.parseInt(s);
            }
            catch (NumberFormatException err) {
                this.columns = 80;
            }
        }
        super.start(env);
    }

    @Override
    protected void run() throws BaseCommand.UnloggedFailure {
        this.nw = this.columns - 50;
        Date now = new Date();
        this.stdout.format("%-25s %-20s      now  %16s\n", "Gerrit Code Review", Version.getVersion() != null ? Version.getVersion() : "", new SimpleDateFormat("HH:mm:ss   zzz").format(now));
        this.stdout.format("%-25s %-20s   uptime %16s\n", "", "", this.uptime(now.getTime() - serverStarted));
        this.stdout.print('\n');
        this.stdout.print(String.format("%1s %-" + this.nw + "s|%-21s|  %-5s |%-9s|\n", "", "Name", "Entries", "AvgGet", "Hit Ratio"));
        this.stdout.print(String.format("%1s %-" + this.nw + "s|%6s %6s %7s|  %-5s  |%-4s %-4s|\n", "", "", "Mem", "Disk", "Space", "", "Mem", "Disk"));
        this.stdout.print("--");
        for (int i = 0; i < this.nw; ++i) {
            this.stdout.print('-');
        }
        this.stdout.print("+---------------------+---------+---------+\n");
        Collection<ListCaches.CacheInfo> caches = this.getCaches();
        this.printMemoryCoreCaches(caches);
        this.printMemoryPluginCaches(caches);
        this.printDiskCaches(caches);
        this.stdout.print('\n');
        if (this.self.getCapabilities().canMaintainServer()) {
            this.sshSummary();
            GetSummary.SummaryInfo summary = this.getSummary.setGc(this.gc).setJvm(this.showJVM).apply(new ConfigResource());
            this.taskSummary(summary.taskSummary);
            this.memSummary(summary.memSummary);
            this.threadSummary(summary.threadSummary);
            if (this.showJVM && summary.jvmSummary != null) {
                this.jvmSummary(summary.jvmSummary);
            }
        }
        this.stdout.flush();
    }

    private Collection<ListCaches.CacheInfo> getCaches() {
        Map caches = (Map)this.listCaches.apply(new ConfigResource());
        for (Map.Entry entry : caches.entrySet()) {
            ListCaches.CacheInfo cache = (ListCaches.CacheInfo)entry.getValue();
            cache.name = (String)entry.getKey();
        }
        return caches.values();
    }

    private void printMemoryCoreCaches(Collection<ListCaches.CacheInfo> caches) {
        for (ListCaches.CacheInfo cache : caches) {
            if (cache.name.contains("-") || !ListCaches.CacheType.MEM.equals((Object)cache.type)) continue;
            this.printCache(cache);
        }
    }

    private void printMemoryPluginCaches(Collection<ListCaches.CacheInfo> caches) {
        for (ListCaches.CacheInfo cache : caches) {
            if (!cache.name.contains("-") || !ListCaches.CacheType.MEM.equals((Object)cache.type)) continue;
            this.printCache(cache);
        }
    }

    private void printDiskCaches(Collection<ListCaches.CacheInfo> caches) {
        for (ListCaches.CacheInfo cache : caches) {
            if (!ListCaches.CacheType.DISK.equals((Object)cache.type)) continue;
            this.printCache(cache);
        }
    }

    private void printCache(ListCaches.CacheInfo cache) {
        this.stdout.print(String.format("%1s %-" + this.nw + "s|%6s %6s %7s| %7s |%4s %4s|\n", ListCaches.CacheType.DISK.equals((Object)cache.type) ? "D" : "", cache.name, ShowCaches.nullToEmpty(cache.entries.mem), ShowCaches.nullToEmpty(cache.entries.disk), Strings.nullToEmpty(cache.entries.space), Strings.nullToEmpty(cache.averageGet), ShowCaches.formatAsPercent(cache.hitRatio.mem), ShowCaches.formatAsPercent(cache.hitRatio.disk)));
    }

    private static String nullToEmpty(Long l) {
        return l != null ? String.valueOf(l) : "";
    }

    private static String formatAsPercent(Integer i) {
        return i != null ? String.valueOf(i) + "%" : "";
    }

    private void memSummary(GetSummary.MemSummaryInfo memSummary) {
        this.stdout.format("Mem: %s total = %s used + %s free + %s buffers\n", memSummary.total, memSummary.used, memSummary.free, memSummary.buffers);
        this.stdout.format("     %s max\n", memSummary.max);
        this.stdout.format("    %8d open files\n", ShowCaches.nullToZero(memSummary.openFiles));
        this.stdout.print('\n');
    }

    private void threadSummary(GetSummary.ThreadSummaryInfo threadSummary) {
        this.stdout.format("Threads: %d CPUs available, %d threads\n", threadSummary.cpus, threadSummary.threads);
        if (this.showThreads) {
            this.stdout.print(String.format("  %22s", ""));
            for (Thread.State s : Thread.State.values()) {
                this.stdout.print(String.format(" %14s", s.name()));
            }
            this.stdout.print('\n');
            for (Map.Entry entry : threadSummary.counts.entrySet()) {
                this.stdout.print(String.format("  %-22s", entry.getKey()));
                for (Thread.State s : Thread.State.values()) {
                    this.stdout.print(String.format(" %14d", ShowCaches.nullToZero((Integer)((Map)entry.getValue()).get((Object)s))));
                }
                this.stdout.print('\n');
            }
        }
        this.stdout.print('\n');
    }

    private void taskSummary(GetSummary.TaskSummaryInfo taskSummary) {
        this.stdout.format("Tasks: %4d  total = %4d running +   %4d ready + %4d sleeping\n", ShowCaches.nullToZero(taskSummary.total), ShowCaches.nullToZero(taskSummary.running), ShowCaches.nullToZero(taskSummary.ready), ShowCaches.nullToZero(taskSummary.sleeping));
    }

    private static int nullToZero(Integer i) {
        return i != null ? i : 0;
    }

    private void sshSummary() {
        IoAcceptor acceptor = this.daemon.getIoAcceptor();
        if (acceptor == null) {
            return;
        }
        long now = TimeUtil.nowMs();
        Collection<IoSession> list = acceptor.getManagedSessions().values();
        long oldest = now;
        for (IoSession s : list) {
            if (!(s instanceof MinaSession)) continue;
            MinaSession minaSession = (MinaSession)s;
            oldest = Math.min(oldest, minaSession.getSession().getCreationTime());
        }
        this.stdout.format("SSH:   %4d  users, oldest session started %s ago\n", list.size(), this.uptime(now - oldest));
    }

    private void jvmSummary(GetSummary.JvmSummaryInfo jvmSummary) {
        this.stdout.format("JVM: %s %s %s\n", jvmSummary.vmVendor, jvmSummary.vmName, jvmSummary.vmVersion);
        this.stdout.format("  on %s %s %s\n", jvmSummary.osName, jvmSummary.osVersion, jvmSummary.osArch);
        this.stdout.format("  running as %s on %s\n", jvmSummary.user, Strings.nullToEmpty(jvmSummary.host));
        this.stdout.format("  cwd  %s\n", jvmSummary.currentWorkingDirectory);
        this.stdout.format("  site %s\n", jvmSummary.site);
    }

    private String uptime(long uptimeMillis) {
        if (uptimeMillis < 1000L) {
            return String.format("%3d ms", uptimeMillis);
        }
        long uptime = uptimeMillis / 1000L;
        long min = uptime / 60L;
        if (min < 60L) {
            return String.format("%2d min %2d sec", min, uptime - min * 60L);
        }
        long hr = uptime / 3600L;
        if (hr < 24L) {
            min = (uptime - hr * 3600L) / 60L;
            return String.format("%2d hrs %2d min", hr, min);
        }
        long days = uptime / 86400L;
        hr = (uptime - days * 24L * 3600L) / 3600L;
        return String.format("%4d days %2d hrs", days, hr);
    }

    static class StartupListener
    implements LifecycleListener {
        StartupListener() {
        }

        @Override
        public void start() {
            serverStarted = TimeUtil.nowMs();
        }

        @Override
        public void stop() {
        }
    }
}

