/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwtjsonrpc.rebind;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.core.client.JsonUtils;
import com.google.gwt.core.ext.GeneratorContext;
import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.core.ext.typeinfo.JClassType;
import com.google.gwt.core.ext.typeinfo.JField;
import com.google.gwt.core.ext.typeinfo.JPackage;
import com.google.gwt.core.ext.typeinfo.JPrimitiveType;
import com.google.gwt.core.ext.typeinfo.JType;
import com.google.gwt.user.rebind.ClassSourceFileComposerFactory;
import com.google.gwt.user.rebind.SourceWriter;
import com.google.gwtjsonrpc.client.impl.JsonSerializer;
import com.google.gwtjsonrpc.client.impl.ser.EnumSerializer;
import com.google.gwtjsonrpc.client.impl.ser.JavaLangString_JsonSerializer;
import com.google.gwtjsonrpc.client.impl.ser.JavaSqlDate_JsonSerializer;
import com.google.gwtjsonrpc.client.impl.ser.JavaSqlTimestamp_JsonSerializer;
import com.google.gwtjsonrpc.client.impl.ser.JavaUtilDate_JsonSerializer;
import com.google.gwtjsonrpc.client.impl.ser.ListSerializer;
import com.google.gwtjsonrpc.client.impl.ser.ObjectArraySerializer;
import com.google.gwtjsonrpc.client.impl.ser.ObjectMapSerializer;
import com.google.gwtjsonrpc.client.impl.ser.ObjectSerializer;
import com.google.gwtjsonrpc.client.impl.ser.PrimitiveArraySerializer;
import com.google.gwtjsonrpc.client.impl.ser.SetSerializer;
import com.google.gwtjsonrpc.client.impl.ser.StringMapSerializer;
import com.google.gwtjsonrpc.rebind.ProxyCreator;
import java.io.PrintWriter;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

class SerializerCreator {
    private static final String SER_SUFFIX = "_JsonSerializer";
    private static final Comparator<JField> FIELD_COMP = new Comparator<JField>(){

        @Override
        public int compare(JField o1, JField o2) {
            return o1.getName().compareTo(o2.getName());
        }
    };
    private static final HashMap<String, String> defaultSerializers = new HashMap();
    private static final HashMap<String, String> parameterizedSerializers = new HashMap();
    private final HashMap<String, String> generatedSerializers;
    private final GeneratorContext context;
    private JClassType targetType;

    SerializerCreator(GeneratorContext c) {
        this.context = c;
        this.generatedSerializers = new HashMap();
    }

    String create(JClassType targetType, TreeLogger logger) throws UnableToCompleteException {
        String sClassName;
        if (targetType.isParameterized() != null || targetType.isArray() != null) {
            this.ensureSerializersForTypeParameters(logger, (JType)targetType);
        }
        if ((sClassName = this.serializerFor((JType)targetType)) != null) {
            return sClassName;
        }
        this.checkCanSerialize(logger, (JType)targetType, true);
        this.recursivelyCreateSerializers(logger, (JType)targetType);
        this.targetType = targetType;
        SourceWriter srcWriter = this.getSourceWriter(logger, this.context);
        String sn = this.getSerializerQualifiedName(targetType);
        if (!this.generatedSerializers.containsKey(targetType.getQualifiedSourceName())) {
            this.generatedSerializers.put(targetType.getQualifiedSourceName(), sn);
        }
        if (srcWriter == null) {
            return sn;
        }
        if (!targetType.isAbstract()) {
            this.generateSingleton(srcWriter);
        }
        if (targetType.isEnum() != null) {
            this.generateEnumFromJson(srcWriter);
        } else {
            this.generateInstanceMembers(srcWriter);
            this.generatePrintJson(srcWriter);
            this.generateFromJson(srcWriter);
            this.generateGetSets(srcWriter);
        }
        srcWriter.commit(logger);
        return sn;
    }

    private void recursivelyCreateSerializers(TreeLogger logger, JType targetType) throws UnableToCompleteException {
        if (targetType.isPrimitive() != null || SerializerCreator.isBoxedPrimitive(targetType)) {
            return;
        }
        JClassType targetClass = targetType.isClass();
        if (SerializerCreator.needsSuperSerializer(targetClass)) {
            this.create(targetClass.getSuperclass(), logger);
        }
        for (JField f : SerializerCreator.sortFields(targetClass)) {
            this.ensureSerializer(logger, f.getType());
        }
    }

    private void ensureSerializer(TreeLogger logger, JType type) throws UnableToCompleteException {
        if (this.ensureSerializersForTypeParameters(logger, type)) {
            return;
        }
        String qsn = type.getQualifiedSourceName();
        if (defaultSerializers.containsKey(qsn) || parameterizedSerializers.containsKey(qsn)) {
            return;
        }
        this.create((JClassType)type, logger);
    }

    private boolean ensureSerializersForTypeParameters(TreeLogger logger, JType type) throws UnableToCompleteException {
        if (SerializerCreator.isJsonPrimitive(type) || SerializerCreator.isBoxedPrimitive(type)) {
            return true;
        }
        if (type.isArray() != null) {
            this.ensureSerializer(logger, type.isArray().getComponentType());
            return true;
        }
        if (type.isParameterized() != null) {
            for (JClassType t : type.isParameterized().getTypeArgs()) {
                this.ensureSerializer(logger, (JType)t);
            }
        }
        return false;
    }

    void checkCanSerialize(TreeLogger logger, JType type) throws UnableToCompleteException {
        this.checkCanSerialize(logger, type, false);
    }

    void checkCanSerialize(TreeLogger logger, JType type, boolean allowAbstractType) throws UnableToCompleteException {
        if (type.isPrimitive() == JPrimitiveType.LONG) {
            logger.log(TreeLogger.ERROR, "Type 'long' not supported in JSON encoding", null);
            throw new UnableToCompleteException();
        }
        if (type.isPrimitive() == JPrimitiveType.VOID) {
            logger.log(TreeLogger.ERROR, "Type 'void' not supported in JSON encoding", null);
            throw new UnableToCompleteException();
        }
        String qsn = type.getQualifiedSourceName();
        if (type.isEnum() != null) {
            return;
        }
        if (SerializerCreator.isJsonPrimitive(type) || SerializerCreator.isBoxedPrimitive(type)) {
            return;
        }
        if (type.isArray() != null) {
            JType leafType = type.isArray().getLeafType();
            if (leafType.isPrimitive() != null || SerializerCreator.isBoxedPrimitive(leafType)) {
                if (type.isArray().getRank() != 1) {
                    logger.log(TreeLogger.ERROR, "gwtjsonrpc does not support (de)serializing of multi-dimensional arrays of primitves");
                    throw new UnableToCompleteException();
                }
                return;
            }
            this.checkCanSerialize(logger, type.isArray().getComponentType());
            return;
        }
        if (defaultSerializers.containsKey(qsn)) {
            return;
        }
        if (type.isParameterized() != null) {
            JClassType[] typeArgs;
            for (JClassType jClassType : typeArgs = type.isParameterized().getTypeArgs()) {
                this.checkCanSerialize(logger, (JType)jClassType);
            }
            if (parameterizedSerializers.containsKey(qsn)) {
                return;
            }
        } else if (parameterizedSerializers.containsKey(qsn)) {
            logger.log(TreeLogger.ERROR, "Type " + qsn + " requires type paramter(s)", null);
            throw new UnableToCompleteException();
        }
        if (qsn.startsWith("java.") || qsn.startsWith("javax.")) {
            logger.log(TreeLogger.ERROR, "Standard type " + qsn + " not supported in JSON encoding", null);
            throw new UnableToCompleteException();
        }
        if (type.isInterface() != null) {
            logger.log(TreeLogger.ERROR, "Interface " + qsn + " not supported in JSON encoding", null);
            throw new UnableToCompleteException();
        }
        JClassType ct = (JClassType)type;
        if (ct.isAbstract() && !allowAbstractType) {
            logger.log(TreeLogger.ERROR, "Abstract type " + qsn + " not supported here", null);
            throw new UnableToCompleteException();
        }
        for (JClassType jClassType : SerializerCreator.sortFields(ct)) {
            TreeLogger branch = logger.branch(TreeLogger.DEBUG, "In type " + qsn + ", field " + jClassType.getName());
            this.checkCanSerialize(branch, jClassType.getType());
        }
    }

    String serializerFor(JType t) {
        if (t.isArray() != null) {
            JType componentType = t.isArray().getComponentType();
            if (componentType.isPrimitive() != null || SerializerCreator.isBoxedPrimitive(componentType)) {
                return PrimitiveArraySerializer.class.getCanonicalName();
            }
            return ObjectArraySerializer.class.getCanonicalName() + "<" + componentType.getQualifiedSourceName() + ">";
        }
        if (this.isStringMap(t)) {
            return StringMapSerializer.class.getName();
        }
        String qsn = t.getQualifiedSourceName();
        if (defaultSerializers.containsKey(qsn)) {
            return defaultSerializers.get(qsn);
        }
        if (parameterizedSerializers.containsKey(qsn)) {
            return parameterizedSerializers.get(qsn);
        }
        return this.generatedSerializers.get(qsn);
    }

    private boolean isStringMap(JType t) {
        return t.isParameterized() != null && t.getErasedType().isClassOrInterface() != null && t.isParameterized().getTypeArgs().length > 0 && t.isParameterized().getTypeArgs()[0].getQualifiedSourceName().equals(String.class.getName()) && t.getErasedType().isClassOrInterface().isAssignableTo(this.context.getTypeOracle().findType(Map.class.getName()));
    }

    private void generateSingleton(SourceWriter w) {
        w.print("public static final ");
        w.print(this.getSerializerSimpleName());
        w.print(" INSTANCE = new ");
        w.print(this.getSerializerSimpleName());
        w.println("();");
        w.println();
    }

    private void generateInstanceMembers(SourceWriter w) {
        for (JField f : SerializerCreator.sortFields(this.targetType)) {
            JType ft = f.getType();
            if (!SerializerCreator.needsTypeParameter(ft)) continue;
            String serType = this.serializerFor(ft);
            w.print("private final ");
            w.print(serType);
            w.print(" ");
            w.print("ser_" + f.getName());
            w.print(" = ");
            this.generateSerializerReference(ft, w);
            w.println(";");
        }
        w.println();
    }

    void generateSerializerReference(JType type, SourceWriter w) {
        if (type.isArray() != null) {
            JType componentType = type.isArray().getComponentType();
            if (componentType.isPrimitive() != null || SerializerCreator.isBoxedPrimitive(componentType)) {
                w.print(PrimitiveArraySerializer.class.getCanonicalName());
                w.print(".INSTANCE");
            } else {
                w.print("new " + this.serializerFor(type) + "(");
                this.generateSerializerReference(componentType, w);
                w.print(")");
            }
        } else if (SerializerCreator.needsTypeParameter(type)) {
            w.print("new " + this.serializerFor(type) + "(");
            JClassType[] typeArgs = type.isParameterized().getTypeArgs();
            int n = 0;
            if (this.isStringMap(type)) {
                ++n;
            }
            boolean first = true;
            while (n < typeArgs.length) {
                if (first) {
                    first = false;
                } else {
                    w.print(", ");
                }
                this.generateSerializerReference((JType)typeArgs[n], w);
                ++n;
            }
            w.print(")");
        } else {
            w.print(this.serializerFor(type) + ".INSTANCE");
        }
    }

    private void generateGetSets(SourceWriter w) {
        for (JField f : SerializerCreator.sortFields(this.targetType)) {
            if (f.isPrivate()) {
                w.print("private static final native ");
                w.print(f.getType().getQualifiedSourceName());
                w.print(" objectGet_" + f.getName());
                w.print("(");
                w.print(this.targetType.getQualifiedSourceName() + " instance");
                w.print(")");
                w.println("/*-{ ");
                w.indent();
                w.print("return instance.@");
                w.print(this.targetType.getQualifiedSourceName());
                w.print("::");
                w.print(f.getName());
                w.println(";");
                w.outdent();
                w.println("}-*/;");
                w.print("private static final native void ");
                w.print(" objectSet_" + f.getName());
                w.print("(");
                w.print(this.targetType.getQualifiedSourceName() + " instance, ");
                w.print(f.getType().getQualifiedSourceName() + " value");
                w.print(")");
                w.println("/*-{ ");
                w.indent();
                w.print("instance.@");
                w.print(this.targetType.getQualifiedSourceName());
                w.print("::");
                w.print(f.getName());
                w.println(" = value;");
                w.outdent();
                w.println("}-*/;");
            }
            if (f.getType() == JPrimitiveType.CHAR || SerializerCreator.isBoxedCharacter(f.getType())) {
                w.print("private static final native String");
                w.print(" jsonGet0_" + f.getName());
                w.print("(final JavaScriptObject instance)");
                w.println("/*-{ ");
                w.indent();
                w.print("return instance.");
                w.print(f.getName());
                w.println(";");
                w.outdent();
                w.println("}-*/;");
                w.print("private static final ");
                w.print(f.getType() == JPrimitiveType.CHAR ? "char" : "Character");
                w.print(" jsonGet_" + f.getName());
                w.print("(JavaScriptObject instance)");
                w.println(" {");
                w.indent();
                w.print("return ");
                w.print(JsonSerializer.class.getName());
                w.print(".toChar(");
                w.print("jsonGet0_" + f.getName());
                w.print("(instance)");
                w.println(");");
                w.outdent();
                w.println("}");
            } else {
                w.print("private static final native ");
                if (f.getType().isArray() != null) {
                    w.print("JavaScriptObject");
                } else if (SerializerCreator.isJsonPrimitive(f.getType())) {
                    w.print(f.getType().getQualifiedSourceName());
                } else if (SerializerCreator.isBoxedPrimitive(f.getType())) {
                    w.print(this.boxedTypeToPrimitiveTypeName(f.getType()));
                } else {
                    w.print("Object");
                }
                w.print(" jsonGet_" + f.getName());
                w.print("(JavaScriptObject instance)");
                w.println("/*-{ ");
                w.indent();
                w.print("return instance.");
                w.print(f.getName());
                w.println(";");
                w.outdent();
                w.println("}-*/;");
            }
            w.println();
        }
    }

    private void generateEnumFromJson(SourceWriter w) {
        w.print("public ");
        w.print(this.targetType.getQualifiedSourceName());
        w.println(" fromJson(Object in) {");
        w.indent();
        w.print("return in != null");
        w.print(" ? " + this.targetType.getQualifiedSourceName() + ".valueOf((String)in)");
        w.print(" : null");
        w.println(";");
        w.outdent();
        w.println("}");
        w.println();
    }

    private void generatePrintJson(SourceWriter w) {
        JField[] fieldList = SerializerCreator.sortFields(this.targetType);
        w.print("protected int printJsonImpl(int fieldCount, StringBuilder sb, ");
        w.println("Object instance) {");
        w.indent();
        w.print("final ");
        w.print(this.targetType.getQualifiedSourceName());
        w.print(" src = (");
        w.print(this.targetType.getQualifiedSourceName());
        w.println(")instance;");
        if (SerializerCreator.needsSuperSerializer(this.targetType)) {
            w.print("fieldCount = super.printJsonImpl(fieldCount, sb, (");
            w.print(this.targetType.getSuperclass().getQualifiedSourceName());
            w.println(")src);");
        }
        String docomma = "if (fieldCount++ > 0) sb.append(\",\");";
        for (JField f : fieldList) {
            String doget = f.isPrivate() ? "objectGet_" + f.getName() + "(src)" : "src." + f.getName();
            String doname = "sb.append(\"\\\"" + f.getName() + "\\\":\");";
            if (f.getType() == JPrimitiveType.CHAR || SerializerCreator.isBoxedCharacter(f.getType())) {
                w.println("if (fieldCount++ > 0) sb.append(\",\");");
                w.println(doname);
                w.println("sb.append(" + JsonUtils.class.getSimpleName());
                w.println(".escapeValue(String.valueOf(" + doget + ")));");
                continue;
            }
            if (SerializerCreator.isJsonString(f.getType())) {
                w.println("if (" + doget + " != null) {");
                w.indent();
                w.println("if (fieldCount++ > 0) sb.append(\",\");");
                w.println(doname);
                w.println("sb.append(" + JsonUtils.class.getSimpleName() + ".escapeValue(" + doget + "));");
                w.outdent();
                w.println("}");
                w.println();
                continue;
            }
            if (SerializerCreator.isJsonPrimitive(f.getType()) || SerializerCreator.isBoxedPrimitive(f.getType())) {
                w.println("if (fieldCount++ > 0) sb.append(\",\");");
                w.println(doname);
                w.println("sb.append(" + doget + ");");
                w.println();
                continue;
            }
            w.println("if (" + doget + " != null) {");
            w.indent();
            w.println("if (fieldCount++ > 0) sb.append(\",\");");
            w.println(doname);
            if (SerializerCreator.needsTypeParameter(f.getType())) {
                w.print("ser_" + f.getName());
            } else {
                w.print(this.serializerFor(f.getType()) + ".INSTANCE");
            }
            w.println(".printJson(sb, " + doget + ");");
            w.outdent();
            w.println("}");
            w.println();
        }
        w.println("return fieldCount;");
        w.outdent();
        w.println("}");
        w.println();
    }

    private void generateFromJson(SourceWriter w) {
        w.print("public ");
        w.print(this.targetType.getQualifiedSourceName());
        w.println(" fromJson(Object in) {");
        w.indent();
        if (this.targetType.isAbstract()) {
            w.println("throw new UnsupportedOperationException();");
        } else {
            w.println("if (in == null) return null;");
            w.println("final JavaScriptObject jso = (JavaScriptObject)in;");
            w.print("final ");
            w.print(this.targetType.getQualifiedSourceName());
            w.print(" dst = new ");
            w.println(this.targetType.getQualifiedSourceName() + "();");
            w.println("fromJsonImpl(jso, dst);");
            w.println("return dst;");
        }
        w.outdent();
        w.println("}");
        w.println();
        w.print("protected void fromJsonImpl(JavaScriptObject jso,");
        w.print(this.targetType.getQualifiedSourceName());
        w.println(" dst) {");
        w.indent();
        if (SerializerCreator.needsSuperSerializer(this.targetType)) {
            w.print("super.fromJsonImpl(jso, (");
            w.print(this.targetType.getSuperclass().getQualifiedSourceName());
            w.println(")dst);");
        }
        for (JField f : SerializerCreator.sortFields(this.targetType)) {
            String doset1;
            String doset0;
            String doget = "jsonGet_" + f.getName() + "(jso)";
            if (f.isPrivate()) {
                doset0 = "objectSet_" + f.getName() + "(dst, ";
                doset1 = ")";
            } else {
                doset0 = "dst." + f.getName() + " = ";
                doset1 = "";
            }
            if (f.getType().isArray() != null) {
                JType ct = f.getType().isArray().getComponentType();
                w.println("if (" + doget + " != null) {");
                w.indent();
                w.print("final ");
                w.print(ct.getQualifiedSourceName());
                w.print("[] tmp = new ");
                w.print(ct.getQualifiedSourceName());
                w.print("[");
                w.print(ObjectArraySerializer.class.getName());
                w.print(".size(" + doget + ")");
                w.println("];");
                w.println("ser_" + f.getName() + ".fromJson(" + doget + ", tmp);");
                w.print(doset0);
                w.print("tmp");
                w.print(doset1);
                w.println(";");
                w.outdent();
                w.println("}");
                continue;
            }
            if (SerializerCreator.isJsonPrimitive(f.getType())) {
                w.print(doset0);
                w.print(doget);
                w.print(doset1);
                w.println(";");
                continue;
            }
            if (SerializerCreator.isBoxedPrimitive(f.getType())) {
                w.print(doset0);
                w.print("new " + f.getType().getQualifiedSourceName() + "(");
                w.print(doget);
                w.print(")");
                w.print(doset1);
                w.println(";");
                continue;
            }
            w.print(doset0);
            if (SerializerCreator.needsTypeParameter(f.getType())) {
                w.print("ser_" + f.getName());
            } else {
                w.print(this.serializerFor(f.getType()) + ".INSTANCE");
            }
            w.print(".fromJson(" + doget + ")");
            w.print(doset1);
            w.println(";");
        }
        w.outdent();
        w.println("}");
        w.println();
    }

    static boolean isJsonPrimitive(JType t) {
        return t.isPrimitive() != null || SerializerCreator.isJsonString(t);
    }

    static boolean isBoxedPrimitive(JType t) {
        String qsn = t.getQualifiedSourceName();
        return qsn.equals(Boolean.class.getCanonicalName()) || qsn.equals(Byte.class.getCanonicalName()) || SerializerCreator.isBoxedCharacter(t) || qsn.equals(Double.class.getCanonicalName()) || qsn.equals(Float.class.getCanonicalName()) || qsn.equals(Integer.class.getCanonicalName()) || qsn.equals(Short.class.getCanonicalName());
    }

    static boolean isBoxedCharacter(JType t) {
        return t.getQualifiedSourceName().equals(Character.class.getCanonicalName());
    }

    private String boxedTypeToPrimitiveTypeName(JType t) {
        String qsn = t.getQualifiedSourceName();
        if (qsn.equals(Boolean.class.getCanonicalName())) {
            return "boolean";
        }
        if (qsn.equals(Byte.class.getCanonicalName())) {
            return "byte";
        }
        if (qsn.equals(Character.class.getCanonicalName())) {
            return "java.lang.String";
        }
        if (qsn.equals(Double.class.getCanonicalName())) {
            return "double";
        }
        if (qsn.equals(Float.class.getCanonicalName())) {
            return "float";
        }
        if (qsn.equals(Integer.class.getCanonicalName())) {
            return "int";
        }
        if (qsn.equals(Short.class.getCanonicalName())) {
            return "short";
        }
        throw new IllegalArgumentException(t + " is not a boxed type");
    }

    static boolean isJsonString(JType t) {
        return t.getQualifiedSourceName().equals(String.class.getCanonicalName());
    }

    private SourceWriter getSourceWriter(TreeLogger logger, GeneratorContext ctx) {
        JPackage targetPkg = this.targetType.getPackage();
        String pkgName = targetPkg == null ? "" : targetPkg.getName();
        PrintWriter pw = ctx.tryCreate(logger, pkgName, this.getSerializerSimpleName());
        if (pw == null) {
            return null;
        }
        ClassSourceFileComposerFactory cf = new ClassSourceFileComposerFactory(pkgName, this.getSerializerSimpleName());
        cf.addImport(JavaScriptObject.class.getCanonicalName());
        cf.addImport(JsonSerializer.class.getCanonicalName());
        cf.addImport(JsonUtils.class.getCanonicalName());
        if (this.targetType.isEnum() != null) {
            cf.addImport(EnumSerializer.class.getCanonicalName());
            cf.setSuperclass(EnumSerializer.class.getSimpleName() + "<" + this.targetType.getQualifiedSourceName() + ">");
        } else if (SerializerCreator.needsSuperSerializer(this.targetType)) {
            cf.setSuperclass(this.getSerializerQualifiedName(this.targetType.getSuperclass()));
        } else {
            cf.addImport(ObjectSerializer.class.getCanonicalName());
            cf.setSuperclass(ObjectSerializer.class.getSimpleName() + "<" + this.targetType.getQualifiedSourceName() + ">");
        }
        return cf.createSourceWriter(ctx, pw);
    }

    private static boolean needsSuperSerializer(JClassType type) {
        JClassType t = type.getSuperclass();
        while (!Object.class.getName().equals(t.getQualifiedSourceName())) {
            if (SerializerCreator.sortFields(t).length > 0) {
                return true;
            }
            t = t.getSuperclass();
        }
        return false;
    }

    private String getSerializerQualifiedName(JClassType targetType) {
        String[] name = ProxyCreator.synthesizeTopLevelClassName(targetType, SER_SUFFIX);
        return name[0].length() == 0 ? name[1] : name[0] + "." + name[1];
    }

    private String getSerializerSimpleName() {
        return ProxyCreator.synthesizeTopLevelClassName(this.targetType, SER_SUFFIX)[1];
    }

    static boolean needsTypeParameter(JType ft) {
        return ft.isArray() != null || ft.isParameterized() != null && parameterizedSerializers.containsKey(ft.getQualifiedSourceName());
    }

    private static JField[] sortFields(JClassType targetType) {
        ArrayList<JField> r = new ArrayList<JField>();
        for (JField f : targetType.getFields()) {
            if (f.isStatic() || f.isTransient() || f.isFinal()) continue;
            r.add(f);
        }
        Collections.sort(r, FIELD_COMP);
        return r.toArray(new JField[r.size()]);
    }

    static {
        defaultSerializers.put(String.class.getCanonicalName(), JavaLangString_JsonSerializer.class.getCanonicalName());
        defaultSerializers.put(java.util.Date.class.getCanonicalName(), JavaUtilDate_JsonSerializer.class.getCanonicalName());
        defaultSerializers.put(Date.class.getCanonicalName(), JavaSqlDate_JsonSerializer.class.getCanonicalName());
        defaultSerializers.put(Timestamp.class.getCanonicalName(), JavaSqlTimestamp_JsonSerializer.class.getCanonicalName());
        parameterizedSerializers.put(List.class.getCanonicalName(), ListSerializer.class.getCanonicalName());
        parameterizedSerializers.put(Map.class.getCanonicalName(), ObjectMapSerializer.class.getCanonicalName());
        parameterizedSerializers.put(Set.class.getCanonicalName(), SetSerializer.class.getCanonicalName());
    }
}

