/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwtorm.nosql.heap;

import com.google.gwtorm.nosql.generic.GenericDatabase;
import com.google.gwtorm.nosql.generic.GenericSchema;
import com.google.gwtorm.nosql.generic.Row;
import com.google.gwtorm.nosql.heap.TreeMapDatabase;
import com.google.gwtorm.server.AtomicUpdate;
import com.google.gwtorm.server.ListResultSet;
import com.google.gwtorm.server.OrmException;
import com.google.gwtorm.server.ResultSet;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;

public abstract class TreeMapSchema
extends GenericSchema {
    private final TreeMapDatabase<?, ?, ?> db;

    protected TreeMapSchema(TreeMapDatabase<?, ?, ?> d) {
        super((GenericDatabase<?, ?, ?>)d);
        this.db = d;
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet<Row> scan(byte[] fromKey, byte[] toKey, int limit, boolean order) {
        this.db.lock.lock();
        try {
            ArrayList<Row> res = new ArrayList<Row>();
            for (Map.Entry<byte[], byte[]> ent : this.entries(fromKey, toKey)) {
                res.add(new Row(ent.getKey(), ent.getValue()));
                if (limit <= 0 || res.size() != limit) continue;
                break;
            }
            ListResultSet listResultSet = new ListResultSet(res);
            return listResultSet;
        }
        finally {
            this.db.lock.unlock();
        }
    }

    private Set<Map.Entry<byte[], byte[]>> entries(byte[] fromKey, byte[] toKey) {
        return this.db.table.subMap(fromKey, toKey).entrySet();
    }

    @Override
    public void upsert(byte[] key, byte[] data) throws OrmException {
        this.db.lock.lock();
        try {
            this.db.table.put(key, data);
        }
        finally {
            this.db.lock.unlock();
        }
    }

    @Override
    public void delete(byte[] key) throws OrmException {
        this.db.lock.lock();
        try {
            this.db.table.remove(key);
        }
        finally {
            this.db.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void atomicUpdate(byte[] key, AtomicUpdate<byte[]> update) throws OrmException {
        this.db.lock.lock();
        try {
            byte[] oldData = this.fetchRow(key);
            byte[] newData = update.update(oldData);
            if (newData != null) {
                this.upsert(key, newData);
            } else if (oldData != null) {
                this.delete(key);
            }
        }
        finally {
            this.db.lock.unlock();
        }
    }
}

