/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.internal;

import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.template.soy.base.SoyBackendKind;
import com.google.template.soy.data.SanitizedContent;
import com.google.template.soy.data.internalutils.NodeContentKinds;
import com.google.template.soy.jssrc.dsl.CodeChunk;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.aggregate.ListType;
import com.google.template.soy.types.aggregate.MapType;
import com.google.template.soy.types.aggregate.RecordType;
import com.google.template.soy.types.aggregate.UnionType;
import com.google.template.soy.types.primitive.SanitizedType;
import com.google.template.soy.types.proto.SoyProtoType;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import javax.annotation.Nullable;

abstract class JsType {
    private static final JsType ANY_TYPE = new JsType("*"){

        @Override
        Optional<CodeChunk.WithValue> getTypeAssertion(CodeChunk.WithValue value, CodeChunk.Generator codeGenerator) {
            return Optional.absent();
        }
    };
    private static final JsType UNKNOWN_TYPE = new JsType("?"){

        @Override
        Optional<CodeChunk.WithValue> getTypeAssertion(CodeChunk.WithValue value, CodeChunk.Generator codeGenerator) {
            return Optional.absent();
        }
    };
    private static final JsType BOOLEAN_TYPE = new JsType("boolean"){

        @Override
        Optional<CodeChunk.WithValue> getTypeAssertion(CodeChunk.WithValue value, CodeChunk.Generator codeGenerator) {
            return Optional.of(CodeChunk.dottedId("goog.isBoolean").call(value).or(value.tripleEquals(CodeChunk.number(1L)), codeGenerator).or(value.tripleEquals(CodeChunk.number(0L)), codeGenerator));
        }
    };
    private static final JsType NUMBER_TYPE = new JsType("number"){

        @Override
        Optional<CodeChunk.WithValue> getTypeAssertion(CodeChunk.WithValue value, CodeChunk.Generator codeGenerator) {
            return Optional.of(CodeChunk.dottedId("goog.isNumber").call(value));
        }
    };
    private static final JsType STRING_OR_SANITIZED_CONTENT_TYPE = new JsType(ImmutableList.of("string", "!goog.soy.data.SanitizedContent")){

        @Override
        Optional<CodeChunk.WithValue> getTypeAssertion(CodeChunk.WithValue value, CodeChunk.Generator codeGenerator) {
            return Optional.of(CodeChunk.dottedId("goog.isString").call(value).or(value.instanceof_("goog.soy.data.SanitizedContent"), codeGenerator));
        }
    };
    private static final JsType RAW_ARRAY_TYPE = new JsType("!Array"){

        @Override
        Optional<CodeChunk.WithValue> getTypeAssertion(CodeChunk.WithValue value, CodeChunk.Generator codeGenerator) {
            return Optional.of(CodeChunk.dottedId("goog.isArray").call(value));
        }
    };
    private static final JsType RAW_OBJECT_TYPE = new JsType("!Object"){

        @Override
        Optional<CodeChunk.WithValue> getTypeAssertion(CodeChunk.WithValue value, CodeChunk.Generator codeGenerator) {
            return Optional.of(CodeChunk.dottedId("goog.isObject").call(value));
        }
    };
    private static final JsType NULL_OR_UNDEFINED_TYPE = new JsType((Iterable)ImmutableList.of("null", "undefined"), ImmutableList.of(ValueCoercionStrategy.NULL)){

        @Override
        Optional<CodeChunk.WithValue> getTypeAssertion(CodeChunk.WithValue value, CodeChunk.Generator codeGenerator) {
            return Optional.of(value.doubleEqualsNull());
        }
    };
    private static final ImmutableMap<SanitizedContent.ContentKind, JsType> STRICT_TYPES;
    private static final JsType IDOM_HTML_AND_ATTRIBUTES;
    private final ImmutableSortedSet<String> typeExpressions;
    private final ImmutableSet<ValueCoercionStrategy> coercionStrategies;

    static JsType forSoyType(SoyType soyType, boolean isIncrementalDom) {
        switch (soyType.getKind()) {
            case NULL: {
                return NULL_OR_UNDEFINED_TYPE;
            }
            case ANY: {
                return ANY_TYPE;
            }
            case UNKNOWN: {
                return UNKNOWN_TYPE;
            }
            case BOOL: {
                return BOOLEAN_TYPE;
            }
            case FLOAT: 
            case PROTO_ENUM: 
            case INT: {
                return NUMBER_TYPE;
            }
            case STRING: {
                return STRING_OR_SANITIZED_CONTENT_TYPE;
            }
            case ATTRIBUTES: 
            case HTML: {
                if (isIncrementalDom) {
                    return IDOM_HTML_AND_ATTRIBUTES;
                }
            }
            case CSS: 
            case JS: 
            case URI: 
            case TRUSTED_RESOURCE_URI: {
                return STRICT_TYPES.get((Object)((SanitizedType)soyType).getContentKind());
            }
            case LIST: {
                ListType listType = (ListType)soyType;
                if (listType.getElementType().getKind() == SoyType.Kind.ANY) {
                    return RAW_ARRAY_TYPE;
                }
                JsType element = JsType.forSoyType(listType.getElementType(), isIncrementalDom);
                return new JsType("!Array<" + element.typeExpr() + ">"){

                    @Override
                    Optional<CodeChunk.WithValue> getTypeAssertion(CodeChunk.WithValue value, CodeChunk.Generator codeGenerator) {
                        return Optional.of(CodeChunk.dottedId("goog.isArray").call(value));
                    }
                };
            }
            case MAP: {
                MapType mapType = (MapType)soyType;
                if (mapType.getKeyType().getKind() == SoyType.Kind.ANY && mapType.getValueType().getKind() == SoyType.Kind.ANY) {
                    return RAW_OBJECT_TYPE;
                }
                JsType keyTypeName = JsType.forSoyType(mapType.getKeyType(), isIncrementalDom);
                JsType valueTypeName = JsType.forSoyType(mapType.getValueType(), isIncrementalDom);
                return new JsType("!Object<" + keyTypeName.typeExpr() + "," + valueTypeName.typeExpr() + ">"){

                    @Override
                    Optional<CodeChunk.WithValue> getTypeAssertion(CodeChunk.WithValue value, CodeChunk.Generator codeGenerator) {
                        return Optional.of(CodeChunk.dottedId("goog.isObject").call(value));
                    }
                };
            }
            case PROTO: {
                final String protoTypeName = ((SoyProtoType)soyType).getNameForBackend(SoyBackendKind.JS_SRC);
                return new JsType(protoTypeName, ValueCoercionStrategy.PROTO){

                    @Override
                    Optional<CodeChunk.WithValue> getTypeAssertion(CodeChunk.WithValue value, CodeChunk.Generator codeGenerator) {
                        return Optional.of(value.instanceof_(protoTypeName));
                    }
                };
            }
            case RECORD: {
                RecordType recordType = (RecordType)soyType;
                if (recordType.getMembers().isEmpty()) {
                    return RAW_OBJECT_TYPE;
                }
                LinkedHashMap members = new LinkedHashMap();
                for (Map.Entry member : recordType.getMembers().entrySet()) {
                    members.put(member.getKey(), JsType.forSoyType((SoyType)member.getValue(), isIncrementalDom).typeExprForRecordMember());
                }
                return new JsType("{" + Joiner.on(", ").withKeyValueSeparator(": ").join(members) + "}"){

                    @Override
                    Optional<CodeChunk.WithValue> getTypeAssertion(CodeChunk.WithValue value, CodeChunk.Generator codeGenerator) {
                        return Optional.of(CodeChunk.dottedId("goog.isObject").call(value));
                    }
                };
            }
            case UNION: {
                UnionType unionType = (UnionType)soyType;
                LinkedHashSet<String> typeExprs = new LinkedHashSet<String>();
                LinkedHashSet<ValueCoercionStrategy> strategies = new LinkedHashSet<ValueCoercionStrategy>();
                final LinkedHashSet<JsType> types = new LinkedHashSet<JsType>();
                boolean isNullable = unionType.isNullable();
                if (isNullable) {
                    typeExprs.addAll(JsType.NULL_OR_UNDEFINED_TYPE.typeExpressions);
                    strategies.add(ValueCoercionStrategy.NULL);
                    types.add(NULL_OR_UNDEFINED_TYPE);
                }
                for (SoyType member : unionType.getMembers()) {
                    if (member.getKind() == SoyType.Kind.NULL) continue;
                    JsType memberType = JsType.forSoyType(member, isIncrementalDom);
                    typeExprs.addAll(memberType.typeExpressions);
                    strategies.addAll(memberType.coercionStrategies);
                    types.add(memberType);
                }
                return new JsType(typeExprs, strategies){

                    @Override
                    Optional<CodeChunk.WithValue> getTypeAssertion(CodeChunk.WithValue value, CodeChunk.Generator codeGenerator) {
                        CodeChunk.WithValue result = null;
                        for (JsType memberType : types) {
                            Optional<CodeChunk.WithValue> typeAssertion = memberType.getTypeAssertion(value, codeGenerator);
                            if (!typeAssertion.isPresent()) {
                                return Optional.absent();
                            }
                            if (result == null) {
                                result = typeAssertion.get();
                                continue;
                            }
                            result = result.or(typeAssertion.get(), codeGenerator);
                        }
                        return Optional.of(result);
                    }
                };
            }
        }
        throw new AssertionError((Object)("unhandled soytype: " + soyType));
    }

    private JsType(String typeExpr) {
        this(ImmutableList.of(typeExpr), ImmutableSet.of());
    }

    private JsType(Iterable<String> typeExprs) {
        this(typeExprs, ImmutableSet.of());
    }

    private JsType(String typeExpr, ValueCoercionStrategy coercionStrategy) {
        this(ImmutableList.of(typeExpr), ImmutableSet.of(coercionStrategy));
    }

    private JsType(Iterable<String> typeExprs, Iterable<ValueCoercionStrategy> coercionStrategies) {
        this.typeExpressions = ImmutableSortedSet.copyOf(typeExprs);
        Preconditions.checkArgument(!this.typeExpressions.isEmpty());
        EnumSet<ValueCoercionStrategy> strategies = EnumSet.noneOf(ValueCoercionStrategy.class);
        Iterables.addAll(strategies, coercionStrategies);
        this.coercionStrategies = Sets.immutableEnumSet(strategies);
    }

    String typeExpr() {
        return Joiner.on('|').join(this.typeExpressions);
    }

    String typeExprForRecordMember() {
        if (this.typeExpressions.size() > 1 || this.typeExpressions.first().equals("?")) {
            return "(" + this.typeExpr() + ")";
        }
        return this.typeExpr();
    }

    abstract Optional<CodeChunk.WithValue> getTypeAssertion(CodeChunk.WithValue var1, CodeChunk.Generator var2);

    @Nullable
    final CodeChunk.WithValue getValueCoercion(CodeChunk.WithValue value, CodeChunk.Generator codeGenerator) {
        boolean needsProtoCoercion = this.coercionStrategies.contains((Object)ValueCoercionStrategy.PROTO);
        if (!needsProtoCoercion) {
            return null;
        }
        CodeChunk.WithValue coercion = value.dotAccess("$jspbMessageInstance").or(value, codeGenerator);
        return this.coercionStrategies.contains((Object)ValueCoercionStrategy.NULL) ? value.and(coercion, codeGenerator) : coercion;
    }

    private static JsType createSanitized(SanitizedContent.ContentKind kind) {
        final String type = NodeContentKinds.toJsSanitizedContentCtorName(kind);
        ArrayList<String> typeExprs = new ArrayList<String>();
        typeExprs.add("!" + type);
        typeExprs.add("string");
        typeExprs.add("!goog.soy.data.UnsanitizedText");
        switch (kind) {
            case CSS: {
                typeExprs.add("!goog.html.SafeStyle");
                break;
            }
            case HTML: {
                typeExprs.add("!goog.html.SafeHtml");
                break;
            }
            case JS: {
                typeExprs.add("!goog.html.SafeScript");
                break;
            }
            case ATTRIBUTES: 
            case TEXT: {
                break;
            }
            case TRUSTED_RESOURCE_URI: {
                typeExprs.add("!goog.html.TrustedResourceUrl");
                break;
            }
            case URI: {
                typeExprs.add("!goog.html.TrustedResourceUrl");
                typeExprs.add("!goog.html.SafeUrl");
                typeExprs.add("!goog.Uri");
                break;
            }
            default: {
                throw new AssertionError((Object)"Unhandled content kind");
            }
        }
        return new JsType(typeExprs){

            @Override
            Optional<CodeChunk.WithValue> getTypeAssertion(CodeChunk.WithValue value, CodeChunk.Generator codeGenerator) {
                return Optional.of(CodeChunk.dottedId(type).dotAccess("isCompatibleWith").call(value));
            }
        };
    }

    static {
        IDOM_HTML_AND_ATTRIBUTES = new JsType("function()"){

            @Override
            Optional<CodeChunk.WithValue> getTypeAssertion(CodeChunk.WithValue value, CodeChunk.Generator codeGenerator) {
                return Optional.of(CodeChunk.dottedId("goog.isFunction").call(value));
            }
        };
        EnumMap<SanitizedContent.ContentKind, JsType> types = new EnumMap<SanitizedContent.ContentKind, JsType>(SanitizedContent.ContentKind.class);
        for (SanitizedContent.ContentKind kind : SanitizedContent.ContentKind.values()) {
            types.put(kind, JsType.createSanitized(kind));
        }
        STRICT_TYPES = Maps.immutableEnumMap(types);
    }

    private static enum ValueCoercionStrategy {
        NULL,
        PROTO;

    }
}

