/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.basetree.CopyState;
import com.google.template.soy.exprparse.ExpressionParser;
import com.google.template.soy.exprparse.SoyParsingContext;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.soytree.AbstractSoyNode;
import com.google.template.soy.soytree.ExprUnion;
import com.google.template.soy.soytree.SoyNode;
import java.util.ArrayList;
import java.util.List;

public final class PrintDirectiveNode
extends AbstractSoyNode
implements SoyNode.ExprHolderNode {
    private final String name;
    private final String argsText;
    private final ImmutableList<ExprRootNode> args;

    private PrintDirectiveNode(int id, String name, ImmutableList<ExprRootNode> args, String argsText, SourceLocation sourceLocation) {
        super(id, sourceLocation);
        this.name = name;
        this.args = args;
        this.argsText = argsText;
    }

    private PrintDirectiveNode(PrintDirectiveNode orig, CopyState copyState) {
        super(orig, copyState);
        this.name = orig.name;
        this.argsText = orig.argsText;
        ArrayList<ExprRootNode> tempArgs = Lists.newArrayListWithCapacity(orig.args.size());
        for (ExprRootNode origArg : orig.args) {
            tempArgs.add(origArg.copy(copyState));
        }
        this.args = ImmutableList.copyOf(tempArgs);
    }

    @Override
    public SoyNode.Kind getKind() {
        return SoyNode.Kind.PRINT_DIRECTIVE_NODE;
    }

    public String getName() {
        return this.name;
    }

    public List<ExprRootNode> getArgs() {
        return this.args;
    }

    @Override
    public String toSourceString() {
        return this.name + (this.argsText.length() > 0 ? ":" + this.argsText : "");
    }

    @Override
    public List<ExprUnion> getAllExprUnions() {
        return ExprUnion.createList(this.args);
    }

    @Override
    public PrintDirectiveNode copy(CopyState copyState) {
        return new PrintDirectiveNode(this, copyState);
    }

    public static final class Builder {
        private final int id;
        private final String name;
        private final String argsText;
        private final SourceLocation sourceLocation;

        public Builder(int id, String name, String argsText, SourceLocation sourceLocation) {
            this.id = id;
            this.name = name;
            this.argsText = argsText;
            this.sourceLocation = sourceLocation;
        }

        public PrintDirectiveNode build(SoyParsingContext context) {
            ImmutableList<ExprRootNode> args = this.parseArgs(context);
            return new PrintDirectiveNode(this.id, this.name, args, this.argsText, this.sourceLocation);
        }

        private ImmutableList<ExprRootNode> parseArgs(SoyParsingContext context) {
            if (this.argsText.isEmpty()) {
                return ImmutableList.of();
            }
            ImmutableList.Builder args = ImmutableList.builder();
            for (ExprNode expr : new ExpressionParser(this.argsText, this.sourceLocation, context).parseExpressionList()) {
                args.add(new ExprRootNode(expr));
            }
            return args.build();
        }
    }
}

