/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.subsystem.sftp;

import java.util.Collection;
import java.util.List;
import java.util.stream.StreamSupport;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.NumberUtils;
import org.apache.sshd.common.util.ValidateUtils;

@FunctionalInterface
public interface SftpVersionSelector {
    public static final SftpVersionSelector CURRENT = new NamedVersionSelector("CURRENT", (session, current, available) -> current);
    public static final SftpVersionSelector MAXIMUM = new NamedVersionSelector("MAXIMUM", (session, current, available) -> GenericUtils.stream(available).mapToInt(Integer::intValue).max().orElse(current));
    public static final SftpVersionSelector MINIMUM = new NamedVersionSelector("MINIMUM", (session, current, available) -> GenericUtils.stream(available).mapToInt(Integer::intValue).min().orElse(current));

    public int selectVersion(ClientSession var1, int var2, List<Integer> var3);

    public static SftpVersionSelector fixedVersionSelector(int version) {
        return (session, current, available) -> version;
    }

    public static SftpVersionSelector preferredVersionSelector(int ... preferred) {
        return SftpVersionSelector.preferredVersionSelector(NumberUtils.asList(preferred));
    }

    public static SftpVersionSelector preferredVersionSelector(Iterable<? extends Number> preferred) {
        ValidateUtils.checkNotNullAndNotEmpty((Collection)preferred, "Empty preferred versions", new Object[0]);
        return (session, current, available) -> StreamSupport.stream(preferred.spliterator(), false).mapToInt(Number::intValue).filter(v -> v == current || available.contains(v)).findFirst().orElseThrow(() -> new IllegalStateException("Preferred versions (" + preferred + ") not available: " + available));
    }

    public static class NamedVersionSelector
    implements SftpVersionSelector {
        private final String name;
        private final SftpVersionSelector selector;

        public NamedVersionSelector(String name, SftpVersionSelector selector) {
            this.name = name;
            this.selector = selector;
        }

        @Override
        public int selectVersion(ClientSession session, int current, List<Integer> available) {
            return this.selector.selectVersion(session, current, available);
        }

        public String toString() {
            return this.name;
        }
    }
}

