/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled.buffers;

import com.github.parboiled1.grappa.buffers.LineCounter;
import com.google.common.base.Preconditions;
import com.google.common.collect.Range;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.nio.CharBuffer;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import org.parboiled.buffers.InputBuffer;
import org.parboiled.support.IndexRange;
import org.parboiled.support.Position;

@Immutable
public final class CharSequenceInputBuffer
implements InputBuffer {
    private static final ExecutorService EXECUTOR_SERVICE;
    private final CharSequence charSequence;
    private final Future<LineCounter> lineCounter;

    public CharSequenceInputBuffer(final @Nonnull CharSequence charSequence) {
        this.charSequence = Preconditions.checkNotNull(charSequence);
        this.lineCounter = EXECUTOR_SERVICE.submit(new Callable<LineCounter>(){

            @Override
            public LineCounter call() throws Exception {
                return new LineCounter(charSequence);
            }
        });
    }

    public CharSequenceInputBuffer(@Nonnull char[] chars) {
        this(CharBuffer.wrap(Preconditions.checkNotNull(chars)));
    }

    @Override
    public char charAt(int index) {
        return index >= 0 && index < this.charSequence.length() ? this.charSequence.charAt(index) : (char)'\uffff';
    }

    @Override
    public boolean test(int index, char[] characters) {
        int length = characters.length;
        if (index + length > this.charSequence.length()) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (this.charSequence.charAt(index + i) == characters[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public String extract(int start, int end) {
        int realStart = Math.max(start, 0);
        int realEnd = Math.min(end, this.charSequence.length());
        return ((Object)this.charSequence.subSequence(realStart, realEnd)).toString();
    }

    @Override
    public String extract(IndexRange range) {
        return this.extract(range.start, range.end);
    }

    @Override
    public Position getPosition(int index) {
        return Futures.getUnchecked(this.lineCounter).toPosition(index);
    }

    @Override
    public int getOriginalIndex(int index) {
        return index;
    }

    @Override
    public String extractLine(int lineNumber) {
        Preconditions.checkArgument(lineNumber > 0, "line number is negative");
        LineCounter counter = Futures.getUnchecked(this.lineCounter);
        Range<Integer> range = counter.getLineRange(lineNumber);
        int start = range.lowerEndpoint();
        int end = range.upperEndpoint();
        if (this.charAt(end - 1) == '\n') {
            --end;
        }
        if (this.charAt(end - 1) == '\r') {
            --end;
        }
        return this.extract(start, end);
    }

    @Override
    public int getLineCount() {
        return Futures.getUnchecked(this.lineCounter).getNrLines();
    }

    static {
        ThreadFactory factory = new ThreadFactoryBuilder().setDaemon(true).setNameFormat("linecounter-thread-%d").build();
        EXECUTOR_SERVICE = Executors.newCachedThreadPool(factory);
    }
}

