/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.httpd;

import com.google.common.cache.Cache;
import com.google.common.collect.Lists;
import com.google.gerrit.common.Nullable;
import com.google.gerrit.common.data.Capable;
import com.google.gerrit.extensions.registration.DynamicSet;
import com.google.gerrit.httpd.AdvertisedObjectsCacheKey;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.AccessPath;
import com.google.gerrit.server.AnonymousUser;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.cache.CacheModule;
import com.google.gerrit.server.git.AsyncReceiveCommits;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.gerrit.server.git.ReceiveCommits;
import com.google.gerrit.server.git.SearchingChangeCacheImpl;
import com.google.gerrit.server.git.TagCache;
import com.google.gerrit.server.git.TransferConfig;
import com.google.gerrit.server.git.VisibleRefFilter;
import com.google.gerrit.server.git.validators.UploadValidators;
import com.google.gerrit.server.notedb.ChangeNotes;
import com.google.gerrit.server.project.NoSuchProjectException;
import com.google.gerrit.server.project.ProjectControl;
import com.google.inject.AbstractModule;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.TypeLiteral;
import com.google.inject.name.Named;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jgit.errors.RepositoryNotFoundException;
import org.eclipse.jgit.http.server.GitServlet;
import org.eclipse.jgit.http.server.GitSmartHttpTools;
import org.eclipse.jgit.http.server.ServletUtils;
import org.eclipse.jgit.http.server.resolver.AsIsFileService;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.PostUploadHook;
import org.eclipse.jgit.transport.PostUploadHookChain;
import org.eclipse.jgit.transport.PreUploadHook;
import org.eclipse.jgit.transport.PreUploadHookChain;
import org.eclipse.jgit.transport.ReceivePack;
import org.eclipse.jgit.transport.UploadPack;
import org.eclipse.jgit.transport.resolver.ReceivePackFactory;
import org.eclipse.jgit.transport.resolver.RepositoryResolver;
import org.eclipse.jgit.transport.resolver.ServiceNotAuthorizedException;
import org.eclipse.jgit.transport.resolver.ServiceNotEnabledException;
import org.eclipse.jgit.transport.resolver.UploadPackFactory;

@Singleton
public class GitOverHttpServlet
extends GitServlet {
    private static final long serialVersionUID = 1L;
    private static final String ATT_CONTROL = ProjectControl.class.getName();
    private static final String ATT_RC = ReceiveCommits.class.getName();
    private static final String ID_CACHE = "adv_bases";
    public static final String URL_REGEX;

    @Inject
    GitOverHttpServlet(Resolver resolver, UploadFactory upload, UploadFilter uploadFilter, ReceivePackFactory<HttpServletRequest> receive, ReceiveFilter receiveFilter) {
        this.setRepositoryResolver(resolver);
        this.setAsIsFileService(AsIsFileService.DISABLED);
        this.setUploadPackFactory(upload);
        this.addUploadPackFilter(uploadFilter);
        this.setReceivePackFactory(receive);
        this.addReceivePackFilter(receiveFilter);
    }

    static {
        StringBuilder url = new StringBuilder();
        url.append("^(?:/a)?(?:/p/|/)(.*/(?:info/refs");
        for (String name : GitSmartHttpTools.VALID_SERVICES) {
            url.append('|').append(name);
        }
        url.append("))$");
        URL_REGEX = url.toString();
    }

    static class ReceiveFilter
    implements Filter {
        private final Cache<AdvertisedObjectsCacheKey, Set<ObjectId>> cache;

        @Inject
        ReceiveFilter(@Named(value="adv_bases") Cache<AdvertisedObjectsCacheKey, Set<ObjectId>> cache) {
            this.cache = cache;
        }

        @Override
        public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
            boolean isGet = "GET".equalsIgnoreCase(((HttpServletRequest)request).getMethod());
            ReceiveCommits rc = (ReceiveCommits)request.getAttribute(ATT_RC);
            ReceivePack rp = rc.getReceivePack();
            rp.getAdvertiseRefsHook().advertiseRefs(rp);
            ProjectControl pc = (ProjectControl)request.getAttribute(ATT_CONTROL);
            Project.NameKey projectName = pc.getProject().getNameKey();
            if (!pc.canRunReceivePack()) {
                GitSmartHttpTools.sendError((HttpServletRequest)request, (HttpServletResponse)response, 403, "receive-pack not permitted on this server");
                return;
            }
            Capable s = rc.canUpload();
            if (s != Capable.OK) {
                GitSmartHttpTools.sendError((HttpServletRequest)request, (HttpServletResponse)response, 403, "\n" + s.getMessage());
                return;
            }
            if (!rp.isCheckReferencedObjectsAreReachable()) {
                chain.doFilter(request, response);
                return;
            }
            if (!pc.getUser().isIdentifiedUser()) {
                chain.doFilter(request, response);
                return;
            }
            AdvertisedObjectsCacheKey cacheKey = AdvertisedObjectsCacheKey.create(pc.getUser().getAccountId(), projectName);
            if (isGet) {
                this.cache.invalidate(cacheKey);
            } else {
                Set<ObjectId> ids = this.cache.getIfPresent(cacheKey);
                if (ids != null) {
                    rp.getAdvertisedObjects().addAll(ids);
                    this.cache.invalidate(cacheKey);
                }
            }
            chain.doFilter(request, response);
            if (isGet) {
                this.cache.put(cacheKey, Collections.unmodifiableSet(new HashSet<ObjectId>(rp.getAdvertisedObjects())));
            }
        }

        @Override
        public void init(FilterConfig arg0) {
        }

        @Override
        public void destroy() {
        }
    }

    static class DisabledReceiveFactory
    implements ReceivePackFactory<HttpServletRequest> {
        DisabledReceiveFactory() {
        }

        @Override
        public ReceivePack create(HttpServletRequest req, Repository db) throws ServiceNotEnabledException {
            throw new ServiceNotEnabledException();
        }
    }

    static class ReceiveFactory
    implements ReceivePackFactory<HttpServletRequest> {
        private final AsyncReceiveCommits.Factory factory;

        @Inject
        ReceiveFactory(AsyncReceiveCommits.Factory factory) {
            this.factory = factory;
        }

        @Override
        public ReceivePack create(HttpServletRequest req, Repository db) throws ServiceNotAuthorizedException {
            ProjectControl pc = (ProjectControl)req.getAttribute(ATT_CONTROL);
            if (!pc.getUser().isIdentifiedUser()) {
                throw new ServiceNotAuthorizedException();
            }
            ReceiveCommits rc = this.factory.create(pc, db).getReceiveCommits();
            rc.init();
            ReceivePack rp = rc.getReceivePack();
            req.setAttribute(ATT_RC, rc);
            return rp;
        }
    }

    static class UploadFilter
    implements Filter {
        private final Provider<ReviewDb> db;
        private final TagCache tagCache;
        private final ChangeNotes.Factory changeNotesFactory;
        @Nullable
        private final SearchingChangeCacheImpl changeCache;
        private final UploadValidators.Factory uploadValidatorsFactory;

        @Inject
        UploadFilter(Provider<ReviewDb> db, TagCache tagCache, ChangeNotes.Factory changeNotesFactory, @Nullable SearchingChangeCacheImpl changeCache, UploadValidators.Factory uploadValidatorsFactory) {
            this.db = db;
            this.tagCache = tagCache;
            this.changeNotesFactory = changeNotesFactory;
            this.changeCache = changeCache;
            this.uploadValidatorsFactory = uploadValidatorsFactory;
        }

        @Override
        public void doFilter(ServletRequest request, ServletResponse response, FilterChain next) throws IOException, ServletException {
            Repository repo = ServletUtils.getRepository(request);
            ProjectControl pc = (ProjectControl)request.getAttribute(ATT_CONTROL);
            UploadPack up = (UploadPack)request.getAttribute("org.eclipse.jgit.transport.UploadPackOrReceivePack");
            if (!pc.canRunUploadPack()) {
                GitSmartHttpTools.sendError((HttpServletRequest)request, (HttpServletResponse)response, 403, "upload-pack not permitted on this server");
                return;
            }
            UploadValidators uploadValidators = this.uploadValidatorsFactory.create(pc.getProject(), repo, request.getRemoteHost());
            up.setPreUploadHook(PreUploadHookChain.newChain(Lists.newArrayList(up.getPreUploadHook(), uploadValidators)));
            up.setAdvertiseRefsHook(new VisibleRefFilter(this.tagCache, this.changeNotesFactory, this.changeCache, repo, pc, this.db.get(), true));
            next.doFilter(request, response);
        }

        @Override
        public void init(FilterConfig config) {
        }

        @Override
        public void destroy() {
        }
    }

    static class UploadFactory
    implements UploadPackFactory<HttpServletRequest> {
        private final TransferConfig config;
        private final DynamicSet<PreUploadHook> preUploadHooks;
        private final DynamicSet<PostUploadHook> postUploadHooks;

        @Inject
        UploadFactory(TransferConfig tc, DynamicSet<PreUploadHook> preUploadHooks, DynamicSet<PostUploadHook> postUploadHooks) {
            this.config = tc;
            this.preUploadHooks = preUploadHooks;
            this.postUploadHooks = postUploadHooks;
        }

        @Override
        public UploadPack create(HttpServletRequest req, Repository repo) {
            UploadPack up = new UploadPack(repo);
            up.setPackConfig(this.config.getPackConfig());
            up.setTimeout(this.config.getTimeout());
            up.setPreUploadHook(PreUploadHookChain.newChain(Lists.newArrayList(this.preUploadHooks)));
            up.setPostUploadHook(PostUploadHookChain.newChain(Lists.newArrayList(this.postUploadHooks)));
            return up;
        }
    }

    static class Resolver
    implements RepositoryResolver<HttpServletRequest> {
        private final GitRepositoryManager manager;
        private final ProjectControl.Factory projectControlFactory;

        @Inject
        Resolver(GitRepositoryManager manager, ProjectControl.Factory projectControlFactory) {
            this.manager = manager;
            this.projectControlFactory = projectControlFactory;
        }

        @Override
        public Repository open(HttpServletRequest req, String projectName) throws RepositoryNotFoundException, ServiceNotAuthorizedException, ServiceNotEnabledException {
            ProjectControl pc;
            while (projectName.endsWith("/")) {
                projectName = projectName.substring(0, projectName.length() - 1);
            }
            if (projectName.endsWith(".git")) {
                projectName = projectName.substring(0, projectName.length() - 4);
                while (projectName.endsWith("/")) {
                    projectName = projectName.substring(0, projectName.length() - 1);
                }
            }
            try {
                pc = this.projectControlFactory.controlFor(new Project.NameKey(projectName));
            }
            catch (NoSuchProjectException err) {
                throw new RepositoryNotFoundException(projectName);
            }
            CurrentUser user = pc.getUser();
            user.setAccessPath(AccessPath.GIT);
            if (!pc.isVisible()) {
                if (user instanceof AnonymousUser) {
                    throw new ServiceNotAuthorizedException();
                }
                throw new ServiceNotEnabledException();
            }
            req.setAttribute(ATT_CONTROL, pc);
            try {
                return this.manager.openRepository(pc.getProject().getNameKey());
            }
            catch (IOException e) {
                throw new RepositoryNotFoundException(pc.getProject().getNameKey().get(), (Throwable)e);
            }
        }
    }

    static class Module
    extends AbstractModule {
        private final boolean enableReceive;

        Module(boolean enableReceive) {
            this.enableReceive = enableReceive;
        }

        @Override
        protected void configure() {
            this.bind(Resolver.class);
            this.bind(UploadFactory.class);
            this.bind(UploadFilter.class);
            this.bind(new TypeLiteral<ReceivePackFactory<HttpServletRequest>>(){}).to(this.enableReceive ? ReceiveFactory.class : DisabledReceiveFactory.class);
            this.bind(ReceiveFilter.class);
            this.install(new CacheModule(){

                @Override
                protected void configure() {
                    this.cache(GitOverHttpServlet.ID_CACHE, AdvertisedObjectsCacheKey.class, new TypeLiteral<Set<ObjectId>>(){}).maximumWeight(4096L).expireAfterWrite(10L, TimeUnit.MINUTES);
                }
            });
        }
    }
}

