/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.httpd.plugins;

import com.google.gerrit.extensions.api.lfs.LfsDefinitions;
import com.google.gerrit.httpd.plugins.HttpAutoRegisterModuleGenerator;
import com.google.gerrit.httpd.plugins.HttpPluginServlet;
import com.google.gerrit.httpd.plugins.LfsPluginServlet;
import com.google.gerrit.httpd.resources.Resource;
import com.google.gerrit.httpd.resources.ResourceKey;
import com.google.gerrit.httpd.resources.ResourceWeigher;
import com.google.gerrit.server.cache.CacheModule;
import com.google.gerrit.server.plugins.ModuleGenerator;
import com.google.gerrit.server.plugins.ReloadPluginListener;
import com.google.gerrit.server.plugins.StartPluginListener;
import com.google.inject.internal.UniqueAnnotations;
import com.google.inject.servlet.ServletModule;

public class HttpPluginModule
extends ServletModule {
    static final String PLUGIN_RESOURCES = "plugin_resources";

    @Override
    protected void configureServlets() {
        this.bind(HttpPluginServlet.class);
        this.serveRegex("^/(?:a/)?plugins/(.*)?$", new String[0]).with(HttpPluginServlet.class);
        this.bind(LfsPluginServlet.class);
        this.serveRegex(LfsDefinitions.LFS_URL_REGEX, new String[0]).with(LfsPluginServlet.class);
        this.bind(StartPluginListener.class).annotatedWith(UniqueAnnotations.create()).to(HttpPluginServlet.class);
        this.bind(ReloadPluginListener.class).annotatedWith(UniqueAnnotations.create()).to(HttpPluginServlet.class);
        this.bind(StartPluginListener.class).annotatedWith(UniqueAnnotations.create()).to(LfsPluginServlet.class);
        this.bind(ReloadPluginListener.class).annotatedWith(UniqueAnnotations.create()).to(LfsPluginServlet.class);
        this.bind(ModuleGenerator.class).to(HttpAutoRegisterModuleGenerator.class);
        this.install(new CacheModule(){

            @Override
            protected void configure() {
                this.cache(HttpPluginModule.PLUGIN_RESOURCES, ResourceKey.class, Resource.class).maximumWeight(0x200000L).weigher(ResourceWeigher.class);
            }
        });
    }
}

