/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.httpd.raw;

import com.google.common.base.Strings;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import com.google.common.primitives.Bytes;
import com.google.gerrit.common.FileUtil;
import com.google.gerrit.common.Version;
import com.google.gerrit.common.data.HostPageData;
import com.google.gerrit.extensions.client.DiffPreferencesInfo;
import com.google.gerrit.extensions.registration.DynamicSet;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.systemstatus.MessageOfTheDay;
import com.google.gerrit.extensions.webui.WebUiPlugin;
import com.google.gerrit.httpd.HtmlDomUtil;
import com.google.gerrit.httpd.raw.ResourceServlet;
import com.google.gerrit.httpd.raw.SiteStaticDirectoryServlet;
import com.google.gerrit.httpd.raw.ThemeFactory;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.account.AccountResource;
import com.google.gerrit.server.account.GetDiffPreferences;
import com.google.gerrit.server.config.ConfigUtil;
import com.google.gerrit.server.config.GerritServerConfig;
import com.google.gerrit.server.config.SitePaths;
import com.google.gerrit.server.notedb.NotesMigration;
import com.google.gwtexpui.server.CacheHeaders;
import com.google.gwtjsonrpc.server.JsonServlet;
import com.google.gwtjsonrpc.server.RPCServletUtils;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.lib.Config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Singleton
public class HostPageServlet
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(HostPageServlet.class);
    private static final String HPD_ID = "gerrit_hostpagedata";
    private static final int DEFAULT_JS_LOAD_TIMEOUT = 5000;
    private final Provider<CurrentUser> currentUser;
    private final DynamicSet<WebUiPlugin> plugins;
    private final DynamicSet<MessageOfTheDay> messages;
    private final HostPageData.Theme signedOutTheme;
    private final HostPageData.Theme signedInTheme;
    private final SitePaths site;
    private final Document template;
    private final String noCacheName;
    private final boolean refreshHeaderFooter;
    private final SiteStaticDirectoryServlet staticServlet;
    private final boolean isNoteDbEnabled;
    private final Integer pluginsLoadTimeout;
    private final boolean canLoadInIFrame;
    private final GetDiffPreferences getDiff;
    private volatile Page page;

    @Inject
    HostPageServlet(Provider<CurrentUser> cu, SitePaths sp, ThemeFactory themeFactory, ServletContext servletContext, DynamicSet<WebUiPlugin> webUiPlugins, DynamicSet<MessageOfTheDay> motd, @GerritServerConfig Config cfg, SiteStaticDirectoryServlet ss, NotesMigration migration, GetDiffPreferences diffPref) throws IOException, ServletException {
        this.currentUser = cu;
        this.plugins = webUiPlugins;
        this.messages = motd;
        this.signedOutTheme = themeFactory.getSignedOutTheme();
        this.signedInTheme = themeFactory.getSignedInTheme();
        this.site = sp;
        this.refreshHeaderFooter = cfg.getBoolean("site", "refreshHeaderFooter", true);
        this.staticServlet = ss;
        this.isNoteDbEnabled = migration.readChanges();
        this.pluginsLoadTimeout = HostPageServlet.getPluginsLoadTimeout(cfg);
        this.canLoadInIFrame = cfg.getBoolean("gerrit", "canLoadInIFrame", false);
        this.getDiff = diffPref;
        String pageName = "HostPage.html";
        this.template = HtmlDomUtil.parseFile(this.getClass(), pageName);
        if (this.template == null) {
            throw new FileNotFoundException("No " + pageName + " in webapp");
        }
        if (HtmlDomUtil.find(this.template, "gerrit_module") == null) {
            throw new ServletException("No gerrit_module in " + pageName);
        }
        if (HtmlDomUtil.find(this.template, HPD_ID) == null) {
            throw new ServletException("No gerrit_hostpagedata in " + pageName);
        }
        String src = "gerrit_ui/gerrit_ui.nocache.js";
        try (InputStream in = servletContext.getResourceAsStream("/" + src);){
            if (in != null) {
                int n;
                Hasher md = Hashing.md5().newHasher();
                byte[] buf = new byte[1024];
                while ((n = in.read(buf)) > 0) {
                    md.putBytes(buf, 0, n);
                }
                src = src + "?content=" + md.hash().toString();
            } else {
                log.debug("No " + src + " in webapp root; keeping noncache.js URL");
            }
        }
        catch (IOException e) {
            throw new IOException("Failed reading " + src, e);
        }
        this.noCacheName = src;
        this.page = new Page();
    }

    private static int getPluginsLoadTimeout(Config cfg) {
        long cfgValue = ConfigUtil.getTimeUnit(cfg, "plugins", null, "jsLoadTimeout", 5000L, TimeUnit.MILLISECONDS);
        if (cfgValue < 0L) {
            return 0;
        }
        return (int)cfgValue;
    }

    private void json(Object data, StringWriter w) {
        JsonServlet.defaultGsonBuilder().create().toJson(data, (Appendable)w);
    }

    private Page get() {
        Page p = this.page;
        try {
            if (this.refreshHeaderFooter && p.isStale()) {
                this.page = p = new Page();
            }
        }
        catch (IOException e) {
            log.error("Cannot refresh site header/footer", e);
        }
        return p;
    }

    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse rsp) throws IOException {
        byte[] tosend;
        Page.Content page = this.select(req);
        StringWriter w = new StringWriter();
        CurrentUser user = this.currentUser.get();
        if (user.isIdentifiedUser()) {
            w.write("gerrit_hostpagedata.accountDiffPref=");
            this.json(this.getDiffPreferences(user.asIdentifiedUser()), w);
            w.write(";");
            w.write("gerrit_hostpagedata.theme=");
            this.json(this.signedInTheme, w);
            w.write(";");
        } else {
            w.write("gerrit_hostpagedata.theme=");
            this.json(this.signedOutTheme, w);
            w.write(";");
        }
        this.plugins(w);
        this.messages(w);
        byte[] hpd = w.toString().getBytes(StandardCharsets.UTF_8);
        byte[] raw = Bytes.concat(page.part1, hpd, page.part2);
        if (RPCServletUtils.acceptsGzipEncoding(req)) {
            rsp.setHeader("Content-Encoding", "gzip");
            tosend = HtmlDomUtil.compress(raw);
        } else {
            tosend = raw;
        }
        CacheHeaders.setNotCacheable(rsp);
        rsp.setContentType("text/html");
        rsp.setCharacterEncoding(HtmlDomUtil.ENC.name());
        rsp.setContentLength(tosend.length);
        try (ServletOutputStream out = rsp.getOutputStream();){
            out.write(tosend);
        }
    }

    private DiffPreferencesInfo getDiffPreferences(IdentifiedUser user) {
        try {
            return this.getDiff.apply(new AccountResource(user));
        }
        catch (AuthException | IOException | ConfigInvalidException e) {
            log.warn("Cannot query account diff preferences", e);
            return DiffPreferencesInfo.defaults();
        }
    }

    private void plugins(StringWriter w) {
        ArrayList<String> urls = new ArrayList<String>();
        for (WebUiPlugin u : this.plugins) {
            urls.add(String.format("plugins/%s/%s", u.getPluginName(), u.getJavaScriptResourcePath()));
        }
        if (!urls.isEmpty()) {
            w.write("gerrit_hostpagedata.plugins=");
            this.json(urls, w);
            w.write(";");
        }
    }

    private void messages(StringWriter w) {
        ArrayList<HostPageData.Message> list = new ArrayList<HostPageData.Message>(2);
        for (MessageOfTheDay motd : this.messages) {
            String html = motd.getHtmlMessage();
            if (Strings.isNullOrEmpty(html)) continue;
            HostPageData.Message m = new HostPageData.Message();
            m.id = motd.getMessageId();
            m.redisplay = motd.getRedisplay();
            m.html = html;
            list.add(m);
        }
        if (!list.isEmpty()) {
            w.write("gerrit_hostpagedata.messages=");
            this.json(list, w);
            w.write(";");
        }
    }

    private Page.Content select(HttpServletRequest req) {
        Page pg = this.get();
        if ("1".equals(req.getParameter("dbg"))) {
            return pg.debug;
        }
        return pg.opt;
    }

    private void insertETags(Element e) {
        String name;
        ResourceServlet.Resource r;
        String src;
        if (("img".equalsIgnoreCase(e.getTagName()) || "script".equalsIgnoreCase(e.getTagName())) && (src = e.getAttribute("src")) != null && src.startsWith("static/") && (r = this.staticServlet.getResource(name = src.substring("static/".length()))) != null) {
            e.setAttribute("src", src + "?e=" + r.etag);
        }
        for (Node n = e.getFirstChild(); n != null; n = n.getNextSibling()) {
            if (!(n instanceof Element)) continue;
            this.insertETags((Element)n);
        }
    }

    private class Page {
        private final FileInfo css;
        private final FileInfo header;
        private final FileInfo footer;
        private final Content opt;
        private final Content debug;

        Page() throws IOException {
            Document hostDoc = HtmlDomUtil.clone(HostPageServlet.this.template);
            this.css = this.injectCssFile(hostDoc, "gerrit_sitecss", ((HostPageServlet)HostPageServlet.this).site.site_css);
            this.header = this.injectXmlFile(hostDoc, "gerrit_header", ((HostPageServlet)HostPageServlet.this).site.site_header);
            this.footer = this.injectXmlFile(hostDoc, "gerrit_footer", ((HostPageServlet)HostPageServlet.this).site.site_footer);
            HostPageData pageData = new HostPageData();
            pageData.version = Version.getVersion();
            pageData.isNoteDbEnabled = HostPageServlet.this.isNoteDbEnabled;
            pageData.pluginsLoadTimeout = HostPageServlet.this.pluginsLoadTimeout;
            pageData.canLoadInIFrame = HostPageServlet.this.canLoadInIFrame;
            StringWriter w = new StringWriter();
            w.write("var gerrit_hostpagedata=");
            HostPageServlet.this.json(pageData, w);
            w.write(";");
            Element data = HtmlDomUtil.find(hostDoc, HostPageServlet.HPD_ID);
            this.asScript(data);
            data.appendChild(hostDoc.createTextNode(w.toString()));
            data.appendChild(hostDoc.createComment(HostPageServlet.HPD_ID));
            Element nocache = HtmlDomUtil.find(hostDoc, "gerrit_module");
            this.asScript(nocache);
            nocache.removeAttribute("id");
            nocache.setAttribute("src", HostPageServlet.this.noCacheName);
            this.opt = new Content(hostDoc);
            nocache.setAttribute("src", "gerrit_ui/dbg_gerrit_ui.nocache.js");
            this.debug = new Content(hostDoc);
        }

        boolean isStale() {
            return this.css.isStale() || this.header.isStale() || this.footer.isStale();
        }

        private void asScript(Element scriptNode) {
            scriptNode.setAttribute("type", "text/javascript");
            scriptNode.setAttribute("language", "javascript");
        }

        private FileInfo injectCssFile(Document hostDoc, String id, Path src) throws IOException {
            FileInfo info = new FileInfo(src);
            Element banner = HtmlDomUtil.find(hostDoc, id);
            if (banner == null) {
                return info;
            }
            while (banner.getFirstChild() != null) {
                banner.removeChild(banner.getFirstChild());
            }
            String css = HtmlDomUtil.readFile(src.getParent(), src.getFileName().toString());
            if (css == null) {
                return info;
            }
            banner.appendChild(hostDoc.createCDATASection("\n" + css + "\n"));
            return info;
        }

        private FileInfo injectXmlFile(Document hostDoc, String id, Path src) throws IOException {
            FileInfo info = new FileInfo(src);
            Element banner = HtmlDomUtil.find(hostDoc, id);
            if (banner == null) {
                return info;
            }
            while (banner.getFirstChild() != null) {
                banner.removeChild(banner.getFirstChild());
            }
            Document html = HtmlDomUtil.parseFile(src);
            if (html == null) {
                return info;
            }
            Element content = html.getDocumentElement();
            HostPageServlet.this.insertETags(content);
            banner.appendChild(hostDoc.importNode(content, true));
            return info;
        }

        class Content {
            final byte[] part1;
            final byte[] part2;

            Content(Document hostDoc) throws IOException {
                String raw = HtmlDomUtil.toString(hostDoc);
                int p = raw.indexOf("<!--gerrit_hostpagedata");
                if (p < 0) {
                    throw new IOException("No tag in transformed host page HTML");
                }
                this.part1 = raw.substring(0, p).getBytes(StandardCharsets.UTF_8);
                this.part2 = raw.substring(raw.indexOf(62, p) + 1).getBytes(StandardCharsets.UTF_8);
            }
        }
    }

    private static class FileInfo {
        private final Path path;
        private final long time;

        FileInfo(Path p) {
            this.path = p;
            this.time = FileUtil.lastModified(this.path);
        }

        boolean isStale() {
            return this.time != FileUtil.lastModified(this.path);
        }
    }
}

