/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.metrics;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Preconditions;

public class Field<T> {
    private final String name;
    private final Class<T> keyType;
    private final Function<T, String> formatter;
    private final String description;

    public static Field<Boolean> ofBoolean(String name) {
        return Field.ofBoolean(name, null);
    }

    public static Field<Boolean> ofBoolean(String name, String description) {
        return new Field<Boolean>(name, Boolean.class, description);
    }

    public static <E extends Enum<E>> Field<E> ofEnum(Class<E> enumType, String name) {
        return Field.ofEnum(enumType, name, null);
    }

    public static <E extends Enum<E>> Field<E> ofEnum(Class<E> enumType, String name, String description) {
        return new Field<E>(name, enumType, description);
    }

    public static Field<String> ofString(String name) {
        return Field.ofString(name, null);
    }

    public static Field<String> ofString(String name, String description) {
        return new Field<String>(name, String.class, description);
    }

    public static Field<Integer> ofInteger(String name) {
        return Field.ofInteger(name, null);
    }

    public static Field<Integer> ofInteger(String name, String description) {
        return new Field<Integer>(name, Integer.class, description);
    }

    private Field(String name, Class<T> keyType, String description) {
        Preconditions.checkArgument(name.matches("^[a-z_]+$"), "name must match [a-z_]");
        this.name = name;
        this.keyType = keyType;
        this.formatter = Field.initFormatter(keyType);
        this.description = description;
    }

    public String getName() {
        return this.name;
    }

    public Class<T> getType() {
        return this.keyType;
    }

    public String getDescription() {
        return this.description;
    }

    public Function<T, String> formatter() {
        return this.formatter;
    }

    private static <T> Function<T, String> initFormatter(Class<T> keyType) {
        if (keyType == String.class) {
            return Functions.identity();
        }
        if (keyType == Integer.class || keyType == Boolean.class) {
            return Functions.toStringFunction();
        }
        if (Enum.class.isAssignableFrom(keyType)) {
            return in -> ((Enum)in).name();
        }
        throw new IllegalStateException("unsupported type " + keyType.getName());
    }
}

