/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.reviewdb.client;

import com.google.gerrit.extensions.client.Comment;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.CommentRange;
import com.google.gerrit.reviewdb.client.RevId;
import java.sql.Timestamp;
import java.util.Objects;

public class Comment {
    public Key key;
    public int lineNbr;
    public Identity author;
    protected Identity realAuthor;
    public Timestamp writtenOn;
    public short side;
    public String message;
    public String parentUuid;
    public Range range;
    public String tag;
    public String revId;
    public String serverId;
    public boolean unresolved;

    public Comment(Comment c) {
        this(new Key(c.key), c.author.getId(), new Timestamp(c.writtenOn.getTime()), c.side, c.message, c.serverId, c.unresolved);
        this.lineNbr = c.lineNbr;
        this.realAuthor = c.realAuthor;
        this.range = c.range != null ? new Range(c.range) : null;
        this.tag = c.tag;
        this.revId = c.revId;
        this.unresolved = c.unresolved;
    }

    public Comment(Key key, Account.Id author, Timestamp writtenOn, short side, String message, String serverId, boolean unresolved) {
        this.key = key;
        this.realAuthor = this.author = new Identity(author);
        this.writtenOn = writtenOn;
        this.side = side;
        this.message = message;
        this.serverId = serverId;
        this.unresolved = unresolved;
    }

    public void setLineNbrAndRange(Integer lineNbr, Comment.Range range) {
        int n = lineNbr != null ? lineNbr : (this.lineNbr = range != null ? range.endLine : 0);
        if (range != null) {
            this.range = new Range(range);
        }
    }

    public void setRange(CommentRange range) {
        this.range = range != null ? range.asCommentRange() : null;
    }

    public void setRevId(RevId revId) {
        this.revId = revId != null ? revId.get() : null;
    }

    public void setRealAuthor(Account.Id id) {
        this.realAuthor = id != null && id.get() != this.author.id ? new Identity(id) : null;
    }

    public Identity getRealAuthor() {
        return this.realAuthor != null ? this.realAuthor : this.author;
    }

    public boolean equals(Object o) {
        if (o instanceof Comment) {
            return Objects.equals(this.key, ((Comment)o).key);
        }
        return false;
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public String toString() {
        return "Comment{" + "key=" + this.key + ',' + "lineNbr=" + this.lineNbr + ',' + "author=" + this.author.getId().get() + ',' + "realAuthor=" + (this.realAuthor != null ? Integer.valueOf(this.realAuthor.getId().get()) : "") + ',' + "writtenOn=" + this.writtenOn.toString() + ',' + "side=" + this.side + ',' + "message=" + Objects.toString(this.message, "") + ',' + "parentUuid=" + Objects.toString(this.parentUuid, "") + ',' + "range=" + Objects.toString(this.range, "") + ',' + "revId=" + (this.revId != null ? this.revId : "") + ',' + "tag=" + Objects.toString(this.tag, "") + ',' + "unresolved=" + this.unresolved + '}';
    }

    public static class Range {
        public int startLine;
        public int startChar;
        public int endLine;
        public int endChar;

        public Range(Range r) {
            this(r.startLine, r.startChar, r.endLine, r.endChar);
        }

        public Range(Comment.Range r) {
            this(r.startLine, r.startCharacter, r.endLine, r.endCharacter);
        }

        public Range(int startLine, int startChar, int endLine, int endChar) {
            this.startLine = startLine;
            this.startChar = startChar;
            this.endLine = endLine;
            this.endChar = endChar;
        }

        public boolean equals(Object o) {
            if (o instanceof Range) {
                Range r = (Range)o;
                return Objects.equals(this.startLine, r.startLine) && Objects.equals(this.startChar, r.startChar) && Objects.equals(this.endLine, r.endLine) && Objects.equals(this.endChar, r.endChar);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.startLine, this.startChar, this.endLine, this.endChar);
        }

        public String toString() {
            return "Comment.Range{" + "startLine=" + this.startLine + ',' + "startChar=" + this.startChar + ',' + "endLine=" + this.endLine + ',' + "endChar=" + this.endChar + '}';
        }
    }

    public static class Identity {
        int id;

        public Identity(Account.Id id) {
            this.id = id.get();
        }

        public Account.Id getId() {
            return new Account.Id(this.id);
        }

        public boolean equals(Object o) {
            if (o instanceof Identity) {
                return Objects.equals(this.id, ((Identity)o).id);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.id);
        }

        public String toString() {
            return "Comment.Identity{" + "id=" + this.id + '}';
        }
    }

    public static class Key {
        public String uuid;
        public String filename;
        public int patchSetId;

        public Key(Key k) {
            this(k.uuid, k.filename, k.patchSetId);
        }

        public Key(String uuid, String filename, int patchSetId) {
            this.uuid = uuid;
            this.filename = filename;
            this.patchSetId = patchSetId;
        }

        public String toString() {
            return "Comment.Key{" + "uuid=" + this.uuid + ',' + "filename=" + this.filename + ',' + "patchSetId=" + this.patchSetId + '}';
        }

        public boolean equals(Object o) {
            if (o instanceof Key) {
                Key k = (Key)o;
                return Objects.equals(this.uuid, k.uuid) && Objects.equals(this.filename, k.filename) && Objects.equals(this.patchSetId, k.patchSetId);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.uuid, this.filename, this.patchSetId);
        }
    }
}

