/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.gerrit.common.Nullable;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.ChangeMessage;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.ChangeUtil;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.notedb.ChangeNotes;
import com.google.gerrit.server.notedb.ChangeUpdate;
import com.google.gerrit.server.notedb.NotesMigration;
import com.google.gerrit.server.update.ChangeContext;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.sql.Timestamp;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@Singleton
public class ChangeMessagesUtil {
    public static final String TAG_ABANDON = "autogenerated:gerrit:abandon";
    public static final String TAG_CHERRY_PICK_CHANGE = "autogenerated:gerrit:cherryPickChange";
    public static final String TAG_DELETE_ASSIGNEE = "autogenerated:gerrit:deleteAssignee";
    public static final String TAG_DELETE_REVIEWER = "autogenerated:gerrit:deleteReviewer";
    public static final String TAG_DELETE_VOTE = "autogenerated:gerrit:deleteVote";
    public static final String TAG_MERGED = "autogenerated:gerrit:merged";
    public static final String TAG_MOVE = "autogenerated:gerrit:move";
    public static final String TAG_RESTORE = "autogenerated:gerrit:restore";
    public static final String TAG_REVERT = "autogenerated:gerrit:revert";
    public static final String TAG_SET_ASSIGNEE = "autogenerated:gerrit:setAssignee";
    public static final String TAG_SET_DESCRIPTION = "autogenerated:gerrit:setPsDescription";
    public static final String TAG_SET_HASHTAGS = "autogenerated:gerrit:setHashtag";
    public static final String TAG_SET_TOPIC = "autogenerated:gerrit:setTopic";
    public static final String TAG_UPLOADED_PATCH_SET = "autogenerated:gerrit:newPatchSet";
    private final NotesMigration migration;

    public static ChangeMessage newMessage(ChangeContext ctx, String body, @Nullable String tag) {
        return ChangeMessagesUtil.newMessage(ctx.getChange().currentPatchSetId(), ctx.getUser(), ctx.getWhen(), body, tag);
    }

    public static ChangeMessage newMessage(PatchSet.Id psId, CurrentUser user, Timestamp when, String body, @Nullable String tag) {
        Preconditions.checkNotNull(psId);
        Account.Id accountId = user.isInternalUser() ? null : user.getAccountId();
        ChangeMessage m = new ChangeMessage(new ChangeMessage.Key(psId.getParentKey(), ChangeUtil.messageUuid()), accountId, when, psId);
        m.setMessage(body);
        m.setTag(tag);
        user.updateRealAccountId(m::setRealAuthor);
        return m;
    }

    private static List<ChangeMessage> sortChangeMessages(Iterable<ChangeMessage> changeMessage) {
        return ChangeNotes.MESSAGE_BY_TIME.sortedCopy(changeMessage);
    }

    @Inject
    @VisibleForTesting
    public ChangeMessagesUtil(NotesMigration migration) {
        this.migration = migration;
    }

    public List<ChangeMessage> byChange(ReviewDb db, ChangeNotes notes) throws OrmException {
        if (!this.migration.readChanges()) {
            return ChangeMessagesUtil.sortChangeMessages(db.changeMessages().byChange(notes.getChangeId()));
        }
        return ((ChangeNotes)notes.load()).getChangeMessages();
    }

    public Iterable<ChangeMessage> byPatchSet(ReviewDb db, ChangeNotes notes, PatchSet.Id psId) throws OrmException {
        if (!this.migration.readChanges()) {
            return db.changeMessages().byPatchSet(psId);
        }
        return ((ChangeNotes)notes.load()).getChangeMessagesByPatchSet().get((Object)psId);
    }

    public void addChangeMessage(ReviewDb db, ChangeUpdate update, ChangeMessage changeMessage) throws OrmException {
        Preconditions.checkState(Objects.equals(changeMessage.getAuthor(), update.getNullableAccountId()), "cannot store change message by %s in update by %s", (Object)changeMessage.getAuthor(), (Object)update.getNullableAccountId());
        update.setChangeMessage(changeMessage.getMessage());
        update.setTag(changeMessage.getTag());
        db.changeMessages().insert(Collections.singleton(changeMessage));
    }
}

