/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.account;

import com.google.gerrit.common.data.PermissionRule;
import com.google.gerrit.common.errors.NoSuchGroupException;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.AccountGroup;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.account.AccountState;
import com.google.gerrit.server.account.AccountVisibility;
import com.google.gerrit.server.account.GroupControl;
import com.google.gerrit.server.git.AccountsSection;
import com.google.gerrit.server.group.SystemGroupBackend;
import com.google.gerrit.server.project.ProjectCache;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.Set;
import java.util.stream.Collectors;

public class AccountControl {
    private final AccountsSection accountsSection;
    private final GroupControl.Factory groupControlFactory;
    private final CurrentUser user;
    private final IdentifiedUser.GenericFactory userFactory;
    private final AccountVisibility accountVisibility;

    AccountControl(ProjectCache projectCache, GroupControl.Factory groupControlFactory, CurrentUser user, IdentifiedUser.GenericFactory userFactory, AccountVisibility accountVisibility) {
        this.accountsSection = projectCache.getAllProjects().getConfig().getAccountsSection();
        this.groupControlFactory = groupControlFactory;
        this.user = user;
        this.userFactory = userFactory;
        this.accountVisibility = accountVisibility;
    }

    public CurrentUser getUser() {
        return this.user;
    }

    public boolean canSee(Account otherUser) {
        return this.canSee(otherUser.getId());
    }

    public boolean canSee(final Account.Id otherUser) {
        return this.canSee(new OtherUser(){

            @Override
            Account.Id getId() {
                return otherUser;
            }

            @Override
            IdentifiedUser createUser() {
                return AccountControl.this.userFactory.create(otherUser);
            }
        });
    }

    public boolean canSee(final AccountState otherUser) {
        return this.canSee(new OtherUser(){

            @Override
            Account.Id getId() {
                return otherUser.getAccount().getId();
            }

            @Override
            IdentifiedUser createUser() {
                return AccountControl.this.userFactory.create(otherUser);
            }
        });
    }

    private boolean canSee(OtherUser otherUser) {
        if (this.user.isIdentifiedUser() && this.user.getAccountId().equals(otherUser.getId())) {
            return true;
        }
        if (this.user.getCapabilities().canViewAllAccounts()) {
            return true;
        }
        switch (this.accountVisibility) {
            case ALL: {
                return true;
            }
            case SAME_GROUP: {
                Set<AccountGroup.UUID> usersGroups = this.groupsOf(otherUser.getUser());
                for (PermissionRule rule : this.accountsSection.getSameGroupVisibility()) {
                    if (!rule.isBlock() && !rule.isDeny()) continue;
                    usersGroups.remove(rule.getGroup().getUUID());
                }
                if (!this.user.getEffectiveGroups().containsAnyOf(usersGroups)) break;
                return true;
            }
            case VISIBLE_GROUP: {
                Set<AccountGroup.UUID> usersGroups = this.groupsOf(otherUser.getUser());
                for (AccountGroup.UUID usersGroup : usersGroups) {
                    try {
                        if (!this.groupControlFactory.controlFor(usersGroup).isVisible()) continue;
                        return true;
                    }
                    catch (NoSuchGroupException e) {
                    }
                }
                break;
            }
            case NONE: {
                break;
            }
            default: {
                throw new IllegalStateException("Bad AccountVisibility " + (Object)((Object)this.accountVisibility));
            }
        }
        return false;
    }

    private Set<AccountGroup.UUID> groupsOf(IdentifiedUser user) {
        return user.getEffectiveGroups().getKnownGroups().stream().filter(a -> !SystemGroupBackend.isSystemGroup(a)).collect(Collectors.toSet());
    }

    private static abstract class OtherUser {
        IdentifiedUser user;

        private OtherUser() {
        }

        IdentifiedUser getUser() {
            if (this.user == null) {
                this.user = this.createUser();
            }
            return this.user;
        }

        abstract IdentifiedUser createUser();

        abstract Account.Id getId();
    }

    public static class Factory {
        private final ProjectCache projectCache;
        private final GroupControl.Factory groupControlFactory;
        private final Provider<CurrentUser> user;
        private final IdentifiedUser.GenericFactory userFactory;
        private final AccountVisibility accountVisibility;

        @Inject
        Factory(ProjectCache projectCache, GroupControl.Factory groupControlFactory, Provider<CurrentUser> user, IdentifiedUser.GenericFactory userFactory, AccountVisibility accountVisibility) {
            this.projectCache = projectCache;
            this.groupControlFactory = groupControlFactory;
            this.user = user;
            this.userFactory = userFactory;
            this.accountVisibility = accountVisibility;
        }

        public AccountControl get() {
            return new AccountControl(this.projectCache, this.groupControlFactory, this.user.get(), this.userFactory, this.accountVisibility);
        }
    }
}

