/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.account;

import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.Response;
import com.google.gerrit.extensions.restapi.RestModifyView;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.account.AccountResource;
import com.google.gerrit.server.account.VersionedAuthorizedKeys;
import com.google.gerrit.server.ssh.SshKeyCache;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.io.IOException;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.errors.RepositoryNotFoundException;

@Singleton
public class DeleteSshKey
implements RestModifyView<AccountResource.SshKey, Input> {
    private final Provider<CurrentUser> self;
    private final VersionedAuthorizedKeys.Accessor authorizedKeys;
    private final SshKeyCache sshKeyCache;

    @Inject
    DeleteSshKey(Provider<CurrentUser> self, VersionedAuthorizedKeys.Accessor authorizedKeys, SshKeyCache sshKeyCache) {
        this.self = self;
        this.authorizedKeys = authorizedKeys;
        this.sshKeyCache = sshKeyCache;
    }

    public Response<?> apply(AccountResource.SshKey rsrc, Input input) throws AuthException, OrmException, RepositoryNotFoundException, IOException, ConfigInvalidException {
        if (!this.self.get().hasSameAccountId(rsrc.getUser()) && !this.self.get().getCapabilities().canAdministrateServer()) {
            throw new AuthException("not allowed to delete SSH keys");
        }
        this.authorizedKeys.deleteKey(rsrc.getUser().getAccountId(), rsrc.getSshKey().getKey().get());
        this.sshKeyCache.evict(rsrc.getUser().getUserName());
        return Response.none();
    }

    public static class Input {
    }
}

