/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.change;

import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.gerrit.common.Nullable;
import com.google.gerrit.extensions.api.changes.ActionVisitor;
import com.google.gerrit.extensions.common.ActionInfo;
import com.google.gerrit.extensions.common.ChangeInfo;
import com.google.gerrit.extensions.common.RevisionInfo;
import com.google.gerrit.extensions.registration.DynamicMap;
import com.google.gerrit.extensions.registration.DynamicSet;
import com.google.gerrit.extensions.restapi.RestView;
import com.google.gerrit.extensions.webui.PrivateInternals_UiActionDescription;
import com.google.gerrit.extensions.webui.UiAction;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.change.ChangeJson;
import com.google.gerrit.server.change.ChangeResource;
import com.google.gerrit.server.change.RevisionResource;
import com.google.gerrit.server.change.Revisions;
import com.google.gerrit.server.extensions.webui.UiActions;
import com.google.gerrit.server.project.ChangeControl;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.util.Providers;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@Singleton
public class ActionJson {
    private final Revisions revisions;
    private final ChangeJson.Factory changeJsonFactory;
    private final ChangeResource.Factory changeResourceFactory;
    private final DynamicMap<RestView<ChangeResource>> changeViews;
    private final DynamicSet<ActionVisitor> visitorSet;

    @Inject
    ActionJson(Revisions revisions, ChangeJson.Factory changeJsonFactory, ChangeResource.Factory changeResourceFactory, DynamicMap<RestView<ChangeResource>> changeViews, DynamicSet<ActionVisitor> visitorSet) {
        this.revisions = revisions;
        this.changeJsonFactory = changeJsonFactory;
        this.changeResourceFactory = changeResourceFactory;
        this.changeViews = changeViews;
        this.visitorSet = visitorSet;
    }

    public Map<String, ActionInfo> format(RevisionResource rsrc) throws OrmException {
        ChangeInfo changeInfo = null;
        RevisionInfo revisionInfo = null;
        ArrayList<ActionVisitor> visitors = this.visitors();
        if (!visitors.isEmpty()) {
            changeInfo = this.changeJson().format(rsrc);
            revisionInfo = Preconditions.checkNotNull(Iterables.getOnlyElement(changeInfo.revisions.values()));
            changeInfo.revisions = null;
        }
        return this.toActionMap(rsrc, visitors, changeInfo, revisionInfo);
    }

    private ChangeJson changeJson() {
        return this.changeJsonFactory.noOptions();
    }

    private ArrayList<ActionVisitor> visitors() {
        return Lists.newArrayList(this.visitorSet);
    }

    public ChangeInfo addChangeActions(ChangeInfo to, ChangeControl ctl) {
        ArrayList<ActionVisitor> visitors = this.visitors();
        to.actions = this.toActionMap(ctl, visitors, this.copy(visitors, to));
        return to;
    }

    public RevisionInfo addRevisionActions(@Nullable ChangeInfo changeInfo, RevisionInfo to, RevisionResource rsrc) throws OrmException {
        ArrayList<ActionVisitor> visitors = this.visitors();
        if (!visitors.isEmpty()) {
            changeInfo = changeInfo != null ? this.copy(visitors, changeInfo) : this.changeJson().format(rsrc);
        }
        to.actions = this.toActionMap(rsrc, visitors, changeInfo, this.copy(visitors, to));
        return to;
    }

    private ChangeInfo copy(List<ActionVisitor> visitors, ChangeInfo changeInfo) {
        if (visitors.isEmpty()) {
            return null;
        }
        ChangeInfo copy = new ChangeInfo();
        copy.project = changeInfo.project;
        copy.branch = changeInfo.branch;
        copy.topic = changeInfo.topic;
        copy.assignee = changeInfo.assignee;
        copy.hashtags = changeInfo.hashtags;
        copy.changeId = changeInfo.changeId;
        copy.submitType = changeInfo.submitType;
        copy.mergeable = changeInfo.mergeable;
        copy.insertions = changeInfo.insertions;
        copy.deletions = changeInfo.deletions;
        copy.subject = changeInfo.subject;
        copy.status = changeInfo.status;
        copy.owner = changeInfo.owner;
        copy.created = changeInfo.created;
        copy.updated = changeInfo.updated;
        copy._number = changeInfo._number;
        copy.starred = changeInfo.starred;
        copy.stars = changeInfo.stars;
        copy.submitted = changeInfo.submitted;
        copy.id = changeInfo.id;
        return copy;
    }

    private RevisionInfo copy(List<ActionVisitor> visitors, RevisionInfo revisionInfo) {
        if (visitors.isEmpty()) {
            return null;
        }
        RevisionInfo copy = new RevisionInfo();
        copy.isCurrent = revisionInfo.isCurrent;
        copy._number = revisionInfo._number;
        copy.ref = revisionInfo.ref;
        copy.created = revisionInfo.created;
        copy.uploader = revisionInfo.uploader;
        copy.draft = revisionInfo.draft;
        copy.fetch = revisionInfo.fetch;
        copy.kind = revisionInfo.kind;
        copy.description = revisionInfo.description;
        return copy;
    }

    private Map<String, ActionInfo> toActionMap(ChangeControl ctl, List<ActionVisitor> visitors, ChangeInfo changeInfo) {
        LinkedHashMap<String, ActionInfo> out = new LinkedHashMap<String, ActionInfo>();
        if (!ctl.getUser().isIdentifiedUser()) {
            return out;
        }
        Provider<CurrentUser> userProvider = Providers.of(ctl.getUser());
        FluentIterable<UiAction.Description> descs = UiActions.from(this.changeViews, this.changeResourceFactory.create(ctl), userProvider);
        if (ctl.getChange().getStatus().isOpen()) {
            UiAction.Description descr = new UiAction.Description();
            PrivateInternals_UiActionDescription.setId(descr, "followup");
            PrivateInternals_UiActionDescription.setMethod(descr, "POST");
            descr.setTitle("Create follow-up change");
            descr.setLabel("Follow-Up");
            descs = descs.append((UiAction.Description[])new UiAction.Description[]{descr});
        }
        block0: for (UiAction.Description d : descs) {
            ActionInfo actionInfo = new ActionInfo(d);
            for (ActionVisitor visitor : visitors) {
                if (visitor.visit(d.getId(), actionInfo, changeInfo)) continue;
                continue block0;
            }
            out.put(d.getId(), actionInfo);
        }
        return out;
    }

    private Map<String, ActionInfo> toActionMap(RevisionResource rsrc, List<ActionVisitor> visitors, ChangeInfo changeInfo, RevisionInfo revisionInfo) {
        if (!rsrc.getControl().getUser().isIdentifiedUser()) {
            return ImmutableMap.of();
        }
        LinkedHashMap<String, ActionInfo> out = new LinkedHashMap<String, ActionInfo>();
        Provider<CurrentUser> userProvider = Providers.of(rsrc.getControl().getUser());
        block0: for (UiAction.Description d : UiActions.from(this.revisions, rsrc, userProvider)) {
            ActionInfo actionInfo = new ActionInfo(d);
            for (ActionVisitor visitor : visitors) {
                if (visitor.visit(d.getId(), actionInfo, changeInfo, revisionInfo)) continue;
                continue block0;
            }
            out.put(d.getId(), actionInfo);
        }
        return out;
    }
}

