/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.change;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.eclipse.jgit.api.ArchiveCommand;
import org.eclipse.jgit.archive.TarFormat;
import org.eclipse.jgit.archive.Tbz2Format;
import org.eclipse.jgit.archive.TgzFormat;
import org.eclipse.jgit.archive.TxzFormat;
import org.eclipse.jgit.archive.ZipFormat;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.ObjectLoader;

public enum ArchiveFormat {
    TGZ("application/x-gzip", new TgzFormat()),
    TAR("application/x-tar", new TarFormat()),
    TBZ2("application/x-bzip2", new Tbz2Format()),
    TXZ("application/x-xz", new TxzFormat()),
    ZIP("application/x-zip", new ZipFormat());

    private final ArchiveCommand.Format<?> format;
    private final String mimeType;

    private ArchiveFormat(String mimeType, ArchiveCommand.Format<?> format) {
        this.format = format;
        this.mimeType = mimeType;
        ArchiveCommand.registerFormat(this.name(), format);
    }

    public String getShortName() {
        return this.name().toLowerCase();
    }

    String getMimeType() {
        return this.mimeType;
    }

    String getDefaultSuffix() {
        return this.getSuffixes().iterator().next();
    }

    Iterable<String> getSuffixes() {
        return this.format.suffixes();
    }

    public ArchiveOutputStream createArchiveOutputStream(OutputStream o) throws IOException {
        return (ArchiveOutputStream)this.format.createArchiveOutputStream(o);
    }

    public <T extends Closeable> void putEntry(T out, String path, byte[] data) throws IOException {
        ArchiveCommand.Format<?> fmt = this.format;
        fmt.putEntry(out, null, path, FileMode.REGULAR_FILE, new ObjectLoader.SmallObject(32768, data));
    }
}

