/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.change;

import com.google.gerrit.common.TimeUtil;
import com.google.gerrit.extensions.restapi.Response;
import com.google.gerrit.extensions.restapi.RestApiException;
import com.google.gerrit.extensions.restapi.RestModifyView;
import com.google.gerrit.extensions.webui.UiAction;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.change.ChangeResource;
import com.google.gerrit.server.change.DeleteChangeOp;
import com.google.gerrit.server.config.GerritServerConfig;
import com.google.gerrit.server.project.ChangeControl;
import com.google.gerrit.server.update.BatchUpdate;
import com.google.gerrit.server.update.Order;
import com.google.gerrit.server.update.UpdateException;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import org.eclipse.jgit.lib.Config;

@Singleton
public class DeleteChange
implements RestModifyView<ChangeResource, Input>,
UiAction<ChangeResource> {
    private final Provider<ReviewDb> db;
    private final BatchUpdate.Factory updateFactory;
    private final Provider<DeleteChangeOp> opProvider;
    private final boolean allowDrafts;

    @Inject
    public DeleteChange(Provider<ReviewDb> db, BatchUpdate.Factory updateFactory, Provider<DeleteChangeOp> opProvider, @GerritServerConfig Config cfg) {
        this.db = db;
        this.updateFactory = updateFactory;
        this.opProvider = opProvider;
        this.allowDrafts = DeleteChangeOp.allowDrafts(cfg);
    }

    public Response<?> apply(ChangeResource rsrc, Input input) throws RestApiException, UpdateException {
        try (BatchUpdate bu = this.updateFactory.create(this.db.get(), rsrc.getProject(), rsrc.getUser(), TimeUtil.nowTs());){
            Change.Id id = rsrc.getChange().getId();
            bu.setOrder(Order.DB_BEFORE_REPO);
            bu.addOp(id, this.opProvider.get());
            bu.execute();
        }
        return Response.none();
    }

    @Override
    public UiAction.Description getDescription(ChangeResource rsrc) {
        try {
            Change.Status status = rsrc.getChange().getStatus();
            ChangeControl changeControl = rsrc.getControl();
            boolean visible = this.isActionAllowed(changeControl, status) && changeControl.canDelete(this.db.get(), status);
            return new UiAction.Description().setLabel("Delete").setTitle("Delete change " + rsrc.getId()).setVisible(visible);
        }
        catch (OrmException e) {
            throw new IllegalStateException(e);
        }
    }

    private boolean isActionAllowed(ChangeControl changeControl, Change.Status status) {
        return status != Change.Status.DRAFT || this.allowDrafts || changeControl.isAdmin();
    }

    public static class Input {
    }
}

