/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.change;

import com.google.common.collect.ListMultimap;
import com.google.gerrit.common.Nullable;
import com.google.gerrit.extensions.api.changes.NotifyHandling;
import com.google.gerrit.extensions.api.changes.RecipientType;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.ChangeMessage;
import com.google.gerrit.reviewdb.client.Comment;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.CommentsUtil;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.git.SendEmailExecutor;
import com.google.gerrit.server.mail.send.CommentSender;
import com.google.gerrit.server.notedb.ChangeNotes;
import com.google.gerrit.server.patch.PatchSetInfoFactory;
import com.google.gerrit.server.util.LabelVote;
import com.google.gerrit.server.util.RequestContext;
import com.google.gerrit.server.util.ThreadLocalRequestContext;
import com.google.gwtorm.server.OrmException;
import com.google.gwtorm.server.SchemaFactory;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.ProvisionException;
import com.google.inject.assistedinject.Assisted;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmailReviewComments
implements Runnable,
RequestContext {
    private static final Logger log = LoggerFactory.getLogger(EmailReviewComments.class);
    private final ExecutorService sendEmailsExecutor;
    private final PatchSetInfoFactory patchSetInfoFactory;
    private final CommentSender.Factory commentSenderFactory;
    private final SchemaFactory<ReviewDb> schemaFactory;
    private final ThreadLocalRequestContext requestContext;
    private final NotifyHandling notify;
    private final ListMultimap<RecipientType, Account.Id> accountsToNotify;
    private final ChangeNotes notes;
    private final PatchSet patchSet;
    private final IdentifiedUser user;
    private final ChangeMessage message;
    private final List<Comment> comments;
    private final String patchSetComment;
    private final List<LabelVote> labels;
    private ReviewDb db;

    @Inject
    EmailReviewComments(@SendEmailExecutor ExecutorService executor, PatchSetInfoFactory patchSetInfoFactory, CommentSender.Factory commentSenderFactory, SchemaFactory<ReviewDb> schemaFactory, ThreadLocalRequestContext requestContext, @Assisted NotifyHandling notify, @Assisted ListMultimap<RecipientType, Account.Id> accountsToNotify, @Assisted ChangeNotes notes, @Assisted PatchSet patchSet, @Assisted IdentifiedUser user, @Assisted ChangeMessage message, @Assisted List<Comment> comments, @Nullable @Assisted String patchSetComment, @Assisted List<LabelVote> labels) {
        this.sendEmailsExecutor = executor;
        this.patchSetInfoFactory = patchSetInfoFactory;
        this.commentSenderFactory = commentSenderFactory;
        this.schemaFactory = schemaFactory;
        this.requestContext = requestContext;
        this.notify = notify;
        this.accountsToNotify = accountsToNotify;
        this.notes = notes;
        this.patchSet = patchSet;
        this.user = user;
        this.message = message;
        this.comments = CommentsUtil.COMMENT_ORDER.sortedCopy(comments);
        this.patchSetComment = patchSetComment;
        this.labels = labels;
    }

    public void sendAsync() {
        Future<?> possiblyIgnoredError = this.sendEmailsExecutor.submit(this);
    }

    @Override
    public void run() {
        RequestContext old = this.requestContext.setContext(this);
        try {
            CommentSender cm = this.commentSenderFactory.create(this.notes.getProjectName(), this.notes.getChangeId());
            cm.setFrom(this.user.getAccountId());
            cm.setPatchSet(this.patchSet, this.patchSetInfoFactory.get(this.notes.getProjectName(), this.patchSet));
            cm.setChangeMessage(this.message.getMessage(), this.message.getWrittenOn());
            cm.setComments(this.comments);
            cm.setPatchSetComment(this.patchSetComment);
            cm.setLabels(this.labels);
            cm.setNotify(this.notify);
            cm.setAccountsToNotify(this.accountsToNotify);
            cm.send();
        }
        catch (Exception e) {
            log.error("Cannot email comments for " + this.patchSet.getId(), e);
        }
        finally {
            this.requestContext.setContext(old);
            if (this.db != null) {
                this.db.close();
                this.db = null;
            }
        }
    }

    public String toString() {
        return "send-email comments";
    }

    @Override
    public CurrentUser getUser() {
        return this.user.getRealUser();
    }

    @Override
    public Provider<ReviewDb> getReviewDbProvider() {
        return new Provider<ReviewDb>(){

            @Override
            public ReviewDb get() {
                if (EmailReviewComments.this.db == null) {
                    try {
                        EmailReviewComments.this.db = (ReviewDb)EmailReviewComments.this.schemaFactory.open();
                    }
                    catch (OrmException e) {
                        throw new ProvisionException("Cannot open ReviewDb", e);
                    }
                }
                return EmailReviewComments.this.db;
            }
        };
    }

    public static interface Factory {
        public EmailReviewComments create(NotifyHandling var1, ListMultimap<RecipientType, Account.Id> var2, ChangeNotes var3, PatchSet var4, IdentifiedUser var5, ChangeMessage var6, List<Comment> var7, String var8, List<LabelVote> var9);
    }
}

