/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.change;

import com.google.gerrit.extensions.common.RobotCommentInfo;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.RestReadView;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.CommentsUtil;
import com.google.gerrit.server.change.ChangeResource;
import com.google.gerrit.server.change.CommentJson;
import com.google.gerrit.server.query.change.ChangeData;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.List;
import java.util.Map;

public class ListChangeRobotComments
implements RestReadView<ChangeResource> {
    private final Provider<ReviewDb> db;
    private final ChangeData.Factory changeDataFactory;
    private final Provider<CommentJson> commentJson;
    private final CommentsUtil commentsUtil;

    @Inject
    ListChangeRobotComments(Provider<ReviewDb> db, ChangeData.Factory changeDataFactory, Provider<CommentJson> commentJson, CommentsUtil commentsUtil) {
        this.db = db;
        this.changeDataFactory = changeDataFactory;
        this.commentJson = commentJson;
        this.commentsUtil = commentsUtil;
    }

    public Map<String, List<RobotCommentInfo>> apply(ChangeResource rsrc) throws AuthException, OrmException {
        ChangeData cd = this.changeDataFactory.create(this.db.get(), rsrc.getControl());
        return this.commentJson.get().setFillAccounts(true).setFillPatchSet(true).newRobotCommentFormatter().format(this.commentsUtil.robotCommentsByChange(cd.notes()));
    }
}

