/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.change;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.gerrit.common.TimeUtil;
import com.google.gerrit.common.data.GroupDescription;
import com.google.gerrit.common.errors.NoSuchGroupException;
import com.google.gerrit.extensions.api.changes.AddReviewerInput;
import com.google.gerrit.extensions.api.changes.AddReviewerResult;
import com.google.gerrit.extensions.api.changes.NotifyHandling;
import com.google.gerrit.extensions.api.changes.RecipientType;
import com.google.gerrit.extensions.api.changes.ReviewerInfo;
import com.google.gerrit.extensions.client.ReviewerState;
import com.google.gerrit.extensions.restapi.BadRequestException;
import com.google.gerrit.extensions.restapi.RestApiException;
import com.google.gerrit.extensions.restapi.RestModifyView;
import com.google.gerrit.extensions.restapi.UnprocessableEntityException;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.AccountGroup;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.reviewdb.client.PatchSetApproval;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.ApprovalsUtil;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.PatchSetUtil;
import com.google.gerrit.server.account.AccountCache;
import com.google.gerrit.server.account.AccountLoader;
import com.google.gerrit.server.account.AccountsCollection;
import com.google.gerrit.server.account.GroupMembers;
import com.google.gerrit.server.change.ChangeMessages;
import com.google.gerrit.server.change.ChangeResource;
import com.google.gerrit.server.change.NotifyUtil;
import com.google.gerrit.server.change.ReviewerJson;
import com.google.gerrit.server.change.ReviewerResource;
import com.google.gerrit.server.change.RevisionResource;
import com.google.gerrit.server.config.GerritServerConfig;
import com.google.gerrit.server.extensions.events.ReviewerAdded;
import com.google.gerrit.server.group.GroupsCollection;
import com.google.gerrit.server.group.SystemGroupBackend;
import com.google.gerrit.server.mail.send.AddReviewerSender;
import com.google.gerrit.server.notedb.NotesMigration;
import com.google.gerrit.server.project.ChangeControl;
import com.google.gerrit.server.project.NoSuchProjectException;
import com.google.gerrit.server.update.BatchUpdate;
import com.google.gerrit.server.update.BatchUpdateOp;
import com.google.gerrit.server.update.ChangeContext;
import com.google.gerrit.server.update.Context;
import com.google.gerrit.server.update.UpdateException;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jgit.lib.Config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class PostReviewers
implements RestModifyView<ChangeResource, AddReviewerInput> {
    private static final Logger log = LoggerFactory.getLogger(PostReviewers.class);
    public static final int DEFAULT_MAX_REVIEWERS_WITHOUT_CHECK = 10;
    public static final int DEFAULT_MAX_REVIEWERS = 20;
    private final AccountsCollection accounts;
    private final ReviewerResource.Factory reviewerFactory;
    private final ApprovalsUtil approvalsUtil;
    private final PatchSetUtil psUtil;
    private final AddReviewerSender.Factory addReviewerSenderFactory;
    private final GroupsCollection groupsCollection;
    private final GroupMembers.Factory groupMembersFactory;
    private final AccountLoader.Factory accountLoaderFactory;
    private final Provider<ReviewDb> dbProvider;
    private final BatchUpdate.Factory batchUpdateFactory;
    private final Provider<IdentifiedUser> user;
    private final IdentifiedUser.GenericFactory identifiedUserFactory;
    private final Config cfg;
    private final ReviewerJson json;
    private final ReviewerAdded reviewerAdded;
    private final NotesMigration migration;
    private final AccountCache accountCache;
    private final NotifyUtil notifyUtil;

    @Inject
    PostReviewers(AccountsCollection accounts, ReviewerResource.Factory reviewerFactory, ApprovalsUtil approvalsUtil, PatchSetUtil psUtil, AddReviewerSender.Factory addReviewerSenderFactory, GroupsCollection groupsCollection, GroupMembers.Factory groupMembersFactory, AccountLoader.Factory accountLoaderFactory, Provider<ReviewDb> db, BatchUpdate.Factory batchUpdateFactory, Provider<IdentifiedUser> user, IdentifiedUser.GenericFactory identifiedUserFactory, @GerritServerConfig Config cfg, ReviewerJson json, ReviewerAdded reviewerAdded, NotesMigration migration, AccountCache accountCache, NotifyUtil notifyUtil) {
        this.accounts = accounts;
        this.reviewerFactory = reviewerFactory;
        this.approvalsUtil = approvalsUtil;
        this.psUtil = psUtil;
        this.addReviewerSenderFactory = addReviewerSenderFactory;
        this.groupsCollection = groupsCollection;
        this.groupMembersFactory = groupMembersFactory;
        this.accountLoaderFactory = accountLoaderFactory;
        this.dbProvider = db;
        this.batchUpdateFactory = batchUpdateFactory;
        this.user = user;
        this.identifiedUserFactory = identifiedUserFactory;
        this.cfg = cfg;
        this.json = json;
        this.reviewerAdded = reviewerAdded;
        this.migration = migration;
        this.accountCache = accountCache;
        this.notifyUtil = notifyUtil;
    }

    public AddReviewerResult apply(ChangeResource rsrc, AddReviewerInput input) throws IOException, OrmException, RestApiException, UpdateException {
        if (input.reviewer == null) {
            throw new BadRequestException("missing reviewer field");
        }
        Addition addition = this.prepareApplication(rsrc, input, true);
        if (addition.op == null) {
            return addition.result;
        }
        try (BatchUpdate bu = this.batchUpdateFactory.create(this.dbProvider.get(), rsrc.getProject(), rsrc.getUser(), TimeUtil.nowTs());){
            Change.Id id = rsrc.getChange().getId();
            bu.addOp(id, addition.op);
            bu.execute();
            addition.gatherResults();
        }
        return addition.result;
    }

    public Addition prepareApplication(ChangeResource rsrc, AddReviewerInput input, boolean allowGroup) throws OrmException, RestApiException, IOException {
        boolean accountFound;
        IdentifiedUser user;
        block7: {
            user = null;
            accountFound = true;
            boolean isExactMatch = false;
            try {
                user = this.accounts.parse(input.reviewer);
                if (input.reviewer.equalsIgnoreCase(user.getName()) || input.reviewer.equals(String.valueOf(user.getAccountId()))) {
                    isExactMatch = true;
                }
            }
            catch (UnprocessableEntityException e) {
                accountFound = false;
            }
            if (allowGroup && !isExactMatch) {
                try {
                    return this.putGroup(rsrc, input);
                }
                catch (UnprocessableEntityException e2) {
                    if (accountFound) break block7;
                    throw new UnprocessableEntityException(MessageFormat.format(ChangeMessages.get().reviewerNotFoundUserOrGroup, input.reviewer));
                }
            }
        }
        if (!accountFound) {
            throw new UnprocessableEntityException(MessageFormat.format(ChangeMessages.get().reviewerNotFoundUser, input.reviewer));
        }
        return this.putAccount(input.reviewer, this.reviewerFactory.create(rsrc, user.getAccountId()), input.state(), input.notify, this.notifyUtil.resolveAccounts(input.notifyDetails));
    }

    Addition ccCurrentUser(CurrentUser user, RevisionResource revision) {
        return new Addition(user.getUserName(), revision.getChangeResource(), ImmutableMap.of(user.getAccountId(), revision.getControl()), ReviewerState.CC, NotifyHandling.NONE, ImmutableListMultimap.of());
    }

    private Addition putAccount(String reviewer, ReviewerResource rsrc, ReviewerState state, NotifyHandling notify, ListMultimap<RecipientType, Account.Id> accountsToNotify) throws UnprocessableEntityException {
        ChangeControl control;
        Account member = rsrc.getReviewerUser().getAccount();
        if (this.isValidReviewer(member, control = rsrc.getReviewerControl())) {
            return new Addition(reviewer, rsrc.getChangeResource(), ImmutableMap.of(member.getId(), control), state, notify, accountsToNotify);
        }
        if (member.isActive()) {
            throw new UnprocessableEntityException(String.format("Change not visible to %s", reviewer));
        }
        throw new UnprocessableEntityException(String.format("Account of %s is inactive.", reviewer));
    }

    private Addition putGroup(ChangeResource rsrc, AddReviewerInput input) throws RestApiException, OrmException, IOException {
        Set<Account> members;
        GroupDescription.Basic group = this.groupsCollection.parseInternal(input.reviewer);
        if (!PostReviewers.isLegalReviewerGroup(group.getGroupUUID())) {
            return this.fail(input.reviewer, MessageFormat.format(ChangeMessages.get().groupIsNotAllowed, group.getName()));
        }
        HashMap<Account.Id, ChangeControl> reviewers = new HashMap<Account.Id, ChangeControl>();
        ChangeControl control = rsrc.getControl();
        try {
            members = this.groupMembersFactory.create(control.getUser()).listAccounts(group.getGroupUUID(), control.getProject().getNameKey());
        }
        catch (NoSuchGroupException e) {
            throw new UnprocessableEntityException(e.getMessage());
        }
        catch (NoSuchProjectException e) {
            throw new BadRequestException(e.getMessage());
        }
        int maxAllowed = this.cfg.getInt("addreviewer", "maxAllowed", 20);
        if (maxAllowed > 0 && members.size() > maxAllowed) {
            return this.fail(input.reviewer, MessageFormat.format(ChangeMessages.get().groupHasTooManyMembers, group.getName()));
        }
        int maxWithoutConfirmation = this.cfg.getInt("addreviewer", "maxWithoutConfirmation", 10);
        if (!input.confirmed() && maxWithoutConfirmation > 0 && members.size() > maxWithoutConfirmation) {
            return this.fail(input.reviewer, true, MessageFormat.format(ChangeMessages.get().groupManyMembersConfirmation, group.getName(), members.size()));
        }
        for (Account member : members) {
            if (!this.isValidReviewer(member, control)) continue;
            reviewers.put(member.getId(), control);
        }
        return new Addition(input.reviewer, rsrc, reviewers, input.state(), input.notify, this.notifyUtil.resolveAccounts(input.notifyDetails));
    }

    private boolean isValidReviewer(Account member, ChangeControl control) {
        if (member.isActive()) {
            IdentifiedUser user = this.identifiedUserFactory.create(member.getId());
            return control.forUser(user).isRefVisible();
        }
        return false;
    }

    private Addition fail(String reviewer, String error) {
        return this.fail(reviewer, false, error);
    }

    private Addition fail(String reviewer, boolean confirm, String error) {
        Addition addition = new Addition(reviewer);
        addition.result.confirm = confirm ? Boolean.valueOf(true) : null;
        addition.result.error = error;
        return addition;
    }

    public void emailReviewers(Change change, Collection<Account.Id> added, Collection<Account.Id> copied, NotifyHandling notify, ListMultimap<RecipientType, Account.Id> accountsToNotify) {
        if (added.isEmpty() && copied.isEmpty()) {
            return;
        }
        ArrayList<Account.Id> toMail = Lists.newArrayListWithCapacity(added.size());
        Account.Id userId = this.user.get().getAccountId();
        for (Account.Id id : added) {
            if (id.equals(userId)) continue;
            toMail.add(id);
        }
        ArrayList<Account.Id> toCopy = Lists.newArrayListWithCapacity(copied.size());
        for (Account.Id id : copied) {
            if (id.equals(userId)) continue;
            toCopy.add(id);
        }
        if (toMail.isEmpty() && toCopy.isEmpty()) {
            return;
        }
        try {
            AddReviewerSender addReviewerSender = this.addReviewerSenderFactory.create(change.getProject(), change.getId());
            if (notify != null) {
                addReviewerSender.setNotify(notify);
            }
            addReviewerSender.setAccountsToNotify(accountsToNotify);
            addReviewerSender.setFrom(userId);
            addReviewerSender.addReviewers(toMail);
            addReviewerSender.addExtraCC(toCopy);
            addReviewerSender.send();
        }
        catch (Exception exception) {
            log.error("Cannot send email to new reviewers of change " + change.getId(), exception);
        }
    }

    public static boolean isLegalReviewerGroup(AccountGroup.UUID groupUUID) {
        return !SystemGroupBackend.isSystemGroup(groupUUID);
    }

    public class Op
    implements BatchUpdateOp {
        final Map<Account.Id, ChangeControl> reviewers;
        final ReviewerState state;
        final NotifyHandling notify;
        final ListMultimap<RecipientType, Account.Id> accountsToNotify;
        List<PatchSetApproval> addedReviewers;
        Collection<Account.Id> addedCCs;
        private final ChangeResource rsrc;
        private PatchSet patchSet;

        Op(ChangeResource rsrc, Map<Account.Id, ChangeControl> reviewers, ReviewerState state, NotifyHandling notify, ListMultimap<RecipientType, Account.Id> accountsToNotify) {
            this.rsrc = rsrc;
            this.reviewers = reviewers;
            this.state = state;
            this.notify = notify;
            this.accountsToNotify = Preconditions.checkNotNull(accountsToNotify);
        }

        @Override
        public boolean updateChange(ChangeContext ctx) throws RestApiException, OrmException, IOException {
            if (PostReviewers.this.migration.readChanges() && this.state == ReviewerState.CC) {
                this.addedCCs = PostReviewers.this.approvalsUtil.addCcs(ctx.getNotes(), ctx.getUpdate(ctx.getChange().currentPatchSetId()), this.reviewers.keySet());
                if (this.addedCCs.isEmpty()) {
                    return false;
                }
            } else {
                this.addedReviewers = PostReviewers.this.approvalsUtil.addReviewers(ctx.getDb(), ctx.getNotes(), ctx.getUpdate(ctx.getChange().currentPatchSetId()), this.rsrc.getControl().getLabelTypes(), this.rsrc.getChange(), this.reviewers.keySet());
                if (this.addedReviewers.isEmpty()) {
                    return false;
                }
            }
            this.patchSet = PostReviewers.this.psUtil.current((ReviewDb)PostReviewers.this.dbProvider.get(), this.rsrc.getNotes());
            return true;
        }

        @Override
        public void postUpdate(Context ctx) throws Exception {
            if (this.addedReviewers != null || this.addedCCs != null) {
                if (this.addedReviewers == null) {
                    this.addedReviewers = new ArrayList<PatchSetApproval>();
                }
                if (this.addedCCs == null) {
                    this.addedCCs = new ArrayList<Account.Id>();
                }
                PostReviewers.this.emailReviewers(this.rsrc.getChange(), Lists.transform(this.addedReviewers, r -> r.getAccountId()), this.addedCCs, this.notify, this.accountsToNotify);
                if (!this.addedReviewers.isEmpty()) {
                    List<Account> reviewers = Lists.transform(this.addedReviewers, psa -> PostReviewers.this.accountCache.get(psa.getAccountId()).getAccount());
                    PostReviewers.this.reviewerAdded.fire(this.rsrc.getChange(), this.patchSet, reviewers, ctx.getAccount(), ctx.getWhen());
                }
            }
        }
    }

    public class Addition {
        final AddReviewerResult result;
        final Op op;
        private final Map<Account.Id, ChangeControl> reviewers;

        protected Addition(String reviewer) {
            this(reviewer, null, null, ReviewerState.REVIEWER, null, ImmutableListMultimap.of());
        }

        protected Addition(String reviewer, ChangeResource rsrc, Map<Account.Id, ChangeControl> reviewers, ReviewerState state, NotifyHandling notify, ListMultimap<RecipientType, Account.Id> accountsToNotify) {
            this.result = new AddReviewerResult(reviewer);
            if (reviewers == null) {
                this.reviewers = ImmutableMap.of();
                this.op = null;
                return;
            }
            this.reviewers = reviewers;
            this.op = new Op(rsrc, reviewers, state, notify, accountsToNotify);
        }

        void gatherResults() throws OrmException {
            if (PostReviewers.this.migration.readChanges() && this.op.state == ReviewerState.CC) {
                this.result.ccs = Lists.newArrayListWithCapacity(this.op.addedCCs.size());
                for (Account.Id accountId : this.op.addedCCs) {
                    this.result.ccs.add(PostReviewers.this.json.format(new ReviewerInfo(accountId.get()), this.reviewers.get(accountId)));
                }
                PostReviewers.this.accountLoaderFactory.create(true).fill(this.result.ccs);
            } else {
                this.result.reviewers = Lists.newArrayListWithCapacity(this.op.addedReviewers.size());
                for (PatchSetApproval psa : this.op.addedReviewers) {
                    this.result.reviewers.add(PostReviewers.this.json.format(new ReviewerInfo(psa.getAccountId().get()), this.reviewers.get(psa.getAccountId()), ImmutableList.of(psa)));
                }
                PostReviewers.this.accountLoaderFactory.create(true).fill(this.result.reviewers);
            }
        }
    }
}

