/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.change;

import com.google.common.base.Strings;
import com.google.gerrit.common.TimeUtil;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.DefaultInput;
import com.google.gerrit.extensions.restapi.Response;
import com.google.gerrit.extensions.restapi.RestApiException;
import com.google.gerrit.extensions.restapi.RestModifyView;
import com.google.gerrit.extensions.webui.UiAction;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.ChangeMessage;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.ChangeMessagesUtil;
import com.google.gerrit.server.change.ChangeResource;
import com.google.gerrit.server.extensions.events.TopicEdited;
import com.google.gerrit.server.notedb.ChangeUpdate;
import com.google.gerrit.server.project.ChangeControl;
import com.google.gerrit.server.update.BatchUpdate;
import com.google.gerrit.server.update.BatchUpdateOp;
import com.google.gerrit.server.update.ChangeContext;
import com.google.gerrit.server.update.Context;
import com.google.gerrit.server.update.UpdateException;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;

@Singleton
public class PutTopic
implements RestModifyView<ChangeResource, Input>,
UiAction<ChangeResource> {
    private final Provider<ReviewDb> dbProvider;
    private final ChangeMessagesUtil cmUtil;
    private final BatchUpdate.Factory batchUpdateFactory;
    private final TopicEdited topicEdited;

    @Inject
    PutTopic(Provider<ReviewDb> dbProvider, ChangeMessagesUtil cmUtil, BatchUpdate.Factory batchUpdateFactory, TopicEdited topicEdited) {
        this.dbProvider = dbProvider;
        this.cmUtil = cmUtil;
        this.batchUpdateFactory = batchUpdateFactory;
        this.topicEdited = topicEdited;
    }

    public Response<String> apply(ChangeResource req, Input input) throws UpdateException, RestApiException {
        ChangeControl ctl = req.getControl();
        if (!ctl.canEditTopicName()) {
            throw new AuthException("changing topic not permitted");
        }
        Op op = new Op(input != null ? input : new Input());
        try (BatchUpdate u = this.batchUpdateFactory.create(this.dbProvider.get(), req.getChange().getProject(), ctl.getUser(), TimeUtil.nowTs());){
            u.addOp(req.getId(), op);
            u.execute();
        }
        return Strings.isNullOrEmpty(op.newTopicName) ? Response.none() : Response.ok(op.newTopicName);
    }

    @Override
    public UiAction.Description getDescription(ChangeResource resource) {
        return new UiAction.Description().setLabel("Edit Topic").setVisible(resource.getControl().canEditTopicName());
    }

    private class Op
    implements BatchUpdateOp {
        private final Input input;
        private Change change;
        private String oldTopicName;
        private String newTopicName;

        Op(Input input) {
            this.input = input;
        }

        @Override
        public boolean updateChange(ChangeContext ctx) throws OrmException {
            this.change = ctx.getChange();
            ChangeUpdate update = ctx.getUpdate(this.change.currentPatchSetId());
            this.newTopicName = Strings.nullToEmpty(this.input.topic);
            this.oldTopicName = Strings.nullToEmpty(this.change.getTopic());
            if (this.oldTopicName.equals(this.newTopicName)) {
                return false;
            }
            String summary = this.oldTopicName.isEmpty() ? "Topic set to " + this.newTopicName : (this.newTopicName.isEmpty() ? "Topic " + this.oldTopicName + " removed" : String.format("Topic changed from %s to %s", this.oldTopicName, this.newTopicName));
            this.change.setTopic(Strings.emptyToNull(this.newTopicName));
            update.setTopic(this.change.getTopic());
            ChangeMessage cmsg = ChangeMessagesUtil.newMessage(ctx, summary, "autogenerated:gerrit:setTopic");
            PutTopic.this.cmUtil.addChangeMessage(ctx.getDb(), update, cmsg);
            return true;
        }

        @Override
        public void postUpdate(Context ctx) {
            if (this.change != null) {
                PutTopic.this.topicEdited.fire(this.change, ctx.getAccount(), this.oldTopicName, ctx.getWhen());
            }
        }
    }

    public static class Input {
        @DefaultInput
        public String topic;
    }
}

