/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.change;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.gerrit.common.data.LabelType;
import com.google.gerrit.common.data.LabelTypes;
import com.google.gerrit.common.data.LabelValue;
import com.google.gerrit.common.data.Permission;
import com.google.gerrit.common.data.PermissionRange;
import com.google.gerrit.common.data.SubmitRecord;
import com.google.gerrit.extensions.api.changes.ReviewerInfo;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.reviewdb.client.PatchSetApproval;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.ApprovalsUtil;
import com.google.gerrit.server.account.AccountLoader;
import com.google.gerrit.server.change.ReviewerResource;
import com.google.gerrit.server.project.ChangeControl;
import com.google.gerrit.server.project.SubmitRuleEvaluator;
import com.google.gerrit.server.query.change.ChangeData;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.TreeMap;

@Singleton
public class ReviewerJson {
    private final Provider<ReviewDb> db;
    private final ChangeData.Factory changeDataFactory;
    private final ApprovalsUtil approvalsUtil;
    private final AccountLoader.Factory accountLoaderFactory;

    @Inject
    ReviewerJson(Provider<ReviewDb> db, ChangeData.Factory changeDataFactory, ApprovalsUtil approvalsUtil, AccountLoader.Factory accountLoaderFactory) {
        this.db = db;
        this.changeDataFactory = changeDataFactory;
        this.approvalsUtil = approvalsUtil;
        this.accountLoaderFactory = accountLoaderFactory;
    }

    public List<ReviewerInfo> format(Collection<ReviewerResource> rsrcs) throws OrmException {
        ArrayList<ReviewerInfo> infos = Lists.newArrayListWithCapacity(rsrcs.size());
        AccountLoader loader = this.accountLoaderFactory.create(true);
        for (ReviewerResource rsrc : rsrcs) {
            ReviewerInfo info = this.format(new ReviewerInfo(rsrc.getReviewerUser().getAccountId().get()), rsrc.getReviewerControl());
            loader.put(info);
            infos.add(info);
        }
        loader.fill();
        return infos;
    }

    public List<ReviewerInfo> format(ReviewerResource rsrc) throws OrmException {
        return this.format(ImmutableList.of(rsrc));
    }

    public ReviewerInfo format(ReviewerInfo out, ChangeControl ctl) throws OrmException {
        PatchSet.Id psId = ctl.getChange().currentPatchSetId();
        return this.format(out, ctl, this.approvalsUtil.byPatchSetUser(this.db.get(), ctl, psId, new Account.Id(out._accountId)));
    }

    public ReviewerInfo format(ReviewerInfo out, ChangeControl ctl, Iterable<PatchSetApproval> approvals) throws OrmException {
        LabelTypes labelTypes = ctl.getLabelTypes();
        out.approvals = new TreeMap<String, String>(labelTypes.nameComparator());
        for (PatchSetApproval ca : approvals) {
            for (PermissionRange pr : ctl.getLabelRanges()) {
                LabelType at;
                if (pr.isEmpty() || (at = labelTypes.byLabel(ca.getLabelId())) == null) continue;
                out.approvals.put(at.getName(), LabelValue.formatValue(ca.getValue()));
            }
        }
        ChangeData cd = this.changeDataFactory.create(this.db.get(), ctl);
        PatchSet ps = cd.currentPatchSet();
        if (ps != null) {
            for (SubmitRecord rec : new SubmitRuleEvaluator(cd).setFastEvalLabels(true).setAllowDraft(true).evaluate()) {
                if (rec.labels == null) continue;
                for (SubmitRecord.Label label : rec.labels) {
                    String name = label.label;
                    if (out.approvals.containsKey(name) || ctl.getRange(Permission.forLabel(name)).isEmpty()) continue;
                    out.approvals.put(name, LabelValue.formatValue((short)0));
                }
            }
        }
        if (out.approvals.isEmpty()) {
            out.approvals = null;
        }
        return out;
    }
}

