/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.config;

import com.google.common.collect.ImmutableSet;
import com.google.gerrit.common.data.GroupReference;
import com.google.gerrit.common.data.PermissionRule;
import com.google.gerrit.server.account.GroupBackend;
import com.google.gerrit.server.account.GroupBackends;
import com.google.gerrit.server.config.GerritServerConfig;
import com.google.gerrit.server.util.RequestContext;
import com.google.gerrit.server.util.ServerRequestContext;
import com.google.gerrit.server.util.ThreadLocalRequestContext;
import com.google.inject.Inject;
import com.google.inject.Provider;
import org.eclipse.jgit.lib.Config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdministrateServerGroupsProvider
implements Provider<ImmutableSet<GroupReference>> {
    private final ImmutableSet<GroupReference> groups;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Inject
    public AdministrateServerGroupsProvider(GroupBackend groupBackend, @GerritServerConfig Config config, ThreadLocalRequestContext threadContext, ServerRequestContext serverCtx) {
        RequestContext ctx = threadContext.setContext(serverCtx);
        try {
            ImmutableSet.Builder builder = ImmutableSet.builder();
            for (String value : config.getStringList("capability", null, "administrateServer")) {
                PermissionRule rule = PermissionRule.fromString(value, false);
                String name = rule.getGroup().getName();
                GroupReference g = GroupBackends.findBestSuggestion(groupBackend, name);
                if (g != null) {
                    builder.add(g);
                    continue;
                }
                Logger log = LoggerFactory.getLogger(this.getClass());
                log.warn("Group \"{}\" not available, skipping.", (Object)name);
            }
            this.groups = builder.build();
        }
        finally {
            threadContext.setContext(ctx);
        }
    }

    @Override
    public ImmutableSet<GroupReference> get() {
        return this.groups;
    }
}

