/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.config;

import com.google.gerrit.server.account.EmailExpander;
import com.google.gerrit.server.config.GerritServerConfig;
import com.google.inject.Inject;
import com.google.inject.Provider;
import org.eclipse.jgit.lib.Config;

class EmailExpanderProvider
implements Provider<EmailExpander> {
    private final EmailExpander expander;

    @Inject
    EmailExpanderProvider(@GerritServerConfig Config cfg) {
        String s = cfg.getString("auth", null, "emailformat");
        if (EmailExpander.Simple.canHandle(s)) {
            this.expander = new EmailExpander.Simple(s);
        } else if (EmailExpander.None.canHandle(s)) {
            this.expander = EmailExpander.None.INSTANCE;
        } else {
            throw new IllegalArgumentException("Invalid auth.emailformat: " + s);
        }
    }

    @Override
    public EmailExpander get() {
        return this.expander;
    }
}

