/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.extensions.events;

import com.google.gerrit.extensions.api.changes.NotifyHandling;
import com.google.gerrit.extensions.common.AccountInfo;
import com.google.gerrit.extensions.common.ChangeInfo;
import com.google.gerrit.extensions.events.ChangeDeletedListener;
import com.google.gerrit.extensions.registration.DynamicSet;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.server.extensions.events.AbstractChangeEvent;
import com.google.gerrit.server.extensions.events.EventUtil;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.sql.Timestamp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ChangeDeleted {
    private static final Logger log = LoggerFactory.getLogger(ChangeDeleted.class);
    private final DynamicSet<ChangeDeletedListener> listeners;
    private final EventUtil util;

    @Inject
    ChangeDeleted(DynamicSet<ChangeDeletedListener> listeners, EventUtil util) {
        this.listeners = listeners;
        this.util = util;
    }

    public void fire(Change change, Account deleter, Timestamp when) {
        if (!this.listeners.iterator().hasNext()) {
            return;
        }
        try {
            Event event = new Event(this.util.changeInfo(change), this.util.accountInfo(deleter), when);
            for (ChangeDeletedListener l : this.listeners) {
                try {
                    l.onChangeDeleted(event);
                }
                catch (Exception e) {
                    this.util.logEventListenerError(this, l, e);
                }
            }
        }
        catch (OrmException e) {
            log.error("Couldn't fire event", e);
        }
    }

    private static class Event
    extends AbstractChangeEvent
    implements ChangeDeletedListener.Event {
        Event(ChangeInfo change, AccountInfo deleter, Timestamp when) {
            super(change, deleter, when, NotifyHandling.ALL);
        }
    }
}

