/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.git.validators;

import com.google.gerrit.server.git.validators.CommitValidationMessage;
import com.google.gerrit.server.validators.ValidationException;
import java.util.Collections;
import java.util.List;

public class CommitValidationException
extends ValidationException {
    private static final long serialVersionUID = 1L;
    private final List<CommitValidationMessage> messages;

    public CommitValidationException(String reason, List<CommitValidationMessage> messages) {
        super(reason);
        this.messages = messages;
    }

    public CommitValidationException(String reason) {
        super(reason);
        this.messages = Collections.emptyList();
    }

    public CommitValidationException(String reason, Throwable why) {
        super(reason, why);
        this.messages = Collections.emptyList();
    }

    public List<CommitValidationMessage> getMessages() {
        return this.messages;
    }

    public String getFullMessage() {
        StringBuilder sb = new StringBuilder(this.getMessage());
        if (!this.messages.isEmpty()) {
            sb.append(':');
            for (CommitValidationMessage msg : this.messages) {
                sb.append("\n  ").append(msg.getMessage());
            }
        }
        return sb.toString();
    }
}

