/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.git.validators;

import com.google.gerrit.extensions.registration.DynamicSet;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.server.git.IntegrationException;
import com.google.gerrit.server.git.validators.OnSubmitValidationListener;
import com.google.gerrit.server.validators.ValidationException;
import com.google.inject.Inject;
import java.util.Map;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.ReceiveCommand;

public class OnSubmitValidators {
    private final DynamicSet<OnSubmitValidationListener> listeners;

    @Inject
    OnSubmitValidators(DynamicSet<OnSubmitValidationListener> listeners) {
        this.listeners = listeners;
    }

    public void validate(Project.NameKey project, Repository repo, ObjectReader objectReader, Map<String, ReceiveCommand> commands) throws IntegrationException {
        try {
            for (OnSubmitValidationListener listener : this.listeners) {
                listener.preBranchUpdate(new OnSubmitValidationListener.Arguments(project, repo, objectReader, commands));
            }
        }
        catch (ValidationException e) {
            throw new IntegrationException(e.getMessage());
        }
    }

    public static interface Factory {
        public OnSubmitValidators create();
    }
}

