/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.git.validators;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.gerrit.extensions.registration.DynamicSet;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.events.RefReceivedEvent;
import com.google.gerrit.server.git.validators.RefOperationValidationException;
import com.google.gerrit.server.git.validators.RefOperationValidationListener;
import com.google.gerrit.server.git.validators.ValidationMessage;
import com.google.gerrit.server.validators.ValidationException;
import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.transport.ReceiveCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RefOperationValidators {
    private static final GetErrorMessages GET_ERRORS = new GetErrorMessages();
    private static final Logger LOG = LoggerFactory.getLogger(RefOperationValidators.class);
    private final RefReceivedEvent event;
    private final DynamicSet<RefOperationValidationListener> refOperationValidationListeners;

    public static ReceiveCommand getCommand(RefUpdate update, ReceiveCommand.Type type) {
        return new ReceiveCommand(update.getExpectedOldObjectId(), update.getNewObjectId(), update.getName(), type);
    }

    @Inject
    RefOperationValidators(DynamicSet<RefOperationValidationListener> refOperationValidationListeners, @Assisted Project project, @Assisted IdentifiedUser user, @Assisted ReceiveCommand cmd) {
        this.refOperationValidationListeners = refOperationValidationListeners;
        this.event = new RefReceivedEvent();
        this.event.command = cmd;
        this.event.project = project;
        this.event.user = user;
    }

    public List<ValidationMessage> validateForRefOperation() throws RefOperationValidationException {
        ArrayList<ValidationMessage> messages = new ArrayList<ValidationMessage>();
        boolean withException = false;
        try {
            for (RefOperationValidationListener listener : this.refOperationValidationListeners) {
                messages.addAll(listener.onRefOperation(this.event));
            }
        }
        catch (ValidationException e) {
            messages.add(new ValidationMessage(e.getMessage(), true));
            withException = true;
        }
        if (withException) {
            this.throwException(messages, this.event);
        }
        return messages;
    }

    private void throwException(Iterable<ValidationMessage> messages, RefReceivedEvent event) throws RefOperationValidationException {
        Iterable<ValidationMessage> errors = Iterables.filter(messages, GET_ERRORS);
        String header = String.format("Ref \"%s\" %S in project %s validation failed", new Object[]{event.command.getRefName(), event.command.getType(), event.project.getName()});
        LOG.error(header);
        throw new RefOperationValidationException(header, errors);
    }

    private static class GetErrorMessages
    implements Predicate<ValidationMessage> {
        private GetErrorMessages() {
        }

        @Override
        public boolean apply(ValidationMessage input) {
            return input.isError();
        }
    }

    public static interface Factory {
        public RefOperationValidators create(Project var1, IdentifiedUser var2, ReceiveCommand var3);
    }
}

