/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.group;

import com.google.gerrit.common.errors.NoSuchGroupException;
import com.google.gerrit.extensions.common.GroupInfo;
import com.google.gerrit.extensions.restapi.MethodNotAllowedException;
import com.google.gerrit.extensions.restapi.ResourceNotFoundException;
import com.google.gerrit.extensions.restapi.RestReadView;
import com.google.gerrit.reviewdb.client.AccountGroup;
import com.google.gerrit.server.account.GroupControl;
import com.google.gerrit.server.group.GroupJson;
import com.google.gerrit.server.group.GroupResource;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Singleton;

@Singleton
public class GetOwner
implements RestReadView<GroupResource> {
    private final GroupControl.Factory controlFactory;
    private final GroupJson json;

    @Inject
    GetOwner(GroupControl.Factory controlFactory, GroupJson json) {
        this.controlFactory = controlFactory;
        this.json = json;
    }

    public GroupInfo apply(GroupResource resource) throws MethodNotAllowedException, ResourceNotFoundException, OrmException {
        AccountGroup group = resource.toAccountGroup();
        if (group == null) {
            throw new MethodNotAllowedException();
        }
        try {
            GroupControl c = this.controlFactory.validateFor(group.getOwnerGroupUUID());
            return this.json.format(c.getGroup());
        }
        catch (NoSuchGroupException e) {
            throw new ResourceNotFoundException();
        }
    }
}

