/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.index;

import com.google.gerrit.server.index.FieldDef;
import com.google.gerrit.server.index.IndexPredicate;
import com.google.gerrit.server.query.QueryParseException;
import com.google.gerrit.server.util.RangeUtil;
import com.google.gwtorm.server.OrmException;

public abstract class IntegerRangePredicate<T>
extends IndexPredicate<T> {
    private final RangeUtil.Range range;

    protected IntegerRangePredicate(FieldDef<T, Integer> type, String value) throws QueryParseException {
        super(type, value);
        this.range = RangeUtil.getRange(value, Integer.MIN_VALUE, Integer.MAX_VALUE);
        if (this.range == null) {
            throw new QueryParseException("Invalid range predicate: " + value);
        }
    }

    protected abstract Integer getValueInt(T var1) throws OrmException;

    public boolean match(T object) throws OrmException {
        Integer valueInt = this.getValueInt(object);
        if (valueInt == null) {
            return false;
        }
        return valueInt >= this.range.min && valueInt <= this.range.max;
    }

    public int getMinimumValue() {
        return this.range.min;
    }

    public int getMaximumValue() {
        return this.range.max;
    }
}

