/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.patch;

import com.google.gerrit.server.patch.ComparisonType;
import com.google.gerrit.server.patch.MergeListBuilder;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.text.SimpleDateFormat;
import org.eclipse.jgit.diff.RawText;
import org.eclipse.jgit.errors.LargeObjectException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.util.RawParseUtils;
import org.mozilla.universalchardet.UniversalDetector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Text
extends RawText {
    private static final Logger log = LoggerFactory.getLogger(Text.class);
    private static final int bigFileThreshold = 0x3200000;
    public static final byte[] NO_BYTES = new byte[0];
    public static final Text EMPTY = new Text(NO_BYTES);
    private Charset charset;

    public static Text forCommit(ObjectReader reader, AnyObjectId commitId) throws IOException {
        try (RevWalk rw = new RevWalk(reader);){
            RevCommit c = commitId instanceof RevCommit ? (RevCommit)commitId : rw.parseCommit(commitId);
            StringBuilder b = new StringBuilder();
            switch (c.getParentCount()) {
                case 0: {
                    break;
                }
                case 1: {
                    RevCommit p = c.getParent(0);
                    rw.parseBody(p);
                    b.append("Parent:     ");
                    b.append(reader.abbreviate(p, 8).name());
                    b.append(" (");
                    b.append(p.getShortMessage());
                    b.append(")\n");
                    break;
                }
                default: {
                    for (int i = 0; i < c.getParentCount(); ++i) {
                        RevCommit p = c.getParent(i);
                        rw.parseBody(p);
                        b.append(i == 0 ? "Merge Of:   " : "            ");
                        b.append(reader.abbreviate(p, 8).name());
                        b.append(" (");
                        b.append(p.getShortMessage());
                        b.append(")\n");
                    }
                }
            }
            Text.appendPersonIdent(b, "Author", c.getAuthorIdent());
            Text.appendPersonIdent(b, "Commit", c.getCommitterIdent());
            b.append("\n");
            b.append(c.getFullMessage());
            Text text = new Text(b.toString().getBytes(StandardCharsets.UTF_8));
            return text;
        }
    }

    public static Text forMergeList(ComparisonType comparisonType, ObjectReader reader, AnyObjectId commitId) throws IOException {
        try (RevWalk rw = new RevWalk(reader);){
            RevCommit c = rw.parseCommit(commitId);
            StringBuilder b = new StringBuilder();
            switch (c.getParentCount()) {
                case 0: {
                    break;
                }
                case 1: {
                    break;
                }
                default: {
                    int uniterestingParent = comparisonType.isAgainstParent() ? comparisonType.getParentNum() : 1;
                    b.append("Merge List:\n\n");
                    for (RevCommit commit : MergeListBuilder.build(rw, c, uniterestingParent)) {
                        b.append("* ");
                        b.append(reader.abbreviate(commit, 8).name());
                        b.append(" ");
                        b.append(commit.getShortMessage());
                        b.append("\n");
                    }
                }
            }
            Text text = new Text(b.toString().getBytes(StandardCharsets.UTF_8));
            return text;
        }
    }

    private static void appendPersonIdent(StringBuilder b, String field, PersonIdent person) {
        if (person != null) {
            b.append(field).append(":    ");
            if (person.getName() != null) {
                b.append(" ");
                b.append(person.getName());
            }
            if (person.getEmailAddress() != null) {
                b.append(" <");
                b.append(person.getEmailAddress());
                b.append(">");
            }
            b.append("\n");
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss ZZZ");
            sdf.setTimeZone(person.getTimeZone());
            b.append(field).append("Date: ");
            b.append(sdf.format(person.getWhen()));
            b.append("\n");
        }
    }

    public static byte[] asByteArray(ObjectLoader ldr) throws MissingObjectException, LargeObjectException, IOException {
        return ldr.getCachedBytes(0x3200000);
    }

    private static Charset charset(byte[] content, String encoding) {
        if (encoding == null) {
            UniversalDetector d = new UniversalDetector(null);
            d.handleData(content, 0, content.length);
            d.dataEnd();
            encoding = d.getDetectedCharset();
        }
        if (encoding == null) {
            return StandardCharsets.ISO_8859_1;
        }
        try {
            return Charset.forName(encoding);
        }
        catch (IllegalCharsetNameException err) {
            log.error("Invalid detected charset name '" + encoding + "': " + err);
            return StandardCharsets.ISO_8859_1;
        }
        catch (UnsupportedCharsetException err) {
            log.error("Detected charset '" + encoding + "' not supported: " + err);
            return StandardCharsets.ISO_8859_1;
        }
    }

    public Text(byte[] r) {
        super(r);
    }

    public Text(ObjectLoader ldr) throws MissingObjectException, LargeObjectException, IOException {
        this(Text.asByteArray(ldr));
    }

    public byte[] getContent() {
        return this.content;
    }

    @Override
    protected String decode(int s, int e) {
        if (this.charset == null) {
            this.charset = Text.charset(this.content, null);
        }
        return RawParseUtils.decode(this.charset, this.content, s, e);
    }
}

