/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.plugins;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.jar.JarFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CleanupHandle {
    private static final Logger log = LoggerFactory.getLogger(CleanupHandle.class);
    private final Path tmp;
    private final JarFile jarFile;

    CleanupHandle(Path tmp, JarFile jarFile) {
        this.tmp = tmp;
        this.jarFile = jarFile;
    }

    void cleanup() {
        try {
            this.jarFile.close();
        }
        catch (IOException err) {
            log.error("Cannot close " + this.jarFile.getName(), err);
        }
        try {
            Files.deleteIfExists(this.tmp);
            log.info("Cleaned plugin " + this.tmp.getFileName());
        }
        catch (IOException e) {
            log.warn("Cannot delete " + this.tmp.toAbsolutePath() + ", retrying to delete it on termination of the virtual machine", e);
            this.tmp.toFile().deleteOnExit();
        }
    }
}

